/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.lazy.staggeredgrid;

import androidx.compose.foundation.internal.InlineClassHelperKt;
import androidx.compose.runtime.internal.StabilityInferred;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0011\b\u0001\u0018\u0000 !2\u00020\u0001:\u0002 !B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005J\u000e\u0010\u000f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005J\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0005J\u0006\u0010\u0013\u001a\u00020\u0005J\u0006\u0010\u0014\u001a\u00020\u0005J\u0006\u0010\u0015\u001a\u00020\fJ\u0016\u0010\u0016\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0005J\u0016\u0010\u0017\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0005J\u000e\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u0005J\u0018\u0010\u001a\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00052\b\u0010\u001b\u001a\u0004\u0018\u00010\u0007J\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u00072\u0006\u0010\r\u001a\u00020\u0005J\u001a\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u00052\b\b\u0002\u0010\u001f\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Landroidx/compose/foundation/lazy/staggeredgrid/LazyStaggeredGridLaneInfo;", "", "<init>", "()V", "anchor", "", "lanes", "", "spannedItems", "Lkotlin/collections/ArrayDeque;", "Landroidx/compose/foundation/lazy/staggeredgrid/LazyStaggeredGridLaneInfo$SpannedItem;", "setLane", "", "itemIndex", "lane", "getLane", "assignedToLane", "", "targetLane", "upperBound", "lowerBound", "reset", "findPreviousItemIndex", "findNextItemIndex", "ensureValidIndex", "requestedIndex", "setGaps", "gaps", "getGaps", "ensureCapacity", "capacity", "newOffset", "SpannedItem", "Companion", "foundation"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nLazyStaggeredGridLaneInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LazyStaggeredGridLaneInfo.kt\nandroidx/compose/foundation/lazy/staggeredgrid/LazyStaggeredGridLaneInfo\n+ 2 InlineClassHelper.kt\nandroidx/compose/foundation/internal/InlineClassHelperKt\n+ 3 Collections.kt\nkotlin/collections/CollectionsKt__CollectionsKt\n*L\n1#1,206:1\n97#2,4:207\n97#2,4:225\n403#3,7:211\n403#3,7:218\n*S KotlinDebug\n*F\n+ 1 LazyStaggeredGridLaneInfo.kt\nandroidx/compose/foundation/lazy/staggeredgrid/LazyStaggeredGridLaneInfo\n*L\n36#1:207,4\n190#1:225,4\n165#1:211,7\n185#1:218,7\n*E\n"})
public final class LazyStaggeredGridLaneInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int anchor;
    @NotNull
    private int[] lanes = new int[16];
    @NotNull
    private final ArrayDeque<SpannedItem> spannedItems = new ArrayDeque();
    public static final int $stable = 8;
    private static final int MaxCapacity = 131072;
    public static final int Unset = -1;
    public static final int FullSpan = -2;

    public final void setLane(int itemIndex, int lane) {
        boolean value$iv = itemIndex >= 0;
        boolean $i$f$requirePrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            InlineClassHelperKt.throwIllegalArgumentException("Negative lanes are not supported");
        }
        this.ensureValidIndex(itemIndex);
        this.lanes[itemIndex - this.anchor] = lane + 1;
    }

    public final int getLane(int itemIndex) {
        if (itemIndex < this.lowerBound() || itemIndex >= this.upperBound()) {
            return -1;
        }
        return this.lanes[itemIndex - this.anchor] - 1;
    }

    public final boolean assignedToLane(int itemIndex, int targetLane) {
        int lane = this.getLane(itemIndex);
        return lane == targetLane || lane == -1 || lane == -2;
    }

    public final int upperBound() {
        return this.anchor + this.lanes.length;
    }

    public final int lowerBound() {
        return this.anchor;
    }

    public final void reset() {
        ArraysKt.fill$default((int[])this.lanes, (int)0, (int)0, (int)0, (int)6, null);
        this.spannedItems.clear();
    }

    public final int findPreviousItemIndex(int itemIndex, int targetLane) {
        for (int i = itemIndex - 1; -1 < i; --i) {
            if (!this.assignedToLane(i, targetLane)) continue;
            return i;
        }
        return -1;
    }

    public final int findNextItemIndex(int itemIndex, int targetLane) {
        int n = this.upperBound();
        for (int i = itemIndex + 1; i < n; ++i) {
            if (!this.assignedToLane(i, targetLane)) continue;
            return i;
        }
        return this.upperBound();
    }

    public final void ensureValidIndex(int requestedIndex) {
        int requestedCapacity = requestedIndex - this.anchor;
        boolean bl = 0 <= requestedCapacity ? requestedCapacity < 131072 : false;
        if (bl) {
            LazyStaggeredGridLaneInfo.ensureCapacity$default(this, requestedCapacity + 1, 0, 2, null);
        } else {
            int oldAnchor = this.anchor;
            this.anchor = Math.max(requestedIndex - this.lanes.length / 2, 0);
            int delta = this.anchor - oldAnchor;
            if (delta >= 0) {
                if (delta < this.lanes.length) {
                    ArraysKt.copyInto((int[])this.lanes, (int[])this.lanes, (int)0, (int)delta, (int)this.lanes.length);
                }
                ArraysKt.fill((int[])this.lanes, (int)0, (int)Math.max(0, this.lanes.length - delta), (int)this.lanes.length);
            } else if (this.lanes.length + (delta = -delta) < 131072) {
                this.ensureCapacity(this.lanes.length + delta + 1, delta);
            } else {
                if (delta < this.lanes.length) {
                    ArraysKt.copyInto((int[])this.lanes, (int[])this.lanes, (int)delta, (int)0, (int)(this.lanes.length - delta));
                }
                ArraysKt.fill((int[])this.lanes, (int)0, (int)0, (int)Math.min(this.lanes.length, delta));
            }
        }
        while (!((Collection)this.spannedItems).isEmpty() && ((SpannedItem)this.spannedItems.first()).getIndex() < this.lowerBound()) {
            this.spannedItems.removeFirst();
        }
        while (!((Collection)this.spannedItems).isEmpty() && ((SpannedItem)this.spannedItems.last()).getIndex() > this.upperBound()) {
            this.spannedItems.removeLast();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void setGaps(int itemIndex, @Nullable int[] gaps) {
        void $this$binarySearchBy_u24default$iv;
        List list = (List)this.spannedItems;
        Comparable key$iv = Integer.valueOf(itemIndex);
        int fromIndex$iv = 0;
        int toIndex$iv = $this$binarySearchBy_u24default$iv.size();
        boolean $i$f$binarySearchBy = false;
        int foundIndex = CollectionsKt.binarySearch((List)$this$binarySearchBy_u24default$iv, (int)fromIndex$iv, (int)toIndex$iv, (Function1)((Function1)new Function1<SpannedItem, Integer>(key$iv){
            final /* synthetic */ Comparable $key;
            {
                this.$key = $key;
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final Integer invoke(Object it) {
                SpannedItem it2 = (SpannedItem)it;
                boolean bl = false;
                return ComparisonsKt.compareValues((Comparable)Integer.valueOf(it2.getIndex()), (Comparable)this.$key);
            }
        }));
        if (foundIndex < 0) {
            if (gaps == null) {
                return;
            }
            int insertionIndex = -(foundIndex + 1);
            this.spannedItems.add(insertionIndex, (Object)new SpannedItem(itemIndex, gaps));
        } else if (gaps == null) {
            this.spannedItems.remove(foundIndex);
        } else {
            ((SpannedItem)this.spannedItems.get(foundIndex)).setGaps(gaps);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final int[] getGaps(int itemIndex) {
        void $this$binarySearchBy_u24default$iv;
        List list = (List)this.spannedItems;
        Comparable key$iv = Integer.valueOf(itemIndex);
        int fromIndex$iv = 0;
        int toIndex$iv = $this$binarySearchBy_u24default$iv.size();
        boolean $i$f$binarySearchBy = false;
        int foundIndex = CollectionsKt.binarySearch((List)$this$binarySearchBy_u24default$iv, (int)fromIndex$iv, (int)toIndex$iv, (Function1)((Function1)new Function1<SpannedItem, Integer>(key$iv){
            final /* synthetic */ Comparable $key;
            {
                this.$key = $key;
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final Integer invoke(Object it) {
                SpannedItem it2 = (SpannedItem)it;
                boolean bl = false;
                return ComparisonsKt.compareValues((Comparable)Integer.valueOf(it2.getIndex()), (Comparable)this.$key);
            }
        }));
        SpannedItem spannedItem = (SpannedItem)CollectionsKt.getOrNull((List)((List)this.spannedItems), (int)foundIndex);
        return (int[])(spannedItem != null ? spannedItem.getGaps() : null);
    }

    private final void ensureCapacity(int capacity, int newOffset) {
        boolean value$iv = capacity <= 131072;
        boolean $i$f$requirePrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            InlineClassHelperKt.throwIllegalArgumentException("Requested item capacity " + capacity + " is larger than max supported: 131072!");
        }
        if (this.lanes.length < capacity) {
            int newSize;
            for (newSize = this.lanes.length; newSize < capacity; newSize *= 2) {
            }
            this.lanes = ArraysKt.copyInto$default((int[])this.lanes, (int[])new int[newSize], (int)newOffset, (int)0, (int)0, (int)12, null);
        }
    }

    static /* synthetic */ void ensureCapacity$default(LazyStaggeredGridLaneInfo lazyStaggeredGridLaneInfo, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = 0;
        }
        lazyStaggeredGridLaneInfo.ensureCapacity(n, n2);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Landroidx/compose/foundation/lazy/staggeredgrid/LazyStaggeredGridLaneInfo$Companion;", "", "<init>", "()V", "MaxCapacity", "", "Unset", "FullSpan", "foundation"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Landroidx/compose/foundation/lazy/staggeredgrid/LazyStaggeredGridLaneInfo$SpannedItem;", "", "index", "", "gaps", "", "<init>", "(I[I)V", "getIndex", "()I", "getGaps", "()[I", "setGaps", "([I)V", "foundation"})
    private static final class SpannedItem {
        private final int index;
        @NotNull
        private int[] gaps;

        public SpannedItem(int index, @NotNull int[] gaps) {
            Intrinsics.checkNotNullParameter((Object)gaps, (String)"gaps");
            this.index = index;
            this.gaps = gaps;
        }

        public final int getIndex() {
            return this.index;
        }

        @NotNull
        public final int[] getGaps() {
            return this.gaps;
        }

        public final void setGaps(@NotNull int[] nArray) {
            Intrinsics.checkNotNullParameter((Object)nArray, (String)"<set-?>");
            this.gaps = nArray;
        }
    }
}

