/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.viewinterop;

import androidx.compose.runtime.Composable;
import androidx.compose.runtime.ComposableInferredTarget;
import androidx.compose.runtime.ComposableTarget;
import androidx.compose.runtime.Composer;
import androidx.compose.runtime.ComposerKt;
import androidx.compose.runtime.CompositionLocalKt;
import androidx.compose.runtime.ProvidedValue;
import androidx.compose.runtime.RecomposeScopeImplKt;
import androidx.compose.runtime.ScopeUpdateScope;
import androidx.compose.runtime.internal.ComposableLambdaKt;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.runtime.snapshots.SnapshotStateObserver;
import androidx.compose.ui.viewinterop.InteropContainer;
import androidx.compose.ui.viewinterop.InteropContainer_skikoKt;
import androidx.compose.ui.viewinterop.InteropViewHolder;
import androidx.compose.ui.viewinterop.ScheduledUpdatesSwapchain;
import androidx.compose.ui.viewinterop.TrackInteropPlacementModifierNode;
import java.awt.Component;
import java.awt.Container;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skiko.ClipRectangle;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001B)\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\"\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\u0015H\u0016J\u0016\u0010$\u001a\u0004\u0018\u00010\u00152\n\u0010%\u001a\u00060&j\u0002`'H\u0016J\b\u0010(\u001a\u00020\tH\u0002J\u0010\u0010)\u001a\u00020\t2\u0006\u0010#\u001a\u00020\u0015H\u0016J\u0010\u0010*\u001a\u00020\t2\u0006\u0010#\u001a\u00020\u0015H\u0016J\b\u0010+\u001a\u00020\tH\u0002J\u0006\u0010,\u001a\u00020\tJ\u0014\u0010-\u001a\u00020\t2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\t0\bJ\u0016\u0010/\u001a\u00020\t2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\u000e\u00101\u001a\u0002022\u0006\u00103\u001a\u000204J!\u00105\u001a\u00020\t2\u0011\u00106\u001a\r\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\b7H\u0087\u0002\u00a2\u0006\u0002\u00108R\u0018\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR$\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001e\u0010\u0013\u001a\u0012\u0012\b\u0012\u00060\u0003j\u0002`\u0004\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u001dX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Landroidx/compose/ui/viewinterop/SwingInteropContainer;", "Landroidx/compose/ui/viewinterop/InteropContainer;", "root", "Ljava/awt/Container;", "Landroidx/compose/ui/viewinterop/InteropViewGroup;", "placeInteropAbove", "", "requestRedraw", "Lkotlin/Function0;", "", "<init>", "(Ljava/awt/Container;ZLkotlin/jvm/functions/Function0;)V", "getRoot", "()Ljava/awt/Container;", "value", "getPlaceInteropAbove", "()Z", "setPlaceInteropAbove", "(Z)V", "interopComponents", "", "Landroidx/compose/ui/viewinterop/InteropViewHolder;", "rootModifier", "Landroidx/compose/ui/viewinterop/TrackInteropPlacementModifierNode;", "getRootModifier", "()Landroidx/compose/ui/viewinterop/TrackInteropPlacementModifierNode;", "setRootModifier", "(Landroidx/compose/ui/viewinterop/TrackInteropPlacementModifierNode;)V", "snapshotObserver", "Landroidx/compose/runtime/snapshots/SnapshotStateObserver;", "getSnapshotObserver", "()Landroidx/compose/runtime/snapshots/SnapshotStateObserver;", "scheduledUpdatesSwapchain", "Landroidx/compose/ui/viewinterop/ScheduledUpdatesSwapchain;", "contains", "holder", "holderOfView", "view", "", "Landroidx/compose/ui/viewinterop/InteropView;", "updateInteropComponentsOrder", "place", "unplace", "executeScheduledUpdates", "dispose", "postponingExecutingScheduledUpdates", "body", "scheduleUpdate", "action", "getClipRectForComponent", "Lorg/jetbrains/skiko/ClipRectangle;", "component", "Ljava/awt/Component;", "invoke", "content", "Landroidx/compose/runtime/Composable;", "(Lkotlin/jvm/functions/Function2;Landroidx/compose/runtime/Composer;I)V", "ui"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nSwingInteropContainer.desktop.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwingInteropContainer.desktop.kt\nandroidx/compose/ui/viewinterop/SwingInteropContainer\n+ 2 SwingInteropContainer.desktop.kt\nandroidx/compose/ui/viewinterop/ScheduledUpdatesSwapchain\n*L\n1#1,282:1\n60#2,16:283\n*S KotlinDebug\n*F\n+ 1 SwingInteropContainer.desktop.kt\nandroidx/compose/ui/viewinterop/SwingInteropContainer\n*L\n250#1:283,16\n*E\n"})
public final class SwingInteropContainer
implements InteropContainer {
    @NotNull
    private final Container root;
    private boolean placeInteropAbove;
    @NotNull
    private Map<Container, InteropViewHolder> interopComponents;
    @Nullable
    private TrackInteropPlacementModifierNode rootModifier;
    @NotNull
    private final SnapshotStateObserver snapshotObserver;
    @NotNull
    private final ScheduledUpdatesSwapchain scheduledUpdatesSwapchain;
    public static final int $stable = 8;

    public SwingInteropContainer(@NotNull Container root, boolean placeInteropAbove, @NotNull Function0<Unit> requestRedraw) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter(requestRedraw, (String)"requestRedraw");
        this.root = root;
        this.placeInteropAbove = placeInteropAbove;
        this.interopComponents = new LinkedHashMap();
        this.snapshotObserver = new SnapshotStateObserver(SwingInteropContainer::snapshotObserver$lambda$0);
        this.scheduledUpdatesSwapchain = new ScheduledUpdatesSwapchain(requestRedraw);
    }

    @Override
    @NotNull
    public Container getRoot() {
        return this.root;
    }

    public final boolean getPlaceInteropAbove() {
        return this.placeInteropAbove;
    }

    public final void setPlaceInteropAbove(boolean value) {
        if (this.placeInteropAbove != value) {
            this.placeInteropAbove = value;
            this.updateInteropComponentsOrder();
        }
    }

    @Override
    @Nullable
    public TrackInteropPlacementModifierNode getRootModifier() {
        return this.rootModifier;
    }

    @Override
    public void setRootModifier(@Nullable TrackInteropPlacementModifierNode trackInteropPlacementModifierNode) {
        this.rootModifier = trackInteropPlacementModifierNode;
    }

    @Override
    @NotNull
    public SnapshotStateObserver getSnapshotObserver() {
        return this.snapshotObserver;
    }

    @Override
    public boolean contains(@NotNull InteropViewHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return this.interopComponents.containsKey(holder.getGroup());
    }

    @Override
    @Nullable
    public InteropViewHolder holderOfView(@NotNull Object view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Component component = (Component)view;
        Container container2 = component.getParent();
        if (container2 == null) {
            boolean bl = false;
            String string = "InteropView is assumed to be added to its group for its entire lifetime";
            throw new IllegalStateException(string.toString());
        }
        Container group = container2;
        return this.interopComponents.get(group);
    }

    private final void updateInteropComponentsOrder() {
        List<InteropViewHolder> orderedInteropComponents = InteropContainer_skikoKt.interopComponentsSortedByDrawOrder(this, this.interopComponents.values());
        this.scheduleUpdate((Function0<Unit>)((Function0)() -> SwingInteropContainer.updateInteropComponentsOrder$lambda$2(this, orderedInteropComponents)));
    }

    @Override
    public void place(@NotNull InteropViewHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Container group = holder.getGroup();
        if (this.interopComponents.isEmpty()) {
            this.getSnapshotObserver().start();
        }
        boolean isNewInteropView = this.interopComponents.putIfAbsent(group, holder) == null;
        int interopComponentsCount = this.interopComponents.size();
        int interopComponentsBelowCount = InteropContainer_skikoKt.countInteropComponentsBelow(this, holder);
        this.scheduleUpdate((Function0<Unit>)((Function0)() -> SwingInteropContainer.place$lambda$3(interopComponentsCount, this, isNewInteropView, interopComponentsBelowCount, holder)));
    }

    @Override
    public void unplace(@NotNull InteropViewHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        this.scheduleUpdate((Function0<Unit>)((Function0)() -> SwingInteropContainer.unplace$lambda$4(holder, this)));
        this.interopComponents.remove(holder.getGroup());
        if (this.interopComponents.isEmpty()) {
            this.getSnapshotObserver().stop();
        }
    }

    private final void executeScheduledUpdates() {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Check failed.");
        }
        boolean hasAnyUpdates = this.scheduledUpdatesSwapchain.execute();
        if (hasAnyUpdates) {
            this.getRoot().validate();
            this.getRoot().repaint();
        }
    }

    public final void dispose() {
        this.executeScheduledUpdates();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void postponingExecutingScheduledUpdates(@NotNull Function0<Unit> body) {
        Object object;
        Intrinsics.checkNotNullParameter(body, (String)"body");
        ScheduledUpdatesSwapchain this_$iv = this.scheduledUpdatesSwapchain;
        boolean $i$f$preventingRedrawRequests = false;
        try {
            object = ScheduledUpdatesSwapchain.access$getLock$p(this_$iv);
            synchronized (object) {
                boolean $i$a$-synchronized-ScheduledUpdatesSwapchain$preventingRedrawRequests$1$iv22 = false;
                if (!ScheduledUpdatesSwapchain.access$getNeedsRequestRedrawOnUpdateScheduled$p(this_$iv)) {
                    boolean $i$a$-check-ScheduledUpdatesSwapchain$preventingRedrawRequests$1$1$iv22 = false;
                    String $i$a$-check-ScheduledUpdatesSwapchain$preventingRedrawRequests$1$1$iv22 = "Reentry into ignoringRedrawRequests is not allowed";
                    throw new IllegalStateException($i$a$-check-ScheduledUpdatesSwapchain$preventingRedrawRequests$1$1$iv22.toString());
                }
                ScheduledUpdatesSwapchain.access$setNeedsRequestRedrawOnUpdateScheduled$p(this_$iv, false);
                Unit $i$a$-synchronized-ScheduledUpdatesSwapchain$preventingRedrawRequests$1$iv22 = Unit.INSTANCE;
            }
            boolean bl = false;
            body.invoke();
        }
        finally {
            object = ScheduledUpdatesSwapchain.access$getLock$p(this_$iv);
            synchronized (object) {
                boolean bl = false;
                ScheduledUpdatesSwapchain.access$setNeedsRequestRedrawOnUpdateScheduled$p(this_$iv, true);
                Unit unit = Unit.INSTANCE;
            }
        }
        this.executeScheduledUpdates();
    }

    @Override
    public void scheduleUpdate(@NotNull Function0<Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        this.scheduledUpdatesSwapchain.scheduleUpdate(action);
    }

    @NotNull
    public final ClipRectangle getClipRectForComponent(@NotNull Component component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        InteropViewHolder interopViewHolder = this.interopComponents.get(component);
        if (interopViewHolder == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        Intrinsics.checkNotNull((Object)interopViewHolder, (String)"null cannot be cast to non-null type org.jetbrains.skiko.ClipRectangle");
        return (ClipRectangle)interopViewHolder;
    }

    @Composable
    @ComposableInferredTarget(scheme="[androidx.compose.ui.UiComposable[androidx.compose.ui.UiComposable]]")
    public final void invoke(@NotNull Function2<? super Composer, ? super Integer, Unit> content, @Nullable Composer $composer, int $changed) {
        block6: {
            Intrinsics.checkNotNullParameter(content, (String)"content");
            $composer = $composer.startRestartGroup(-1827244710);
            ComposerKt.sourceInformation((Composer)$composer, (String)"C(invoke)274@9496L103,272@9411L188:SwingInteropContainer.desktop.kt#z33iqn");
            int $dirty = $changed;
            if (($changed & 6) == 0) {
                $dirty |= $composer.changedInstance(content) ? 4 : 2;
            }
            if (($changed & 0x30) == 0) {
                $dirty |= $composer.changedInstance((Object)this) ? 32 : 16;
            }
            if (($dirty & 0x13) != 18 || !$composer.getSkipping()) {
                if (ComposerKt.isTraceInProgress()) {
                    ComposerKt.traceEventStart((int)-1827244710, (int)$dirty, (int)-1, (String)"androidx.compose.ui.viewinterop.SwingInteropContainer.invoke (SwingInteropContainer.desktop.kt:271)");
                }
                CompositionLocalKt.CompositionLocalProvider((ProvidedValue)InteropContainer_skikoKt.getLocalInteropContainer().provides((Object)this), (Function2)((Function2)ComposableLambdaKt.rememberComposableLambda((int)-1220154854, (boolean)true, (Object)new Function2<Composer, Integer, Unit>(this, content){
                    final /* synthetic */ SwingInteropContainer this$0;
                    final /* synthetic */ Function2<Composer, Integer, Unit> $content;
                    {
                        this.this$0 = $receiver;
                        this.$content = $content;
                    }

                    @Composable
                    @ComposableTarget(applier="androidx.compose.ui.UiComposable")
                    public final void invoke(Composer $composer, int $changed) {
                        ComposerKt.sourceInformation((Composer)$composer, (String)"C275@9510L79:SwingInteropContainer.desktop.kt#z33iqn");
                        if (($changed & 3) != 2 || !$composer.getSkipping()) {
                            if (ComposerKt.isTraceInProgress()) {
                                ComposerKt.traceEventStart((int)-1220154854, (int)$changed, (int)-1, (String)"androidx.compose.ui.viewinterop.SwingInteropContainer.invoke.<anonymous> (SwingInteropContainer.desktop.kt:275)");
                            }
                            InteropContainer_skikoKt.TrackInteropPlacementContainer(this.this$0, this.$content, $composer, 0);
                            if (ComposerKt.isTraceInProgress()) {
                                ComposerKt.traceEventEnd();
                            }
                        } else {
                            $composer.skipToGroupEnd();
                        }
                    }
                }, (Composer)$composer, (int)54)), (Composer)$composer, (int)(0x30 | ProvidedValue.$stable));
                if (ComposerKt.isTraceInProgress()) {
                    ComposerKt.traceEventEnd();
                }
            } else {
                $composer.skipToGroupEnd();
            }
            ScopeUpdateScope scopeUpdateScope = $composer.endRestartGroup();
            if (scopeUpdateScope == null) break block6;
            scopeUpdateScope.updateScope((arg_0, arg_1) -> SwingInteropContainer.invoke$lambda$6(this, content, $changed, arg_0, arg_1));
        }
    }

    private static final Unit snapshotObserver$lambda$0(Function0 command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        command.invoke();
        return Unit.INSTANCE;
    }

    private static final Unit updateInteropComponentsOrder$lambda$2(SwingInteropContainer this$0, List $orderedInteropComponents) {
        int allComponentCount = this$0.getRoot().getComponents().length;
        Iterator iterator2 = ((Iterable)CollectionsKt.asReversed((List)$orderedInteropComponents)).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int index = n++;
            InteropViewHolder holder = (InteropViewHolder)iterator2.next();
            holder.changeInteropViewIndex(this$0.getRoot(), this$0.placeInteropAbove ? allComponentCount - 1 : index);
        }
        return Unit.INSTANCE;
    }

    private static final Unit place$lambda$3(int $interopComponentsCount, SwingInteropContainer this$0, boolean $isNewInteropView, int $interopComponentsBelowCount, InteropViewHolder $holder) {
        int lastInteropIndex = $interopComponentsCount - 1;
        if (!this$0.placeInteropAbove) {
            int existingInteropComponentCount = $interopComponentsCount - ($isNewInteropView ? 1 : 0);
            lastInteropIndex += this$0.getRoot().getComponentCount() - existingInteropComponentCount;
        }
        int awtIndex = lastInteropIndex - $interopComponentsBelowCount;
        if ($isNewInteropView) {
            $holder.insertInteropView(this$0.getRoot(), awtIndex);
        } else {
            $holder.changeInteropViewIndex(this$0.getRoot(), awtIndex);
        }
        return Unit.INSTANCE;
    }

    private static final Unit unplace$lambda$4(InteropViewHolder $holder, SwingInteropContainer this$0) {
        $holder.removeInteropView(this$0.getRoot());
        return Unit.INSTANCE;
    }

    private static final Unit invoke$lambda$6(SwingInteropContainer $tmp0_rcvr, Function2 $content, int $$changed, Composer $composer, int $force) {
        $tmp0_rcvr.invoke((Function2<? super Composer, ? super Integer, Unit>)$content, $composer, RecomposeScopeImplKt.updateChangedFlags((int)($$changed | 1)));
        return Unit.INSTANCE;
    }
}

