/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.paging;

import androidx.annotation.RestrictTo;
import androidx.paging.PagingSource;
import androidx.paging.PagingState;
import androidx.room.RoomDatabase;
import androidx.room.RoomRawQuery;
import androidx.room.paging.CommonLimitOffsetImpl;
import androidx.room.paging.util.RoomPagingUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\b'\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u0002H\u00010\u0003B+\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0012\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n\"\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ(\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00028\u00000\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00040\u001eH\u0096@\u00a2\u0006\u0002\u0010\u001fJ#\u0010 \u001a\u0004\u0018\u00010\u00042\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00028\u00000\"H\u0016\u00a2\u0006\u0002\u0010#J$\u0010$\u001a\b\u0012\u0004\u0012\u00028\u00000%2\u0006\u0010&\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0004H\u0094@\u00a2\u0006\u0002\u0010'R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006("}, d2={"Landroidx/room/paging/LimitOffsetPagingSource;", "Value", "", "Landroidx/paging/PagingSource;", "", "sourceQuery", "Landroidx/room/RoomRawQuery;", "db", "Landroidx/room/RoomDatabase;", "tables", "", "", "<init>", "(Landroidx/room/RoomRawQuery;Landroidx/room/RoomDatabase;[Ljava/lang/String;)V", "getSourceQuery", "()Landroidx/room/RoomRawQuery;", "getDb", "()Landroidx/room/RoomDatabase;", "implementation", "Landroidx/room/paging/CommonLimitOffsetImpl;", "itemCount", "getItemCount", "()I", "jumpingSupported", "", "getJumpingSupported", "()Z", "load", "Landroidx/paging/PagingSource$LoadResult;", "params", "Landroidx/paging/PagingSource$LoadParams;", "(Landroidx/paging/PagingSource$LoadParams;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getRefreshKey", "state", "Landroidx/paging/PagingState;", "(Landroidx/paging/PagingState;)Ljava/lang/Integer;", "convertRows", "", "limitOffsetQuery", "(Landroidx/room/RoomRawQuery;ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "room-paging"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public abstract class LimitOffsetPagingSource<Value>
extends PagingSource<Integer, Value> {
    @NotNull
    private final RoomRawQuery sourceQuery;
    @NotNull
    private final RoomDatabase db;
    @NotNull
    private final CommonLimitOffsetImpl<Value> implementation;

    public LimitOffsetPagingSource(@NotNull RoomRawQuery sourceQuery, @NotNull RoomDatabase db, String ... tables) {
        Intrinsics.checkNotNullParameter((Object)sourceQuery, (String)"sourceQuery");
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        Intrinsics.checkNotNullParameter((Object)tables, (String)"tables");
        this.sourceQuery = sourceQuery;
        this.db = db;
        this.implementation = new CommonLimitOffsetImpl(tables, this, (Function3)new Function3<RoomRawQuery, Integer, Continuation<? super List<? extends Value>>, Object>((Object)this){

            public final Object invoke(RoomRawQuery p0, int p1, Continuation<? super List<? extends Value>> $completion) {
                return ((LimitOffsetPagingSource)((Object)this.receiver)).convertRows(p0, p1, $completion);
            }
        });
    }

    @NotNull
    public final RoomRawQuery getSourceQuery() {
        return this.sourceQuery;
    }

    @NotNull
    public final RoomDatabase getDb() {
        return this.db;
    }

    public final int getItemCount() {
        return this.implementation.getItemCount$room_paging().get();
    }

    public boolean getJumpingSupported() {
        return true;
    }

    @Nullable
    public Object load(@NotNull PagingSource.LoadParams<Integer> params, @NotNull Continuation<? super PagingSource.LoadResult<Integer, Value>> $completion) {
        return this.implementation.load(params, $completion);
    }

    @Nullable
    public Integer getRefreshKey(@NotNull PagingState<Integer, Value> state) {
        Intrinsics.checkNotNullParameter(state, (String)"state");
        return RoomPagingUtil.getClippedRefreshKey(state);
    }

    @Nullable
    protected Object convertRows(@NotNull RoomRawQuery limitOffsetQuery, int itemCount, @NotNull Continuation<? super List<? extends Value>> $completion) {
        return LimitOffsetPagingSource.convertRows$suspendImpl(this, limitOffsetQuery, itemCount, $completion);
    }

    static /* synthetic */ <Value> Object convertRows$suspendImpl(LimitOffsetPagingSource<Value> $this, RoomRawQuery limitOffsetQuery, int itemCount, Continuation<? super List<? extends Value>> $completion) {
        throw new NotImplementedError("Unexpected call to a function with no implementation that Room is suppose to generate. Please file a bug at: https://issuetracker.google.com/issues/new?component=413107&template=1096568.");
    }
}

