/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.libcache.distributed;

import android.content.Context;
import android.net.nsd.NsdManager;
import android.net.nsd.NsdServiceInfo;
import androidx.lifecycle.DefaultLifecycleObserver;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import com.ustadmobile.libcache.distributed.DistributedCacheNeighborDiscoveryListener;
import com.ustadmobile.libcache.distributed.DistributedCacheNsdAndroid;
import com.ustadmobile.libcache.logging.UstadCacheLogger;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000_\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t*\u0001\u001a\u0018\u0000 '2\u00020\u0001:\u0004$%&'B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010 \u001a\u00020\u001dJ\u0006\u0010!\u001a\u00020\u001dJ\u0006\u0010\"\u001a\u00020\u001dJ\u0006\u0010#\u001a\u00020\u001dR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0018\u00010\u0013R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0018\u00010\u0015R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001b\u00a8\u0006("}, d2={"Lcom/ustadmobile/libcache/distributed/DistributedCacheNsdAndroid;", "", "context", "Landroid/content/Context;", "port", "", "logger", "Lcom/ustadmobile/libcache/logging/UstadCacheLogger;", "listener", "Lcom/ustadmobile/libcache/distributed/DistributedCacheNeighborDiscoveryListener;", "<init>", "(Landroid/content/Context;ILcom/ustadmobile/libcache/logging/UstadCacheLogger;Lcom/ustadmobile/libcache/distributed/DistributedCacheNeighborDiscoveryListener;)V", "scope", "Lkotlinx/coroutines/CoroutineScope;", "serviceInfo", "Landroid/net/nsd/NsdServiceInfo;", "nsdManager", "Landroid/net/nsd/NsdManager;", "mDiscoveryListener", "Lcom/ustadmobile/libcache/distributed/DistributedCacheNsdAndroid$DiscoveryListener;", "mRegistrationListener", "Lcom/ustadmobile/libcache/distributed/DistributedCacheNsdAndroid$RegistrationListener;", "discoveryLock", "Ljava/util/concurrent/locks/ReentrantLock;", "registrationLock", "lifecycleObserver", "com/ustadmobile/libcache/distributed/DistributedCacheNsdAndroid$lifecycleObserver$1", "Lcom/ustadmobile/libcache/distributed/DistributedCacheNsdAndroid$lifecycleObserver$1;", "initWithLifecycleOwner", "", "lifecycleOwner", "Landroidx/lifecycle/LifecycleOwner;", "startDiscovery", "stopDiscovery", "registerService", "unregisterService", "RegistrationListener", "ResolveListener", "DiscoveryListener", "Companion", "respect-lib-cache_debug"})
public final class DistributedCacheNsdAndroid {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int port;
    @NotNull
    private final UstadCacheLogger logger;
    @NotNull
    private final DistributedCacheNeighborDiscoveryListener listener;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final NsdServiceInfo serviceInfo;
    @NotNull
    private final NsdManager nsdManager;
    @Nullable
    private volatile DiscoveryListener mDiscoveryListener;
    @Nullable
    private RegistrationListener mRegistrationListener;
    @NotNull
    private final ReentrantLock discoveryLock;
    @NotNull
    private final ReentrantLock registrationLock;
    @NotNull
    private final lifecycleObserver.1 lifecycleObserver;
    @NotNull
    public static final String SERVICE_NAME = "DCache";
    @NotNull
    public static final String SERVICE_TYPE = "_dcache._tcp";

    /*
     * WARNING - void declaration
     */
    public DistributedCacheNsdAndroid(@NotNull Context context, int port, @NotNull UstadCacheLogger logger, @NotNull DistributedCacheNeighborDiscoveryListener listener) {
        void $this$serviceInfo_u24lambda_u240;
        NsdServiceInfo nsdServiceInfo;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.port = port;
        this.logger = logger;
        this.listener = listener;
        this.scope = CoroutineScopeKt.CoroutineScope((CoroutineContext)Dispatchers.getIO().plus((CoroutineContext)JobKt.Job$default(null, (int)1, null)));
        NsdServiceInfo nsdServiceInfo2 = nsdServiceInfo = new NsdServiceInfo();
        DistributedCacheNsdAndroid distributedCacheNsdAndroid = this;
        boolean bl = false;
        $this$serviceInfo_u24lambda_u240.setServiceName(SERVICE_NAME);
        $this$serviceInfo_u24lambda_u240.setServiceType(SERVICE_TYPE);
        $this$serviceInfo_u24lambda_u240.setPort(this.port);
        distributedCacheNsdAndroid.serviceInfo = nsdServiceInfo;
        Object object = context.getSystemService("servicediscovery");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.net.nsd.NsdManager");
        this.nsdManager = (NsdManager)object;
        this.discoveryLock = new ReentrantLock();
        this.registrationLock = new ReentrantLock();
        this.lifecycleObserver = new DefaultLifecycleObserver(this){
            final /* synthetic */ DistributedCacheNsdAndroid this$0;
            {
                this.this$0 = $receiver;
            }

            public void onCreate(LifecycleOwner owner) {
                Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
                this.this$0.registerService();
            }

            public void onDestroy(LifecycleOwner owner) {
                Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
                this.this$0.unregisterService();
            }

            public void onStart(LifecycleOwner owner) {
                Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
                this.this$0.startDiscovery();
            }

            public void onStop(LifecycleOwner owner) {
                Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
                this.this$0.stopDiscovery();
            }

            public void onResume(LifecycleOwner owner) {
                super.onResume(owner);
            }

            public void onPause(LifecycleOwner owner) {
                super.onPause(owner);
            }
        };
    }

    public final void initWithLifecycleOwner(@NotNull LifecycleOwner lifecycleOwner) {
        Intrinsics.checkNotNullParameter((Object)lifecycleOwner, (String)"lifecycleOwner");
        Lifecycle.State currentState = lifecycleOwner.getLifecycle().getCurrentState();
        if (currentState.isAtLeast(Lifecycle.State.CREATED)) {
            this.registerService();
        }
        if (currentState.isAtLeast(Lifecycle.State.STARTED)) {
            this.startDiscovery();
        }
        lifecycleOwner.getLifecycle().addObserver((LifecycleObserver)this.lifecycleObserver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void startDiscovery() {
        Lock lock = this.discoveryLock;
        lock.lock();
        try {
            boolean bl = false;
            if (this.mDiscoveryListener == null) {
                void it;
                DiscoveryListener discoveryListener;
                DiscoveryListener discoveryListener2 = discoveryListener = new DiscoveryListener();
                DistributedCacheNsdAndroid distributedCacheNsdAndroid = this;
                boolean bl2 = false;
                this.nsdManager.discoverServices(SERVICE_TYPE, 1, (NsdManager.DiscoveryListener)it);
                distributedCacheNsdAndroid.mDiscoveryListener = discoveryListener;
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stopDiscovery() {
        Lock lock = this.discoveryLock;
        lock.lock();
        try {
            boolean bl = false;
            DiscoveryListener discoveryListenerVal = this.mDiscoveryListener;
            if (discoveryListenerVal != null) {
                this.nsdManager.stopServiceDiscovery((NsdManager.DiscoveryListener)discoveryListenerVal);
                this.mDiscoveryListener = null;
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void registerService() {
        Lock lock = this.registrationLock;
        lock.lock();
        try {
            boolean bl = false;
            if (this.mRegistrationListener == null) {
                void it;
                RegistrationListener registrationListener;
                RegistrationListener registrationListener2 = registrationListener = new RegistrationListener();
                DistributedCacheNsdAndroid distributedCacheNsdAndroid = this;
                boolean bl2 = false;
                this.nsdManager.registerService(this.serviceInfo, 1, (NsdManager.RegistrationListener)it);
                distributedCacheNsdAndroid.mRegistrationListener = registrationListener;
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unregisterService() {
        Lock lock = this.registrationLock;
        lock.lock();
        try {
            boolean bl = false;
            RegistrationListener registrationListenerVal = this.mRegistrationListener;
            if (registrationListenerVal != null) {
                this.nsdManager.unregisterService((NsdManager.RegistrationListener)registrationListenerVal);
                this.mRegistrationListener = null;
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/ustadmobile/libcache/distributed/DistributedCacheNsdAndroid$Companion;", "", "<init>", "()V", "SERVICE_NAME", "", "SERVICE_TYPE", "respect-lib-cache_debug"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0014\u0010\b\u001a\u00020\t*\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007H\u0002J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0007H\u0016J\u0018\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a8\u0006\u0015"}, d2={"Lcom/ustadmobile/libcache/distributed/DistributedCacheNsdAndroid$DiscoveryListener;", "Landroid/net/nsd/NsdManager$DiscoveryListener;", "<init>", "(Lcom/ustadmobile/libcache/distributed/DistributedCacheNsdAndroid;)V", "onDiscoveryStarted", "", "regType", "", "serviceTypeMatches", "", "other", "onServiceFound", "service", "Landroid/net/nsd/NsdServiceInfo;", "onServiceLost", "onDiscoveryStopped", "serviceType", "onStartDiscoveryFailed", "errorCode", "", "onStopDiscoveryFailed", "respect-lib-cache_debug"})
    public final class DiscoveryListener
    implements NsdManager.DiscoveryListener {
        public void onDiscoveryStarted(@NotNull String regType) {
            Intrinsics.checkNotNullParameter((Object)regType, (String)"regType");
            UstadCacheLogger.d$default(DistributedCacheNsdAndroid.this.logger, "DistCache", "Service discovery started", null, 4, null);
        }

        private final boolean serviceTypeMatches(String $this$serviceTypeMatches, String other) {
            return Intrinsics.areEqual((Object)$this$serviceTypeMatches, (Object)other) || Intrinsics.areEqual((Object)$this$serviceTypeMatches, (Object)(other + "."));
        }

        public void onServiceFound(@NotNull NsdServiceInfo service) {
            Intrinsics.checkNotNullParameter((Object)service, (String)"service");
            UstadCacheLogger.d$default(DistributedCacheNsdAndroid.this.logger, "DistCache", "Service discovery onServiceFound: " + service, null, 4, null);
            String string = service.getServiceType();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getServiceType(...)");
            if (!this.serviceTypeMatches(string, DistributedCacheNsdAndroid.SERVICE_TYPE)) {
                UstadCacheLogger.d$default(DistributedCacheNsdAndroid.this.logger, "DistCache", "Unknown Service Type: " + service.getServiceType(), null, 4, null);
            } else {
                UstadCacheLogger.d$default(DistributedCacheNsdAndroid.this.logger, "DistCache", "Service Found: " + service.getServiceType(), null, 4, null);
                DistributedCacheNsdAndroid.this.nsdManager.resolveService(service, (NsdManager.ResolveListener)new ResolveListener());
            }
        }

        public void onServiceLost(@NotNull NsdServiceInfo service) {
            String neighborIpAddr;
            Intrinsics.checkNotNullParameter((Object)service, (String)"service");
            UstadCacheLogger.e$default(DistributedCacheNsdAndroid.this.logger, "DistCache", "service lost: " + service, null, 4, null);
            InetAddress inetAddress = service.getHost();
            String string = neighborIpAddr = inetAddress != null ? inetAddress.getHostAddress() : null;
            if (neighborIpAddr != null) {
                DistributedCacheNsdAndroid.this.listener.onNeighborLost(neighborIpAddr, service.getPort());
            } else {
                UstadCacheLogger.d$default(DistributedCacheNsdAndroid.this.logger, "DistCache", "Service lost, but neighbor url is null", null, 4, null);
            }
        }

        public void onDiscoveryStopped(@NotNull String serviceType) {
            Intrinsics.checkNotNullParameter((Object)serviceType, (String)"serviceType");
            UstadCacheLogger.i$default(DistributedCacheNsdAndroid.this.logger, "DistCache", "Discovery stopped: " + serviceType, null, 4, null);
        }

        public void onStartDiscoveryFailed(@NotNull String serviceType, int errorCode) {
            Intrinsics.checkNotNullParameter((Object)serviceType, (String)"serviceType");
            UstadCacheLogger.e$default(DistributedCacheNsdAndroid.this.logger, "DistCache", "Discovery failed: Error code:" + errorCode, null, 4, null);
            DistributedCacheNsdAndroid.this.nsdManager.stopServiceDiscovery((NsdManager.DiscoveryListener)this);
        }

        public void onStopDiscoveryFailed(@NotNull String serviceType, int errorCode) {
            Intrinsics.checkNotNullParameter((Object)serviceType, (String)"serviceType");
            UstadCacheLogger.e$default(DistributedCacheNsdAndroid.this.logger, "DistCache", "Discovery failed: Error code:" + errorCode, null, 4, null);
            DistributedCacheNsdAndroid.this.nsdManager.stopServiceDiscovery((NsdManager.DiscoveryListener)this);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lcom/ustadmobile/libcache/distributed/DistributedCacheNsdAndroid$RegistrationListener;", "Landroid/net/nsd/NsdManager$RegistrationListener;", "<init>", "(Lcom/ustadmobile/libcache/distributed/DistributedCacheNsdAndroid;)V", "onServiceRegistered", "", "serviceInfo", "Landroid/net/nsd/NsdServiceInfo;", "onServiceUnregistered", "onRegistrationFailed", "errorCode", "", "onUnregistrationFailed", "respect-lib-cache_debug"})
    public final class RegistrationListener
    implements NsdManager.RegistrationListener {
        public void onServiceRegistered(@NotNull NsdServiceInfo serviceInfo) {
            Intrinsics.checkNotNullParameter((Object)serviceInfo, (String)"serviceInfo");
            UstadCacheLogger.i$default(DistributedCacheNsdAndroid.this.logger, "DistCache", "Registered: " + serviceInfo, null, 4, null);
        }

        public void onServiceUnregistered(@NotNull NsdServiceInfo serviceInfo) {
            Intrinsics.checkNotNullParameter((Object)serviceInfo, (String)"serviceInfo");
            UstadCacheLogger.i$default(DistributedCacheNsdAndroid.this.logger, "DistCache", "Unregistered: " + serviceInfo, null, 4, null);
        }

        public void onRegistrationFailed(@NotNull NsdServiceInfo serviceInfo, int errorCode) {
            Intrinsics.checkNotNullParameter((Object)serviceInfo, (String)"serviceInfo");
            UstadCacheLogger.e$default(DistributedCacheNsdAndroid.this.logger, "DistCache", "Registered failed: " + serviceInfo + " : " + errorCode, null, 4, null);
        }

        public void onUnregistrationFailed(@NotNull NsdServiceInfo serviceInfo, int errorCode) {
            Intrinsics.checkNotNullParameter((Object)serviceInfo, (String)"serviceInfo");
            UstadCacheLogger.e$default(DistributedCacheNsdAndroid.this.logger, "DistCache", "Unregister failed: " + serviceInfo + " : " + errorCode, null, 4, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/ustadmobile/libcache/distributed/DistributedCacheNsdAndroid$ResolveListener;", "Landroid/net/nsd/NsdManager$ResolveListener;", "<init>", "(Lcom/ustadmobile/libcache/distributed/DistributedCacheNsdAndroid;)V", "onResolveFailed", "", "serviceInfo", "Landroid/net/nsd/NsdServiceInfo;", "errorCode", "", "onServiceResolved", "respect-lib-cache_debug"})
    public final class ResolveListener
    implements NsdManager.ResolveListener {
        public void onResolveFailed(@NotNull NsdServiceInfo serviceInfo, int errorCode) {
            Intrinsics.checkNotNullParameter((Object)serviceInfo, (String)"serviceInfo");
            UstadCacheLogger.e$default(DistributedCacheNsdAndroid.this.logger, "DistCache", "Resolve failed: " + errorCode, null, 4, null);
        }

        public void onServiceResolved(@NotNull NsdServiceInfo serviceInfo) {
            Intrinsics.checkNotNullParameter((Object)serviceInfo, (String)"serviceInfo");
            UstadCacheLogger.i$default(DistributedCacheNsdAndroid.this.logger, "DistCache", "Resolve Succeeded. " + serviceInfo, null, 4, null);
            InetAddress neighborHostAddr = serviceInfo.getHost();
            BuildersKt.launch$default((CoroutineScope)DistributedCacheNsdAndroid.this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(neighborHostAddr, DistributedCacheNsdAndroid.this, serviceInfo, null){
                int label;
                final /* synthetic */ InetAddress $neighborHostAddr;
                final /* synthetic */ DistributedCacheNsdAndroid this$0;
                final /* synthetic */ NsdServiceInfo $serviceInfo;
                {
                    this.$neighborHostAddr = $neighborHostAddr;
                    this.this$0 = $receiver;
                    this.$serviceInfo = $serviceInfo;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 */
                public final Object invokeSuspend(Object $result) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            void $this$mapTo$iv$iv;
                            Object list$iv$iv;
                            NetworkInterface it;
                            Iterable $this$flatMapTo$iv$iv;
                            ResultKt.throwOnFailure((Object)$result);
                            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
                            Intrinsics.checkNotNullExpressionValue(enumeration, (String)"getNetworkInterfaces(...)");
                            ArrayList<NetworkInterface> arrayList = Collections.list(enumeration);
                            Intrinsics.checkNotNullExpressionValue(arrayList, (String)"list(...)");
                            Iterable $this$flatMap$iv = arrayList;
                            boolean $i$f$flatMap = false;
                            Iterable iterable = $this$flatMap$iv;
                            Collection destination$iv$iv = new ArrayList<E>();
                            boolean $i$f$flatMapTo = false;
                            for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                                it = (NetworkInterface)element$iv$iv;
                                boolean bl = false;
                                List<InterfaceAddress> list = it.getInterfaceAddresses();
                                Intrinsics.checkNotNullExpressionValue(list, (String)"getInterfaceAddresses(...)");
                                list$iv$iv = list;
                                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                            }
                            Iterable $this$map$iv = (List)destination$iv$iv;
                            boolean $i$f$map = false;
                            $this$flatMapTo$iv$iv = $this$map$iv;
                            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                            boolean $i$f$mapTo = false;
                            for (T item$iv$iv : $this$mapTo$iv$iv) {
                                list$iv$iv = (InterfaceAddress)item$iv$iv;
                                Collection collection = destination$iv$iv;
                                boolean bl = false;
                                collection.add(((InterfaceAddress)((Object)it)).getAddress());
                            }
                            List localAddresses = (List)destination$iv$iv;
                            if (!localAddresses.contains(this.$neighborHostAddr)) {
                                DistributedCacheNeighborDiscoveryListener distributedCacheNeighborDiscoveryListener = DistributedCacheNsdAndroid.access$getListener$p(this.this$0);
                                String string = this.$neighborHostAddr.getHostName();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHostName(...)");
                                distributedCacheNeighborDiscoveryListener.onNeighborDiscovered(string, this.$serviceInfo.getPort(), 0);
                            } else {
                                UstadCacheLogger.d$default(DistributedCacheNsdAndroid.access$getLogger$p(this.this$0), "DistCache", this.$neighborHostAddr + " is local device", null, 4, null);
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }
}

