/*
 * Decompiled with CFR 0.152.
 */
package world.respect.shared.domain.storage;

import android.content.Context;
import android.os.Environment;
import androidx.compose.runtime.internal.StabilityInferred;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import world.respect.shared.util.ext.FileExtKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0086\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lworld/respect/shared/domain/storage/GetAndroidSdCardDirUseCase;", "", "appContext", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "invoke", "Lworld/respect/shared/domain/storage/GetAndroidSdCardDirUseCase$SdCardDirs;", "SdCardDirs", "respect-lib-shared_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nGetAndroidSdCardDirUseCase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GetAndroidSdCardDirUseCase.kt\nworld/respect/shared/domain/storage/GetAndroidSdCardDirUseCase\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,49:1\n1310#2,2:50\n1310#2,2:52\n*S KotlinDebug\n*F\n+ 1 GetAndroidSdCardDirUseCase.kt\nworld/respect/shared/domain/storage/GetAndroidSdCardDirUseCase\n*L\n26#1:50,2\n33#1:52,2\n*E\n"})
public final class GetAndroidSdCardDirUseCase {
    @NotNull
    private final Context appContext;
    public static final int $stable = 8;

    public GetAndroidSdCardDirUseCase(@NotNull Context appContext) {
        Intrinsics.checkNotNullParameter((Object)appContext, (String)"appContext");
        this.appContext = appContext;
    }

    @Nullable
    public final SdCardDirs invoke() {
        File file;
        File removableExternalFileDirsParent;
        File removableExternalFileDirs;
        Object object;
        block4: {
            File[] fileArray = this.appContext.getExternalFilesDirs(null);
            Intrinsics.checkNotNullExpressionValue((Object)fileArray, (String)"getExternalFilesDirs(...)");
            Object[] $this$firstOrNull$iv = fileArray;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                File it = (File)element$iv;
                boolean bl = false;
                if (!Environment.isExternalStorageRemovable((File)it)) continue;
                object = element$iv;
                break block4;
            }
            object = null;
        }
        File file2 = removableExternalFileDirs = (File)object;
        File file3 = removableExternalFileDirsParent = file2 != null ? file2.getParentFile() : null;
        if (removableExternalFileDirsParent != null) {
            Object object2;
            block5: {
                File[] fileArray = this.appContext.getExternalCacheDirs();
                Intrinsics.checkNotNullExpressionValue((Object)fileArray, (String)"getExternalCacheDirs(...)");
                Object[] $this$firstOrNull$iv = fileArray;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    File it = (File)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    if (!FileExtKt.isChildOf(it, removableExternalFileDirsParent)) continue;
                    object2 = element$iv;
                    break block5;
                }
                object2 = null;
            }
            file = (File)object2;
        } else {
            file = null;
        }
        File removableCacheDir = file;
        return Intrinsics.areEqual((Object)Environment.getExternalStorageState((File)removableExternalFileDirs), (Object)"mounted") && removableExternalFileDirs != null && removableCacheDir != null ? new SdCardDirs(removableExternalFileDirs, removableCacheDir) : null;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0014"}, d2={"Lworld/respect/shared/domain/storage/GetAndroidSdCardDirUseCase$SdCardDirs;", "", "filesDir", "Ljava/io/File;", "cacheDir", "<init>", "(Ljava/io/File;Ljava/io/File;)V", "getFilesDir", "()Ljava/io/File;", "getCacheDir", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "respect-lib-shared_release"})
    @StabilityInferred(parameters=0)
    public static final class SdCardDirs {
        @NotNull
        private final File filesDir;
        @NotNull
        private final File cacheDir;
        public static final int $stable = 8;

        public SdCardDirs(@NotNull File filesDir, @NotNull File cacheDir) {
            Intrinsics.checkNotNullParameter((Object)filesDir, (String)"filesDir");
            Intrinsics.checkNotNullParameter((Object)cacheDir, (String)"cacheDir");
            this.filesDir = filesDir;
            this.cacheDir = cacheDir;
        }

        @NotNull
        public final File getFilesDir() {
            return this.filesDir;
        }

        @NotNull
        public final File getCacheDir() {
            return this.cacheDir;
        }

        @NotNull
        public final File component1() {
            return this.filesDir;
        }

        @NotNull
        public final File component2() {
            return this.cacheDir;
        }

        @NotNull
        public final SdCardDirs copy(@NotNull File filesDir, @NotNull File cacheDir) {
            Intrinsics.checkNotNullParameter((Object)filesDir, (String)"filesDir");
            Intrinsics.checkNotNullParameter((Object)cacheDir, (String)"cacheDir");
            return new SdCardDirs(filesDir, cacheDir);
        }

        public static /* synthetic */ SdCardDirs copy$default(SdCardDirs sdCardDirs, File file, File file2, int n, Object object) {
            if ((n & 1) != 0) {
                file = sdCardDirs.filesDir;
            }
            if ((n & 2) != 0) {
                file2 = sdCardDirs.cacheDir;
            }
            return sdCardDirs.copy(file, file2);
        }

        @NotNull
        public String toString() {
            return "SdCardDirs(filesDir=" + this.filesDir + ", cacheDir=" + this.cacheDir + ")";
        }

        public int hashCode() {
            int result = this.filesDir.hashCode();
            result = result * 31 + this.cacheDir.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SdCardDirs)) {
                return false;
            }
            SdCardDirs sdCardDirs = (SdCardDirs)other;
            if (!Intrinsics.areEqual((Object)this.filesDir, (Object)sdCardDirs.filesDir)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.cacheDir, (Object)sdCardDirs.cacheDir);
        }
    }
}

