/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.lint;

import androidx.compose.lint.Name;
import androidx.compose.lint.Names;
import androidx.compose.lint.PsiUtilsKt;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfo;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfoKt;
import org.jetbrains.kotlin.analysis.api.session.KaSessionProvider;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassSymbol;
import org.jetbrains.kotlin.analysis.api.types.KaType;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.kotlin.BaseKotlinInternalUastUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001c2\u00020\u00012\u00020\u0002:\u0001\u001cB\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007H\u0002J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0010H\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0012\u001a\u00020\rH\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\rH\u0002J \u0010\u0015\u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0016\u0010\u0019\u001a\u0004\u0018\u00010\u001a*\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0016\u0010\u001b\u001a\u0004\u0018\u00010\u001a*\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Landroidx/compose/runtime/lint/AutoboxingStateCreationDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "replacements", "", "", "Landroidx/compose/lint/Name;", "createLintFix", "Lcom/android/tools/lint/detector/api/LintFix;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "replacementFunction", "getApplicableMethodNames", "", "getSuggestedReplacementName", "invocation", "usesStructuralEqualityPolicy", "", "visitMethodCall", "", "method", "Lcom/intellij/psi/PsiMethod;", "getLocationOfArgumentsList", "Lcom/android/tools/lint/detector/api/Location;", "getLocationOfTypeArguments", "Companion", "runtime-lint"})
@SourceDebugExtension(value={"SMAP\nAutoboxingStateCreationDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AutoboxingStateCreationDetector.kt\nandroidx/compose/runtime/lint/AutoboxingStateCreationDetector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 5 analyze.kt\norg/jetbrains/kotlin/analysis/api/AnalyzeKt\n+ 6 KtAnalysisSessionProvider.kt\norg/jetbrains/kotlin/analysis/api/session/KtAnalysisSessionProvider\n*L\n1#1,208:1\n1#2:209\n37#3,2:210\n25#4,2:212\n25#4,2:214\n29#5,2:216\n51#6:218\n65#6,8:219\n*S KotlinDebug\n*F\n+ 1 AutoboxingStateCreationDetector.kt\nandroidx/compose/runtime/lint/AutoboxingStateCreationDetector\n*L\n126#1:210,2\n131#1:212,2\n137#1:214,2\n145#1:216,2\n145#1:218\n145#1:219,8\n*E\n"})
public final class AutoboxingStateCreationDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, Name> replacements;
    private static final int VALUE_PARAM_IDX = 0;
    private static final int MUTATION_POLICY_PARAM_IDX = 1;
    @NotNull
    private static final Issue AutoboxingStateCreation = Issue.Companion.create("AutoboxingStateCreation", "`State<T>` will autobox values assigned to this state. Use a specialized state type instead.", "Calling `mutableStateOf<T>()` when `T` is either backed by a primitive type on the JVM or is a value class results in a state implementation that requires all state values to be boxed. This usually causes an additional allocation for each state write, and adds some additional work to auto-unbox values when reading the value of the state. Instead, prefer to use a specialized primitive state implementation for `Int`, `Long`, `Float`, and `Double` when the state does not need to track null values and does not override the default `SnapshotMutationPolicy`. See `mutableIntStateOf()`, `mutableLongStateOf()`, `mutableFloatStateOf()`, and `mutableDoubleStateOf()` for more information.", Category.PERFORMANCE, 3, Severity.INFORMATIONAL, new Implementation(AutoboxingStateCreationDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE)));

    public AutoboxingStateCreationDetector() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"kotlin.Int", (Object)Names.Runtime.INSTANCE.getMutableIntStateOf()), TuplesKt.to((Object)"kotlin.Long", (Object)Names.Runtime.INSTANCE.getMutableLongStateOf()), TuplesKt.to((Object)"kotlin.Float", (Object)Names.Runtime.INSTANCE.getMutableFloatStateOf()), TuplesKt.to((Object)"kotlin.Double", (Object)Names.Runtime.INSTANCE.getMutableDoubleStateOf())};
        this.replacements = MapsKt.mapOf((Pair[])pairArray);
    }

    @NotNull
    public List<String> getApplicableMethodNames() {
        return CollectionsKt.listOf((Object)Names.Runtime.INSTANCE.getMutableStateOf().getShortName());
    }

    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        if (!BaseKotlinInternalUastUtilsKt.isKotlin((Language)node.getLang())) {
            return;
        }
        if (!PsiUtilsKt.isInPackageName((PsiMember)method, Names.Runtime.INSTANCE.getPackageName())) {
            return;
        }
        Name name = this.getSuggestedReplacementName(node);
        if (name == null) {
            return;
        }
        Name replacement = name;
        context.report(AutoboxingStateCreation, (UElement)node, context.getNameLocation((UElement)node), "Prefer `" + replacement.getShortName() + "` instead of `" + method.getName() + "`", this.createLintFix(context, node, replacement));
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final LintFix createLintFix(JavaContext context, UCallExpression node, Name replacementFunction) {
        var5_4 = new LintFix[3];
        var5_4[0] = LintFix.Companion.create().replace().range(context.getNameLocation((UElement)node)).with(replacementFunction.getJavaFqn()).shortenNames(true).build();
        v0 = var5_4;
        v1 = 1;
        v2 = this.getLocationOfTypeArguments(context, node);
        if (v2 != null) {
            var8_5 = v2;
            var15_6 = v1;
            var14_7 = v0;
            $i$a$-let-AutoboxingStateCreationDetector$createLintFix$fixes$1 = false;
            var16_10 = LintFix.Companion.create().replace().range(it).with("").build();
            v0 = var14_7;
            v1 = var15_6;
            v3 = var16_10;
        } else {
            v3 = null;
        }
        v0[v1] = v3;
        v4 = var5_4;
        v5 = 2;
        var6_13 = this.getLocationOfArgumentsList(context, node);
        if (var6_13 == null) ** GOTO lbl-1000
        $i$a$-let-AutoboxingStateCreationDetector$createLintFix$fixes$1 = it = var6_13;
        var15_6 = v5;
        var14_7 = v4;
        $i$a$-takeIf-AutoboxingStateCreationDetector$createLintFix$fixes$2 = false;
        var16_11 = node.getArgumentForParameter(1) != null;
        v4 = var14_7;
        v5 = var15_6;
        v6 /* !! */  = var7_15 = var16_11 != false ? it : null;
        if (var7_15 != null) {
            it = var7_15;
            var15_6 = v5;
            var14_7 = v4;
            $i$a$-let-AutoboxingStateCreationDetector$createLintFix$fixes$3 = false;
            v7 /* !! */  = node.getArgumentForParameter(0);
            if (v7 /* !! */  != null && (v7 /* !! */  = v7 /* !! */ .getSourcePsi()) != null && (v7 /* !! */  = (var11_17 = v7 /* !! */ .getText())) != null) {
                Intrinsics.checkNotNull((Object)v7 /* !! */ );
                valueArg = var11_17;
                $i$a$-let-AutoboxingStateCreationDetector$createLintFix$fixes$3$1 = false;
                v8 = LintFix.Companion.create().replace().range((Location)argsListLocation).with("(" + valueArg + ")").build();
            } else {
                v8 = null;
            }
            var16_12 = v8;
            v4 = var14_7;
            v5 = var15_6;
            v9 = var16_12;
        } else lbl-1000:
        // 2 sources

        {
            v9 = null;
        }
        v4[v5] = v9;
        fixes = CollectionsKt.listOfNotNull((Object[])var5_4);
        $this$toTypedArray$iv = fixes;
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        var5_4 = thisCollection$iv.toArray(new LintFix[0]);
        return LintFix.Companion.create().name("Replace with " + replacementFunction.getShortName()).composite((LintFix[])Arrays.copyOf(var5_4, var5_4.length));
    }

    private final Location getLocationOfTypeArguments(JavaContext $this$getLocationOfTypeArguments, UCallExpression node) {
        KtTypeArgumentList ktTypeArgumentList;
        block5: {
            block4: {
                PsiElement psiElement;
                block3: {
                    ktTypeArgumentList = node.getSourcePsi();
                    if (ktTypeArgumentList == null || (ktTypeArgumentList = ktTypeArgumentList.getChildren()) == null) break block4;
                    KtTypeArgumentList $this$firstIsInstanceOrNull$iv = ktTypeArgumentList;
                    boolean $i$f$firstIsInstanceOrNull = false;
                    for (PsiElement element$iv : $this$firstIsInstanceOrNull$iv) {
                        if (!(element$iv instanceof KtTypeArgumentList)) continue;
                        psiElement = element$iv;
                        break block3;
                    }
                    psiElement = null;
                }
                if ((ktTypeArgumentList = (KtTypeArgumentList)psiElement) != null) break block5;
            }
            return null;
        }
        KtTypeArgumentList typeArgsList = ktTypeArgumentList;
        return $this$getLocationOfTypeArguments.getLocation((PsiElement)typeArgsList);
    }

    private final Location getLocationOfArgumentsList(JavaContext $this$getLocationOfArgumentsList, UCallExpression node) {
        KtValueArgumentList ktValueArgumentList;
        block5: {
            block4: {
                PsiElement psiElement;
                block3: {
                    ktValueArgumentList = node.getSourcePsi();
                    if (ktValueArgumentList == null || (ktValueArgumentList = ktValueArgumentList.getChildren()) == null) break block4;
                    KtValueArgumentList $this$firstIsInstanceOrNull$iv = ktValueArgumentList;
                    boolean $i$f$firstIsInstanceOrNull = false;
                    for (PsiElement element$iv : $this$firstIsInstanceOrNull$iv) {
                        if (!(element$iv instanceof KtValueArgumentList)) continue;
                        psiElement = element$iv;
                        break block3;
                    }
                    psiElement = null;
                }
                if ((ktValueArgumentList = (KtValueArgumentList)psiElement) != null) break block5;
            }
            return null;
        }
        KtValueArgumentList argsList = ktValueArgumentList;
        return $this$getLocationOfArgumentsList.getLocation((PsiElement)argsList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final Name getSuggestedReplacementName(UCallExpression invocation) {
        void this_$iv$iv$iv;
        void this_$iv$iv;
        if (!this.usesStructuralEqualityPolicy(invocation)) {
            return null;
        }
        PsiElement psiElement = invocation.getSourcePsi();
        KtElement ktElement = psiElement instanceof KtElement ? (KtElement)psiElement : null;
        if (ktElement == null) {
            return null;
        }
        KtElement sourcePsi = ktElement;
        boolean $i$f$analyze = false;
        Project project = sourcePsi.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        psiElement = KaSessionProvider.Companion.getInstance(project);
        boolean $i$f$analyse = false;
        void var6_6 = this_$iv$iv;
        KaSession analysisSession$iv$iv$iv = this_$iv$iv.getAnalysisSession(sourcePsi);
        boolean $i$f$analyse2 = false;
        this_$iv$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv$iv, sourcePsi);
        try {
            Name name;
            KaSession $this$getSuggestedReplacementName_u24lambda_u244 = analysisSession$iv$iv$iv;
            boolean bl = false;
            KaCallInfo kaCallInfo = $this$getSuggestedReplacementName_u24lambda_u244.resolveToCall(sourcePsi);
            if (kaCallInfo == null || (kaCallInfo = KaCallInfoKt.singleFunctionCallOrNull((KaCallInfo)kaCallInfo)) == null) {
                Name name2 = null;
                return name2;
            }
            KaCallInfo resolvedCall = kaCallInfo;
            Map.Entry entry = (Map.Entry)CollectionsKt.singleOrNull((Iterable)resolvedCall.getTypeArgumentsMapping().entrySet());
            if (entry == null || (entry = (KaType)entry.getValue()) == null) {
                Name name3 = null;
                return name3;
            }
            Map.Entry stateType = entry;
            if ($this$getSuggestedReplacementName_u24lambda_u244.isMarkedNullable((KaType)stateType)) {
                name = null;
            } else {
                KaClassSymbol kaClassSymbol = $this$getSuggestedReplacementName_u24lambda_u244.getExpandedSymbol((KaType)stateType);
                String fqName = kaClassSymbol != null && (kaClassSymbol = kaClassSymbol.getClassId()) != null ? kaClassSymbol.asFqNameString() : null;
                name = this.replacements.get(fqName);
            }
            Name name4 = name;
            return name4;
        }
        finally {
            this_$iv$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv$iv, sourcePsi);
        }
    }

    private final boolean usesStructuralEqualityPolicy(UCallExpression invocation) {
        UExpression uExpression;
        UExpression uExpression2 = (UExpression)CollectionsKt.getOrNull((List)invocation.getValueArguments(), (int)1);
        if (uExpression2 == null || (uExpression = UastUtils.skipParenthesizedExprDown((UExpression)uExpression2)) == null) {
            return true;
        }
        UExpression policyExpr = uExpression;
        UCallExpression uCallExpression = policyExpr instanceof UCallExpression ? (UCallExpression)policyExpr : null;
        if (uCallExpression == null || (uCallExpression = uCallExpression.resolve()) == null) {
            return false;
        }
        UCallExpression policyMethod = uCallExpression;
        return PsiUtilsKt.isInPackageName((PsiMember)policyMethod, Names.Runtime.INSTANCE.getPackageName()) && Intrinsics.areEqual((Object)policyMethod.getName(), (Object)Names.Runtime.INSTANCE.getStructuralEqualityPolicy().getShortName());
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Landroidx/compose/runtime/lint/AutoboxingStateCreationDetector$Companion;", "", "()V", "AutoboxingStateCreation", "Lcom/android/tools/lint/detector/api/Issue;", "getAutoboxingStateCreation", "()Lcom/android/tools/lint/detector/api/Issue;", "MUTATION_POLICY_PARAM_IDX", "", "VALUE_PARAM_IDX", "runtime-lint"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Issue getAutoboxingStateCreation() {
            return AutoboxingStateCreation;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

