/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.lint;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UTypeReferenceExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastFacade;
import org.jetbrains.uast.UastLanguagePlugin;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u00012\u00020\u0002:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0011\u0010\u0011\u001a\u0004\u0018\u00010\u0006*\u0004\u0018\u00010\u0010H\u0082\u0010J\f\u0010\u0012\u001a\u00020\u0013*\u00020\u0006H\u0002R\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0015"}, d2={"Landroidx/compose/ui/lint/ModifierNodeInspectablePropertiesDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/Detector$UastScanner;", "()V", "receiverFqType", "", "Lorg/jetbrains/uast/UMethod;", "getReceiverFqType", "(Lorg/jetbrains/uast/UMethod;)Ljava/lang/String;", "applicableSuperClasses", "", "visitClass", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "declaration", "Lorg/jetbrains/uast/UClass;", "getInspectablePropertiesFunctionOverride", "hasInspectablePropertiesSignature", "", "Companion", "ui-lint"})
@SourceDebugExtension(value={"SMAP\nModifierNodeInspectablePropertiesDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModifierNodeInspectablePropertiesDetector.kt\nandroidx/compose/ui/lint/ModifierNodeInspectablePropertiesDetector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 UastLanguagePlugin.kt\norg/jetbrains/uast/UastLanguagePluginKt\n*L\n1#1,118:1\n800#2,11:119\n288#2,2:130\n180#3,2:132\n*S KotlinDebug\n*F\n+ 1 ModifierNodeInspectablePropertiesDetector.kt\nandroidx/compose/ui/lint/ModifierNodeInspectablePropertiesDetector\n*L\n76#1:119,11\n76#1:130,2\n79#1:132,2\n*E\n"})
public final class ModifierNodeInspectablePropertiesDetector
extends Detector
implements Detector.UastScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String ModifierNodeElementFqName = "androidx.compose.ui.node.ModifierNodeElement";
    @NotNull
    private static final String InspectionFunName = "inspectableProperties";
    @NotNull
    private static final String InspectionFunFqReceiver = "androidx.compose.ui.platform.InspectorInfo";
    @NotNull
    private static final Issue ModifierNodeInspectableProperties = Issue.Companion.create("ModifierNodeInspectableProperties", "ModifierNodeElement missing inspectableProperties", "ModifierNodeElements may override inspectableProperties() to provide information about the modifier in the layout inspector. The default implementation attempts to read all of the properties on the class reflectively, which may not comprehensively or effectively describe the modifier.", Category.PRODUCTIVITY, 4, Severity.INFORMATIONAL, new Implementation(ModifierNodeInspectablePropertiesDetector.class, Scope.JAVA_FILE_SCOPE));

    @NotNull
    public List<String> applicableSuperClasses() {
        return CollectionsKt.listOf((Object)ModifierNodeElementFqName);
    }

    public void visitClass(@NotNull JavaContext context, @NotNull UClass declaration) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (Intrinsics.areEqual((Object)declaration.getQualifiedName(), (Object)ModifierNodeElementFqName)) {
            return;
        }
        if (this.getInspectablePropertiesFunctionOverride(declaration) == null) {
            context.report(ModifierNodeInspectableProperties, declaration, context.getNameLocation(declaration), declaration.getName() + " does not override inspectableProperties(). The layout inspector will use the default implementation of this function, which will attempt to read " + declaration.getName() + "'s properties reflectively. Override inspectableProperties() if you'd like to customize this modifier's presentation in the layout inspector.");
        }
    }

    /*
     * WARNING - void declaration
     */
    private final UMethod getInspectablePropertiesFunctionOverride(UClass $this$getInspectablePropertiesFunctionOverride) {
        UMethod uMethod;
        block8: {
            while (true) {
                UElement uElement;
                Object v0;
                block7: {
                    Iterator $this$filterIsInstanceTo$iv$iv;
                    if ($this$getInspectablePropertiesFunctionOverride == null || Intrinsics.areEqual((Object)$this$getInspectablePropertiesFunctionOverride.getQualifiedName(), (Object)ModifierNodeElementFqName)) {
                        return null;
                    }
                    Iterable $this$filterIsInstance$iv = $this$getInspectablePropertiesFunctionOverride.getUastDeclarations();
                    boolean $i$f$filterIsInstance = false;
                    Iterable iterable = $this$filterIsInstance$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterIsInstanceTo = false;
                    Iterator iterator = $this$filterIsInstanceTo$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        Object element$iv$iv = iterator.next();
                        if (!(element$iv$iv instanceof UMethod)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    Iterable $this$firstOrNull$iv = (List)destination$iv$iv;
                    boolean $i$f$firstOrNull = false;
                    $this$filterIsInstanceTo$iv$iv = $this$firstOrNull$iv.iterator();
                    while ($this$filterIsInstanceTo$iv$iv.hasNext()) {
                        Object element$iv = $this$filterIsInstanceTo$iv$iv.next();
                        UMethod it = (UMethod)element$iv;
                        boolean bl = false;
                        if (!this.hasInspectablePropertiesSignature(it)) continue;
                        v0 = element$iv;
                        break block7;
                    }
                    v0 = null;
                }
                if ((uMethod = (UMethod)v0) != null) break block8;
                UastLanguagePlugin $i$f$firstOrNull = (UastLanguagePlugin)UastFacade.INSTANCE;
                PsiElement element$iv = (PsiElement)$this$getInspectablePropertiesFunctionOverride.getJavaPsi().getSuperClass();
                boolean $i$f$convertWithParent = false;
                if (element$iv == null) {
                    uElement = null;
                } else {
                    void $this$convertWithParent$iv;
                    UElement uElement2 = $this$convertWithParent$iv.convertElementWithParent(element$iv, UClass.class);
                    if (!(uElement2 instanceof UClass)) {
                        uElement2 = null;
                    }
                    uElement = (UElement)((UClass)uElement2);
                }
                UClass uClass = (UClass)uElement;
                if (uClass == null) break;
                $this$getInspectablePropertiesFunctionOverride = uClass;
            }
            uMethod = null;
        }
        return uMethod;
    }

    private final boolean hasInspectablePropertiesSignature(UMethod $this$hasInspectablePropertiesSignature) {
        return Intrinsics.areEqual((Object)$this$hasInspectablePropertiesSignature.getName(), (Object)InspectionFunName) && $this$hasInspectablePropertiesSignature.getParameters().length == 1 && Intrinsics.areEqual((Object)this.getReceiverFqType($this$hasInspectablePropertiesSignature), (Object)InspectionFunFqReceiver);
    }

    private final String getReceiverFqType(UMethod $this$receiverFqType) {
        KtTypeReference receiverTypeRef;
        PsiElement psiElement = $this$receiverFqType.getSourcePsi();
        KtCallableDeclaration ktCallableDeclaration = psiElement instanceof KtCallableDeclaration ? (KtCallableDeclaration)psiElement : null;
        KtTypeReference ktTypeReference = receiverTypeRef = ktCallableDeclaration != null ? ktCallableDeclaration.getReceiverTypeReference() : null;
        psiElement = ktTypeReference != null ? UastContextKt.toUElement((PsiElement)((PsiElement)ktTypeReference)) : null;
        UTypeReferenceExpression uTypeReferenceExpression = psiElement instanceof UTypeReferenceExpression ? (UTypeReferenceExpression)psiElement : null;
        return uTypeReferenceExpression != null ? uTypeReferenceExpression.getQualifiedName() : null;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Landroidx/compose/ui/lint/ModifierNodeInspectablePropertiesDetector$Companion;", "", "()V", "InspectionFunFqReceiver", "", "InspectionFunName", "ModifierNodeElementFqName", "ModifierNodeInspectableProperties", "Lcom/android/tools/lint/detector/api/Issue;", "getModifierNodeInspectableProperties", "()Lcom/android/tools/lint/detector/api/Issue;", "ui-lint"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Issue getModifierNodeInspectableProperties() {
            return ModifierNodeInspectableProperties;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

