/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.lint;

import androidx.compose.lint.Names;
import androidx.compose.lint.PsiUtilsKt;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.session.KaSessionProvider;
import org.jetbrains.kotlin.analysis.api.types.KaFunctionType;
import org.jetbrains.kotlin.analysis.api.types.KaType;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.ULocalVariable;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u00012\u00020\u0002:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0002J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a8\u0006\u0016"}, d2={"Landroidx/compose/ui/lint/ReturnFromAwaitPointerEventScopeDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "getApplicableMethodNames", "", "", "isSuspendPointerInputLambda", "", "ktLambdaExpression", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "validUseOfAwaitPointerEventScopeWithReturn", "awaitPointerEventScopeNode", "Lorg/jetbrains/uast/UCallExpression;", "visitMethodCall", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "method", "Lcom/intellij/psi/PsiMethod;", "Companion", "ui-lint"})
@SourceDebugExtension(value={"SMAP\nReturnFromAwaitPointerEventScopeDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReturnFromAwaitPointerEventScopeDetector.kt\nandroidx/compose/ui/lint/ReturnFromAwaitPointerEventScopeDetector\n+ 2 analyze.kt\norg/jetbrains/kotlin/analysis/api/AnalyzeKt\n+ 3 KtAnalysisSessionProvider.kt\norg/jetbrains/kotlin/analysis/api/session/KtAnalysisSessionProvider\n*L\n1#1,149:1\n29#2,2:150\n51#3:152\n65#3,8:153\n*S KotlinDebug\n*F\n+ 1 ReturnFromAwaitPointerEventScopeDetector.kt\nandroidx/compose/ui/lint/ReturnFromAwaitPointerEventScopeDetector\n*L\n112#1:150,2\n112#1:152\n112#1:153,8\n*E\n"})
public final class ReturnFromAwaitPointerEventScopeDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String POINTER_INPUT_SCOPE = "androidx.compose.ui.input.pointer.PointerInputScope";
    @NotNull
    private static final String POINTER_INPUT_HANDLER = "PointerInputEventHandler";
    @NotNull
    private static final String POINTER_INPUT_METHOD = "pointerInput";
    @NotNull
    private static final String COROUTINE_METHOD = "coroutineScope";
    @NotNull
    public static final String IssueId = "ReturnFromAwaitPointerEventScope";
    @NotNull
    public static final String ErrorMessage = "Returning from awaitPointerEventScope may cause some input events to be dropped";
    @NotNull
    private static final Issue ExitAwaitPointerEventScope = Issue.Companion.create("ReturnFromAwaitPointerEventScope", "Returning from awaitPointerEventScope may cause some input events to be dropped", "Pointer Input events are queued inside awaitPointerEventScope. By using the return value of awaitPointerEventScope one might unexpectedly lose events. If another awaitPointerEventScope is restarted there is no guarantee that the events will persist between those calls. In this case you should keep all events inside the awaitPointerEventScope block", Category.CORRECTNESS, 3, Severity.WARNING, new Implementation(ReturnFromAwaitPointerEventScopeDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE, (Enum)Scope.TEST_SOURCES)));

    @NotNull
    public List<String> getApplicableMethodNames() {
        return CollectionsKt.listOf((Object)Names.Ui.Pointer.INSTANCE.getAwaitPointerEventScope().getShortName());
    }

    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        boolean invalidUseOfAwaitPointerEventScopeWithReturn;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        if (!PsiUtilsKt.isInPackageName((PsiMember)method, Names.Ui.Pointer.INSTANCE.getPackageName())) {
            return;
        }
        UElement methodParent = UastUtils.skipParenthesizedExprUp((UElement)node.getUastParent());
        boolean isAssignedToVariable = methodParent instanceof ULocalVariable;
        boolean isReturnExpression = methodParent instanceof UReturnExpression;
        boolean bl = invalidUseOfAwaitPointerEventScopeWithReturn = isReturnExpression && !this.validUseOfAwaitPointerEventScopeWithReturn(node);
        if (isAssignedToVariable || invalidUseOfAwaitPointerEventScopeWithReturn) {
            JavaContext.report$default((JavaContext)context, (Issue)ExitAwaitPointerEventScope, (UElement)((UElement)node), (Location)context.getNameLocation((UElement)node), (String)ErrorMessage, null, (int)16, null);
        }
    }

    private final boolean validUseOfAwaitPointerEventScopeWithReturn(UCallExpression awaitPointerEventScopeNode) {
        for (UElement currentNode = awaitPointerEventScopeNode.getUastParent(); currentNode != null; currentNode = currentNode.getUastParent()) {
            PsiElement ktLambdaExpression;
            UElement variable;
            UExpression lambda;
            if (currentNode instanceof UCallExpression && (Intrinsics.areEqual((Object)((UCallExpression)currentNode).getMethodName(), (Object)POINTER_INPUT_HANDLER) || Intrinsics.areEqual((Object)((UCallExpression)currentNode).getMethodName(), (Object)POINTER_INPUT_METHOD) || Intrinsics.areEqual((Object)((UCallExpression)currentNode).getMethodName(), (Object)COROUTINE_METHOD))) {
                return true;
            }
            if (!(currentNode instanceof UVariable) || !((lambda = ((UVariable)(variable = currentNode)).getUastInitializer()) instanceof ULambdaExpression) || !((ktLambdaExpression = lambda.getSourcePsi()) instanceof KtLambdaExpression) || !this.isSuspendPointerInputLambda((KtLambdaExpression)ktLambdaExpression)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final boolean isSuspendPointerInputLambda(KtLambdaExpression ktLambdaExpression) {
        boolean bl;
        void this_$iv$iv$iv;
        boolean $i$f$analyze = false;
        Project project = ((KtElement)ktLambdaExpression).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KaSessionProvider this_$iv$iv = KaSessionProvider.Companion.getInstance(project);
        boolean $i$f$analyse = false;
        KaSessionProvider kaSessionProvider = this_$iv$iv;
        KaSession analysisSession$iv$iv$iv = this_$iv$iv.getAnalysisSession((KtElement)ktLambdaExpression);
        boolean $i$f$analyse2 = false;
        this_$iv$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv$iv, (KtElement)ktLambdaExpression);
        try {
            KaType kaType;
            KaFunctionType kaFunctionType;
            KaSession $this$isSuspendPointerInputLambda_u24lambda_u240 = analysisSession$iv$iv$iv;
            boolean bl2 = false;
            KaType kaType2 = $this$isSuspendPointerInputLambda_u24lambda_u240.getExpectedType((PsiElement)ktLambdaExpression);
            if ((kaType2 instanceof KaFunctionType ? (KaFunctionType)kaType2 : null) == null) {
                boolean bl3 = false;
                return bl3;
            }
            KaFunctionType type = kaFunctionType;
            bl = $this$isSuspendPointerInputLambda_u24lambda_u240.isSuspendFunctionType((KaType)type) && Intrinsics.areEqual((kaType = type.getReceiverType()) != null && (kaType = $this$isSuspendPointerInputLambda_u24lambda_u240.getExpandedSymbol(kaType)) != null && (kaType = kaType.getClassId()) != null ? kaType.asFqNameString() : null, (Object)POINTER_INPUT_SCOPE);
        }
        finally {
            this_$iv$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv$iv, (KtElement)ktLambdaExpression);
        }
        return bl;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Landroidx/compose/ui/lint/ReturnFromAwaitPointerEventScopeDetector$Companion;", "", "()V", "COROUTINE_METHOD", "", "ErrorMessage", "ExitAwaitPointerEventScope", "Lcom/android/tools/lint/detector/api/Issue;", "getExitAwaitPointerEventScope", "()Lcom/android/tools/lint/detector/api/Issue;", "IssueId", "POINTER_INPUT_HANDLER", "POINTER_INPUT_METHOD", "POINTER_INPUT_SCOPE", "ui-lint"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Issue getExitAwaitPointerEventScope() {
            return ExitAwaitPointerEventScope;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

