/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.lint;

import com.android.tools.lint.detector.api.Context;
import com.android.utils.DomExtensions;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002\u001a\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0006H\u0002\u001a\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"FEATURE_WATCH", "", "WearPackage", "containsWearFeature", "", "manifest", "Lorg/w3c/dom/Element;", "isWearFeature", "element", "isWearProject", "context", "Lcom/android/tools/lint/detector/api/Context;", "ui-lint"})
public final class ConfigurationScreenWidthHeightDetectorKt {
    @NotNull
    private static final String WearPackage = "androidx.wear";
    @NotNull
    private static final String FEATURE_WATCH = "android.hardware.type.watch";

    private static final boolean isWearProject(Context context) {
        Document document = context.getMainProject().getMergedManifest();
        return ConfigurationScreenWidthHeightDetectorKt.containsWearFeature(document != null ? document.getDocumentElement() : null);
    }

    private static final boolean containsWearFeature(Element manifest) {
        if (manifest == null) {
            return false;
        }
        Iterator iterator = DomExtensions.iterator((Element)manifest);
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            if (!ConfigurationScreenWidthHeightDetectorKt.isWearFeature(element)) continue;
            return true;
        }
        return false;
    }

    private static final boolean isWearFeature(Element element) {
        return Intrinsics.areEqual((Object)element.getTagName(), (Object)"uses-feature") && element.getAttributeNS("http://schemas.android.com/apk/res/android", "name").equals(FEATURE_WATCH);
    }

    public static final /* synthetic */ boolean access$isWearProject(Context context) {
        return ConfigurationScreenWidthHeightDetectorKt.isWearProject(context);
    }
}

