/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.lint;

import androidx.compose.lint.ComposableUtilsKt;
import androidx.compose.lint.Names;
import androidx.compose.lint.PsiUtilsKt;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u00012\u00020\u0002:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Landroidx/compose/ui/lint/ComposedModifierDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "getApplicableMethodNames", "", "", "visitMethodCall", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "Companion", "ui-lint"})
@SourceDebugExtension(value={"SMAP\nComposedModifierDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposedModifierDetector.kt\nandroidx/compose/ui/lint/ComposedModifierDetector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,111:1\n1#2:112\n*E\n"})
public final class ComposedModifierDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Issue UnnecessaryComposedModifier = Issue.Companion.create("UnnecessaryComposedModifier", "Modifier.composed should only be used for modifiers that invoke @Composable functions", "`Modifier.composed` allows invoking @Composable functions when creating a `Modifier` instance - for example, using `remember` to have instance-specific state, allowing the same `Modifier` object to be safely used in multiple places. Using `Modifier.composed` without calling any @Composable functions inside is unnecessary, and since the Modifier is no longer skippable, this can cause a lot of extra work inside the composed body, leading to worse performance.", Category.CORRECTNESS, 3, Severity.WARNING, new Implementation(ComposedModifierDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE, (Enum)Scope.TEST_SOURCES)));

    @NotNull
    public List<String> getApplicableMethodNames() {
        return CollectionsKt.listOf((Object)Names.Ui.INSTANCE.getComposed().getShortName());
    }

    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Object v1;
        block4: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            if (!PsiUtilsKt.isInPackageName((PsiMember)method, Names.Ui.INSTANCE.getPackageName())) {
                return;
            }
            Iterable iterable = node.getValueArguments();
            for (Object t : iterable) {
                UExpression it = (UExpression)t;
                boolean bl = false;
                PsiParameter psiParameter = UastUtils.getParameterForArgument((UCallExpression)node, (UExpression)it);
                if (!Intrinsics.areEqual((Object)(psiParameter != null ? psiParameter.getName() : null), (Object)"factory")) continue;
                v1 = t;
                break block4;
            }
            v1 = null;
        }
        UExpression uExpression = v1;
        if (uExpression == null) {
            return;
        }
        UExpression factoryLambda = uExpression;
        Ref.BooleanRef hasComposableCall = new Ref.BooleanRef();
        factoryLambda.accept((UastVisitor)new AbstractUastVisitor(hasComposableCall){
            final /* synthetic */ Ref.BooleanRef $hasComposableCall;
            {
                this.$hasComposableCall = $hasComposableCall;
            }

            public boolean visitCallExpression(UCallExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                PsiElement psiElement = UastUtils.tryResolve((UElement)((UElement)node));
                return this.hasComposableCall(psiElement instanceof PsiMethod ? (PsiMethod)psiElement : null);
            }

            public boolean visitSimpleNameReferenceExpression(USimpleNameReferenceExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                PsiElement psiElement = UastUtils.tryResolve((UElement)((UElement)node));
                return this.hasComposableCall(psiElement instanceof PsiMethod ? (PsiMethod)psiElement : null);
            }

            private final boolean hasComposableCall(PsiMethod $this$hasComposableCall) {
                PsiMethod psiMethod = $this$hasComposableCall;
                boolean bl = psiMethod != null ? ComposableUtilsKt.isComposable(psiMethod) : false;
                if (bl) {
                    this.$hasComposableCall.element = true;
                }
                return this.$hasComposableCall.element;
            }
        });
        if (!hasComposableCall.element) {
            JavaContext.report$default((JavaContext)context, (Issue)UnnecessaryComposedModifier, (UElement)((UElement)node), (Location)context.getNameLocation((UElement)node), (String)"Unnecessary use of Modifier.composed", null, (int)16, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Landroidx/compose/ui/lint/ComposedModifierDetector$Companion;", "", "()V", "UnnecessaryComposedModifier", "Lcom/android/tools/lint/detector/api/Issue;", "getUnnecessaryComposedModifier", "()Lcom/android/tools/lint/detector/api/Issue;", "ui-lint"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Issue getUnnecessaryComposedModifier() {
            return UnnecessaryComposedModifier;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

