/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.lint;

import androidx.compose.lint.ComposableUtilsKt;
import androidx.compose.lint.Names;
import androidx.compose.lint.PsiUtilsKt;
import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiType;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UObjectLiteralExpression;
import org.jetbrains.uast.UastCallKind;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00132\u00020\u00012\u00020\u0002:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0016\u0010\b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n0\tH\u0016J\f\u0010\f\u001a\u00020\r*\u00020\u000eH\u0002J\f\u0010\u000f\u001a\u00020\r*\u00020\u000eH\u0002J\f\u0010\u0010\u001a\u00020\r*\u00020\u0011H\u0002J\f\u0010\u0012\u001a\u00020\r*\u00020\u000eH\u0002\u00a8\u0006\u0014"}, d2={"Landroidx/compose/runtime/lint/UnrememberedStateDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "getApplicableUastTypes", "", "Ljava/lang/Class;", "Lorg/jetbrains/uast/UElement;", "isStateConstructorInvocation", "", "Lorg/jetbrains/uast/UCallExpression;", "isStateFactoryInvocation", "isStateObjectLiteral", "Lorg/jetbrains/uast/UObjectLiteralExpression;", "isUnrememberedStateCreation", "Companion", "runtime-lint"})
@SourceDebugExtension(value={"SMAP\nUnrememberedStateDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnrememberedStateDetector.kt\nandroidx/compose/runtime/lint/UnrememberedStateDetector\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,109:1\n12474#2,2:110\n*S KotlinDebug\n*F\n+ 1 UnrememberedStateDetector.kt\nandroidx/compose/runtime/lint/UnrememberedStateDetector\n*L\n79#1:110,2\n*E\n"})
public final class UnrememberedStateDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String FqStateFactoryAnnotationName = "androidx.compose.runtime.snapshots.StateFactoryMarker";
    @NotNull
    private static final Issue UnrememberedState = Issue.Companion.create("UnrememberedMutableState", "Creating a state object during composition without using `remember`", "State objects created during composition need to be `remember`ed, otherwise they will be recreated during recomposition, and lose their state. Either hoist the state to an object that is not created during composition, or wrap the state in a call to `remember`.", Category.CORRECTNESS, 3, Severity.ERROR, new Implementation(UnrememberedStateDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE, (Enum)Scope.TEST_SOURCES)));

    @NotNull
    public List<Class<? extends UElement>> getApplicableUastTypes() {
        Object[] objectArray = new Class[]{UCallExpression.class, UObjectLiteralExpression.class};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public UElementHandler createUastHandler(@NotNull JavaContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new UElementHandler(this, context){
            final /* synthetic */ UnrememberedStateDetector this$0;
            final /* synthetic */ JavaContext $context;
            {
                this.this$0 = $receiver;
                this.$context = $context;
            }

            public void visitCallExpression(UCallExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if (UnrememberedStateDetector.access$isUnrememberedStateCreation(this.this$0, node)) {
                    JavaContext.report$default((JavaContext)this.$context, (Issue)UnrememberedStateDetector.Companion.getUnrememberedState(), (UElement)((UElement)node), (Location)this.$context.getNameLocation((UElement)node), (String)"Creating a state object during composition without using `remember`", null, (int)16, null);
                }
            }

            public void visitObjectLiteralExpression(UObjectLiteralExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if (UnrememberedStateDetector.access$isStateObjectLiteral(this.this$0, node) && ComposableUtilsKt.isNotRemembered((UCallExpression)node)) {
                    JavaContext.report$default((JavaContext)this.$context, (Issue)UnrememberedStateDetector.Companion.getUnrememberedState(), (UElement)((UElement)node), (Location)this.$context.getNameLocation((UElement)node), (String)"Creating a state object during composition without using `remember`", null, (int)16, null);
                }
            }
        };
    }

    private final boolean isUnrememberedStateCreation(UCallExpression $this$isUnrememberedStateCreation) {
        return (this.isStateFactoryInvocation($this$isUnrememberedStateCreation) || this.isStateConstructorInvocation($this$isUnrememberedStateCreation)) && ComposableUtilsKt.isNotRemembered($this$isUnrememberedStateCreation);
    }

    private final boolean isStateFactoryInvocation(UCallExpression $this$isStateFactoryInvocation) {
        boolean bl;
        block3: {
            PsiAnnotation[] psiAnnotationArray = $this$isStateFactoryInvocation.resolve();
            if (psiAnnotationArray != null && (psiAnnotationArray = psiAnnotationArray.getAnnotations()) != null) {
                PsiAnnotation[] $this$any$iv = psiAnnotationArray;
                boolean $i$f$any = false;
                int n = $this$any$iv.length;
                for (int i = 0; i < n; ++i) {
                    PsiAnnotation element$iv;
                    PsiAnnotation it = element$iv = $this$any$iv[i];
                    boolean bl2 = false;
                    if (!it.hasQualifiedName(FqStateFactoryAnnotationName)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            } else {
                bl = false;
            }
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isStateConstructorInvocation(UCallExpression $this$isStateConstructorInvocation) {
        if (!Intrinsics.areEqual((Object)$this$isStateConstructorInvocation.getKind(), (Object)UastCallKind.CONSTRUCTOR_CALL)) return false;
        PsiType psiType = $this$isStateConstructorInvocation.getReturnType();
        if (psiType == null) return false;
        if (!PsiUtilsKt.inheritsFrom(psiType, Names.Runtime.INSTANCE.getState())) return false;
        return true;
    }

    private final boolean isStateObjectLiteral(UObjectLiteralExpression $this$isStateObjectLiteral) {
        PsiType psiType = $this$isStateObjectLiteral.getExpressionType();
        return psiType != null ? PsiUtilsKt.inheritsFrom(psiType, Names.Runtime.INSTANCE.getState()) : false;
    }

    public static final /* synthetic */ boolean access$isUnrememberedStateCreation(UnrememberedStateDetector $this, UCallExpression $receiver) {
        return $this.isUnrememberedStateCreation($receiver);
    }

    public static final /* synthetic */ boolean access$isStateObjectLiteral(UnrememberedStateDetector $this, UObjectLiteralExpression $receiver) {
        return $this.isStateObjectLiteral($receiver);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Landroidx/compose/runtime/lint/UnrememberedStateDetector$Companion;", "", "()V", "FqStateFactoryAnnotationName", "", "UnrememberedState", "Lcom/android/tools/lint/detector/api/Issue;", "getUnrememberedState", "()Lcom/android/tools/lint/detector/api/Issue;", "runtime-lint"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Issue getUnrememberedState() {
            return UnrememberedState;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

