/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.lint;

import androidx.compose.lint.Names;
import androidx.compose.lint.PsiUtilsKt;
import androidx.compose.ui.lint.SuspiciousModifierThenDetectorKt;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.UastLintUtilsKt;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.resolution.KaImplicitReceiverValue;
import org.jetbrains.kotlin.analysis.api.session.KaSessionProvider;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u00012\u00020\u0002:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Landroidx/compose/ui/lint/SuspiciousModifierThenDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "getApplicableMethodNames", "", "", "visitMethodCall", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "Companion", "ui-lint"})
public final class SuspiciousModifierThenDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Issue SuspiciousModifierThen = Issue.Companion.create("SuspiciousModifierThen", "Using Modifier.then with a Modifier factory function with an implicit receiver", "Calling a Modifier factory function with an implicit receiver inside Modifier.then will result in the receiver (`this`) being added twice to the chain. For example, fun Modifier.myModifier() = this.then(otherModifier()) - the implementation of factory functions such as Modifier.otherModifier() will internally call this.then(...) to chain the provided modifier with their implementation. When you expand this.then(otherModifier()), it becomes: this.then(this.then(OtherModifierImplementation)) - so you can see that `this` is included twice in the chain, which results in modifiers such as padding being applied twice, for example. Instead, you should either remove the then() and directly chain the factory function on the receiver, this.otherModifier(), or add the empty Modifier as the receiver for the factory, such as this.then(Modifier.otherModifier())", Category.CORRECTNESS, 3, Severity.ERROR, new Implementation(SuspiciousModifierThenDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE, (Enum)Scope.TEST_SOURCES)));

    @NotNull
    public List<String> getApplicableMethodNames() {
        return CollectionsKt.listOf((Object)"then");
    }

    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        if (!PsiUtilsKt.isInPackageName((PsiMember)method, Names.Ui.INSTANCE.getPackageName())) {
            return;
        }
        UExpression uExpression = (UExpression)CollectionsKt.firstOrNull((List)node.getValueArguments());
        if (uExpression == null) {
            return;
        }
        UExpression otherModifierArgument = uExpression;
        PsiElement psiElement = otherModifierArgument.getSourcePsi();
        if (psiElement == null) {
            return;
        }
        PsiElement otherModifierArgumentSource = psiElement;
        otherModifierArgument.accept((UastVisitor)new AbstractUastVisitor(otherModifierArgumentSource, context){
            final /* synthetic */ PsiElement $otherModifierArgumentSource;
            final /* synthetic */ JavaContext $context;
            {
                this.$otherModifierArgumentSource = $otherModifierArgumentSource;
                this.$context = $context;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public boolean visitCallExpression(UCallExpression node) {
                PsiElement psiElement;
                void this_$iv$iv$iv;
                void this_$iv$iv;
                boolean usesImplicitThis;
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                PsiType psiType = node.getReceiverType();
                boolean hasModifierReceiverType = psiType != null ? PsiUtilsKt.inheritsFrom(psiType, Names.Ui.INSTANCE.getModifier()) : false;
                boolean bl = usesImplicitThis = node.getReceiver() == null;
                if (!hasModifierReceiverType || !usesImplicitThis) {
                    return false;
                }
                PsiElement psiElement2 = node.getSourcePsi();
                KtCallExpression ktCallExpression = psiElement2 instanceof KtCallExpression ? (KtCallExpression)psiElement2 : null;
                if (ktCallExpression == null) {
                    return false;
                }
                KtCallExpression ktCallExpression2 = ktCallExpression;
                boolean $i$f$analyze = false;
                Project project = ((KtElement)ktCallExpression2).getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                KaSessionProvider kaSessionProvider = KaSessionProvider.Companion.getInstance(project);
                boolean $i$f$analyse = false;
                void var9_9 = this_$iv$iv;
                KaSession analysisSession$iv$iv$iv = this_$iv$iv.getAnalysisSession((KtElement)ktCallExpression2);
                boolean $i$f$analyse2 = false;
                this_$iv$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv$iv, (KtElement)ktCallExpression2);
                try {
                    KaSession $this$visitCallExpression_u24lambda_u240 = analysisSession$iv$iv$iv;
                    boolean bl2 = false;
                    KaImplicitReceiverValue kaImplicitReceiverValue = SuspiciousModifierThenDetectorKt.access$getImplicitReceiverValue($this$visitCallExpression_u24lambda_u240, (KtExpression)ktCallExpression2);
                    psiElement = kaImplicitReceiverValue != null ? SuspiciousModifierThenDetectorKt.access$getImplicitReceiverPsi(kaImplicitReceiverValue) : null;
                }
                finally {
                    this_$iv$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv$iv, (KtElement)ktCallExpression2);
                }
                PsiElement implicitReceiver = psiElement;
                if (UastLintUtilsKt.isBelow$default((PsiElement)implicitReceiver, (PsiElement)this.$otherModifierArgumentSource, (boolean)false, (int)2, null)) {
                    return false;
                }
                JavaContext.report$default((JavaContext)this.$context, (Issue)SuspiciousModifierThenDetector.Companion.getSuspiciousModifierThen(), (UElement)((UElement)node), (Location)this.$context.getNameLocation((UElement)node), (String)"Using Modifier.then with a Modifier factory function with an implicit receiver", null, (int)16, null);
                return false;
            }
        });
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Landroidx/compose/ui/lint/SuspiciousModifierThenDetector$Companion;", "", "()V", "SuspiciousModifierThen", "Lcom/android/tools/lint/detector/api/Issue;", "getSuspiciousModifierThen", "()Lcom/android/tools/lint/detector/api/Issue;", "ui-lint"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Issue getSuspiciousModifierThen() {
            return SuspiciousModifierThen;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

