/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.lint;

import androidx.compose.lint.Names;
import androidx.compose.lint.NamesKt;
import androidx.compose.lint.PackageName;
import androidx.compose.lint.PsiUtilsKt;
import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00102\u00020\u00012\u00020\u0002:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0014\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\tH\u0016J\f\u0010\f\u001a\u00020\r*\u00020\u000eH\u0002J\f\u0010\u000f\u001a\u00020\r*\u00020\u000eH\u0002\u00a8\u0006\u0011"}, d2={"Landroidx/compose/ui/lint/LocalContextConfigurationReadDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "getApplicableUastTypes", "", "Ljava/lang/Class;", "Lorg/jetbrains/uast/UQualifiedReferenceExpression;", "isCallToGetConfiguration", "", "Lorg/jetbrains/uast/UElement;", "isCallToGetResources", "Companion", "ui-lint"})
public final class LocalContextConfigurationReadDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String LocalContextCurrentResourcesConfiguration = "LocalContext.current.resources.configuration";
    @NotNull
    private static final String LocalConfigurationCurrent = "LocalConfiguration.current";
    @NotNull
    private static final PackageName ContentPackage = NamesKt.Package("android.content");
    @NotNull
    private static final PackageName ResPackage = NamesKt.Package("android.content.res");
    @NotNull
    private static final Issue LocalContextConfigurationRead = Issue.Companion.create("LocalContextConfigurationRead", "Reading Configuration using LocalContext.current.resources.configuration", "Changes to the Configuration object will not cause LocalContext reads to be invalidated, so you may end up with stale values when the Configuration changes. Instead, use LocalConfiguration.current to retrieve the Configuration - this will recompose callers when the Configuration object changes.", Category.CORRECTNESS, 3, Severity.ERROR, new Implementation(LocalContextConfigurationReadDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE, (Enum)Scope.TEST_SOURCES)));

    @NotNull
    public List<Class<UQualifiedReferenceExpression>> getApplicableUastTypes() {
        return CollectionsKt.listOf(UQualifiedReferenceExpression.class);
    }

    @NotNull
    public UElementHandler createUastHandler(@NotNull JavaContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new UElementHandler(context, this){
            final /* synthetic */ JavaContext $context;
            final /* synthetic */ LocalContextConfigurationReadDetector this$0;
            {
                this.$context = $context;
                this.this$0 = $receiver;
            }

            public void visitQualifiedReferenceExpression(UQualifiedReferenceExpression node) {
                UQualifiedReferenceExpression uQualifiedReferenceExpression;
                UExpression contextExpression;
                UDeclaration uDeclaration;
                UExpression uExpression;
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if (UastUtils.matchesQualified((UExpression)((UExpression)node), (String)"LocalContext.current.resources.configuration")) {
                    String[] stringArray = new String[]{Names.Ui.Platform.INSTANCE.getLocalConfiguration().getJavaFqn()};
                    this.$context.report(LocalContextConfigurationReadDetector.Companion.getLocalContextConfigurationRead(), (UElement)node, this.$context.getNameLocation((UElement)node), "Reading Configuration using LocalContext.current.resources.configuration", LintFix.Companion.create().replace().name("Replace with LocalConfiguration.current").all().with("LocalConfiguration.current").imports(stringArray).autoFix().build());
                    return;
                }
                UExpression selector = UastUtils.skipParenthesizedExprDown((UExpression)node.getSelector());
                if (!LocalContextConfigurationReadDetector.access$isCallToGetConfiguration(this.this$0, (UElement)selector)) {
                    return;
                }
                UExpression resources = UastUtils.skipParenthesizedExprDown((UExpression)node.getReceiver());
                UExpression uExpression2 = resources;
                if (uExpression2 instanceof UQualifiedReferenceExpression) {
                    if (!LocalContextConfigurationReadDetector.access$isCallToGetResources(this.this$0, (UElement)resources)) {
                        return;
                    }
                    uExpression = UastUtils.skipParenthesizedExprDown((UExpression)((UQualifiedReferenceExpression)resources).getReceiver());
                } else if (uExpression2 instanceof USimpleNameReferenceExpression) {
                    uDeclaration = UastLintUtils.Companion.tryResolveUDeclaration((UElement)resources);
                    UVariable uVariable = uDeclaration instanceof UVariable ? (UVariable)uDeclaration : null;
                    if (uVariable == null || (uVariable = uVariable.getUastInitializer()) == null) {
                        return;
                    }
                    UVariable initializer = uVariable;
                    if (!(initializer instanceof UQualifiedReferenceExpression)) {
                        return;
                    }
                    if (!LocalContextConfigurationReadDetector.access$isCallToGetResources(this.this$0, (UElement)initializer)) {
                        return;
                    }
                    uExpression = UastUtils.skipParenthesizedExprDown((UExpression)((UQualifiedReferenceExpression)initializer).getReceiver());
                } else {
                    return;
                }
                UExpression uExpression3 = contextExpression = uExpression;
                if (uExpression3 instanceof UQualifiedReferenceExpression) {
                    uQualifiedReferenceExpression = (UQualifiedReferenceExpression)contextExpression;
                } else if (uExpression3 instanceof USimpleNameReferenceExpression) {
                    UDeclaration uDeclaration2 = UastLintUtils.Companion.tryResolveUDeclaration((UElement)contextExpression);
                    UVariable uVariable = uDeclaration = uDeclaration2 instanceof UVariable ? (UVariable)uDeclaration2 : null;
                    if (uDeclaration == null || (uDeclaration2 = uDeclaration.getUastInitializer()) == null) {
                        return;
                    }
                    UDeclaration initializer = uDeclaration2;
                    if (!(initializer instanceof UQualifiedReferenceExpression)) {
                        return;
                    }
                    uQualifiedReferenceExpression = (UQualifiedReferenceExpression)initializer;
                } else {
                    return;
                }
                UQualifiedReferenceExpression contextSource = uQualifiedReferenceExpression;
                if (UastUtils.matchesQualified((UExpression)((UExpression)contextSource), (String)"LocalContext.current")) {
                    JavaContext.report$default((JavaContext)this.$context, (Issue)LocalContextConfigurationReadDetector.Companion.getLocalContextConfigurationRead(), (UElement)((UElement)node), (Location)this.$context.getNameLocation((UElement)node), (String)"Reading Configuration using LocalContext.current.resources.configuration", null, (int)16, null);
                }
            }
        };
    }

    private final boolean isCallToGetConfiguration(UElement $this$isCallToGetConfiguration) {
        PsiElement psiElement = UastUtils.tryResolve((UElement)$this$isCallToGetConfiguration);
        PsiMethod psiMethod = psiElement instanceof PsiMethod ? (PsiMethod)psiElement : null;
        if (psiMethod == null) {
            return false;
        }
        PsiMethod resolved = psiMethod;
        return Intrinsics.areEqual((Object)resolved.getName(), (Object)"getConfiguration") && PsiUtilsKt.isInPackageName((PsiMember)resolved, ResPackage);
    }

    private final boolean isCallToGetResources(UElement $this$isCallToGetResources) {
        PsiElement psiElement = UastUtils.tryResolve((UElement)$this$isCallToGetResources);
        PsiMethod psiMethod = psiElement instanceof PsiMethod ? (PsiMethod)psiElement : null;
        if (psiMethod == null) {
            return false;
        }
        PsiMethod resolved = psiMethod;
        return Intrinsics.areEqual((Object)resolved.getName(), (Object)"getResources") && PsiUtilsKt.isInPackageName((PsiMember)resolved, ContentPackage);
    }

    public static final /* synthetic */ boolean access$isCallToGetConfiguration(LocalContextConfigurationReadDetector $this, UElement $receiver) {
        return $this.isCallToGetConfiguration($receiver);
    }

    public static final /* synthetic */ boolean access$isCallToGetResources(LocalContextConfigurationReadDetector $this, UElement $receiver) {
        return $this.isCallToGetResources($receiver);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Landroidx/compose/ui/lint/LocalContextConfigurationReadDetector$Companion;", "", "()V", "ContentPackage", "Landroidx/compose/lint/PackageName;", "LocalConfigurationCurrent", "", "LocalContextConfigurationRead", "Lcom/android/tools/lint/detector/api/Issue;", "getLocalContextConfigurationRead", "()Lcom/android/tools/lint/detector/api/Issue;", "LocalContextCurrentResourcesConfiguration", "ResPackage", "ui-lint"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Issue getLocalContextConfigurationRead() {
            return LocalContextConfigurationRead;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

