/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.lint;

import androidx.compose.lint.Names;
import androidx.compose.ui.lint.ModifierDeclarationDetector;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.resolution.KaCall;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfo;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfoKt;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallableMemberCall;
import org.jetbrains.kotlin.analysis.api.resolution.KaImplicitReceiverValue;
import org.jetbrains.kotlin.analysis.api.resolution.KaPartiallyAppliedSymbol;
import org.jetbrains.kotlin.analysis.api.session.KaSessionProvider;
import org.jetbrains.kotlin.analysis.api.symbols.KaCallableSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaDeclarationSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaNamedFunctionSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaReceiverParameterSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbol;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UThisExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0014\u0010\u0005\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u001c\u0010\n\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u0014\u0010\r\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\"\u001a\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u000e"}, d2={"returnTypeString", "", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "getReturnTypeString", "(Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;)Ljava/lang/String;", "checkReceiver", "", "Lorg/jetbrains/uast/UMethod;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "checkReturnType", "returnType", "Lcom/intellij/psi/PsiType;", "ensureReceiverIsReferenced", "ui-lint"})
public final class ModifierDeclarationDetectorKt {
    private static final void checkReceiver(UMethod $this$checkReceiver, JavaContext context) {
        KtCallableDeclaration ktCallableDeclaration;
        PsiElement source = $this$checkReceiver.getSourcePsi();
        if (source instanceof KtFunction) {
            ktCallableDeclaration = (KtCallableDeclaration)source;
        } else if (source instanceof KtPropertyAccessor) {
            KtProperty ktProperty = ((KtPropertyAccessor)source).getProperty();
            Intrinsics.checkNotNullExpressionValue((Object)ktProperty, (String)"getProperty(...)");
            ktCallableDeclaration = (KtCallableDeclaration)ktProperty;
        } else {
            return;
        }
        KtCallableDeclaration source2 = ktCallableDeclaration;
        KtTypeReference receiverTypeReference = source2.getReceiverTypeReference();
        if (receiverTypeReference == null) {
            PsiElement psiElement = source2.getNameIdentifier();
            Intrinsics.checkNotNull((Object)psiElement);
            String name = psiElement.getText();
            ModifierDeclarationDetectorKt.checkReceiver$report(context, $this$checkReceiver, LintFix.Companion.create().replace().name("Add Modifier receiver").range(context.getLocation((PsiElement)source2)).text(name).with(Names.Ui.INSTANCE.getModifier().getShortName() + "." + name).autoFix().build());
        } else {
            boolean hasModifierReceiver;
            KtTypeElement ktTypeElement = receiverTypeReference.getTypeElement();
            Intrinsics.checkNotNull((Object)ktTypeElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtUserType");
            KtUserType receiverType = (KtUserType)ktTypeElement;
            String receiverShortName = receiverType.getReferencedName();
            UElement uElement = UastContextKt.toUElement((PsiElement)((PsiElement)receiverType.getReferenceExpression()));
            UElement uElement2 = UastContextKt.toUElement((PsiElement)(uElement != null ? UastUtils.tryResolve((UElement)uElement) : null));
            PsiClass psiClass = uElement2 instanceof PsiClass ? (PsiClass)uElement2 : null;
            String receiverFqn = psiClass != null ? psiClass.getQualifiedName() : null;
            boolean bl = hasModifierReceiver = receiverFqn != null ? Intrinsics.areEqual((Object)receiverFqn, (Object)Names.Ui.INSTANCE.getModifier().getJavaFqn()) : Intrinsics.areEqual((Object)receiverShortName, (Object)Names.Ui.INSTANCE.getModifier().getShortName());
            if (!hasModifierReceiver) {
                ModifierDeclarationDetectorKt.checkReceiver$report(context, $this$checkReceiver, LintFix.Companion.create().replace().name("Change receiver to Modifier").range(context.getLocation((PsiElement)source2)).text(receiverShortName).with(Names.Ui.INSTANCE.getModifier().getShortName()).autoFix().build());
            } else if ($this$checkReceiver.getUastBody() != null) {
                ModifierDeclarationDetectorKt.ensureReceiverIsReferenced($this$checkReceiver, context);
            }
        }
    }

    private static final void ensureReceiverIsReferenced(UMethod $this$ensureReceiverIsReferenced, JavaContext context) {
        UMethod factoryMethod = $this$ensureReceiverIsReferenced;
        Ref.BooleanRef isReceiverReferenced = new Ref.BooleanRef();
        $this$ensureReceiverIsReferenced.accept((UastVisitor)new AbstractUastVisitor(isReceiverReferenced, factoryMethod){
            final /* synthetic */ Ref.BooleanRef $isReceiverReferenced;
            final /* synthetic */ UMethod $factoryMethod;
            {
                this.$isReceiverReferenced = $isReceiverReferenced;
                this.$factoryMethod = $factoryMethod;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public boolean visitCallExpression(UCallExpression node) {
                void this_$iv$iv$iv;
                void this_$iv$iv;
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                PsiElement psiElement = node.getSourcePsi();
                KtCallExpression ktCallExpression = psiElement instanceof KtCallExpression ? (KtCallExpression)psiElement : null;
                if (ktCallExpression == null) {
                    return this.$isReceiverReferenced.element;
                }
                KtCallExpression ktCallExpression2 = ktCallExpression;
                Ref.BooleanRef booleanRef = this.$isReceiverReferenced;
                psiElement = this.$factoryMethod;
                boolean $i$f$analyze = false;
                Project project = ((KtElement)ktCallExpression2).getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                KaSessionProvider kaSessionProvider = KaSessionProvider.Companion.getInstance(project);
                boolean $i$f$analyse = false;
                void var8_8 = this_$iv$iv;
                KaSession analysisSession$iv$iv$iv = this_$iv$iv.getAnalysisSession((KtElement)ktCallExpression2);
                boolean $i$f$analyse2 = false;
                this_$iv$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv$iv, (KtElement)ktCallExpression2);
                try {
                    KaNamedFunctionSymbol enclosingMethodSymbol;
                    KaImplicitReceiverValue kaImplicitReceiverValue;
                    KaCall kaCall;
                    Iterable $this$singleOrNull$iv$iv;
                    KaSession $this$visitCallExpression_u24lambda_u240 = analysisSession$iv$iv$iv;
                    boolean bl = false;
                    KaCallInfo kaCallInfo = $this$visitCallExpression_u24lambda_u240.resolveToCall((KtElement)ktCallExpression2);
                    if (kaCallInfo != null) {
                        Object v3;
                        block13: {
                            KaCallInfo $this$singleCallOrNull$iv = kaCallInfo;
                            boolean $i$f$singleCallOrNull = false;
                            $this$singleOrNull$iv$iv = KaCallInfoKt.getCalls((KaCallInfo)$this$singleCallOrNull$iv);
                            boolean $i$f$singleOrNull = false;
                            Object single$iv$iv = null;
                            boolean found$iv$iv = false;
                            for (T element$iv$iv : $this$singleOrNull$iv$iv) {
                                KaCall it$iv = (KaCall)element$iv$iv;
                                boolean bl2 = false;
                                if (!(it$iv instanceof KaCall)) continue;
                                if (found$iv$iv) {
                                    v3 = null;
                                    break block13;
                                }
                                single$iv$iv = element$iv$iv;
                                found$iv$iv = true;
                            }
                            v3 = !found$iv$iv ? null : single$iv$iv;
                        }
                        kaCall = v3;
                    } else {
                        kaCall = null;
                    }
                    KaCall ktCall = kaCall;
                    KaCallableMemberCall kaCallableMemberCall = ktCall instanceof KaCallableMemberCall ? (KaCallableMemberCall)ktCall : null;
                    Object callee = kaCallableMemberCall != null ? kaCallableMemberCall.getPartiallyAppliedSymbol() : null;
                    Object object = callee;
                    if (object == null || (object = object.getExtensionReceiver()) == null) {
                        KaPartiallyAppliedSymbol kaPartiallyAppliedSymbol = callee;
                        object = kaPartiallyAppliedSymbol != null ? kaPartiallyAppliedSymbol.getDispatchReceiver() : null;
                    }
                    if ((($this$singleOrNull$iv$iv = object) instanceof KaImplicitReceiverValue ? (KaImplicitReceiverValue)$this$singleOrNull$iv$iv : null) == null) {
                        boolean bl3 = booleanRef.element;
                        return bl3;
                    }
                    KaImplicitReceiverValue receiver = kaImplicitReceiverValue;
                    $this$singleOrNull$iv$iv = receiver.getSymbol();
                    KaReceiverParameterSymbol symbol = $this$singleOrNull$iv$iv instanceof KaReceiverParameterSymbol ? (KaReceiverParameterSymbol)$this$singleOrNull$iv$iv : null;
                    PsiElement psiElement2 = psiElement.getSourcePsi();
                    KtDeclaration ktDeclaration = psiElement2 instanceof KtDeclaration ? (KtDeclaration)psiElement2 : null;
                    KaDeclarationSymbol kaDeclarationSymbol = ktDeclaration != null ? $this$visitCallExpression_u24lambda_u240.getSymbol(ktDeclaration) : null;
                    KaNamedFunctionSymbol kaNamedFunctionSymbol = enclosingMethodSymbol = kaDeclarationSymbol instanceof KaNamedFunctionSymbol ? (KaNamedFunctionSymbol)kaDeclarationSymbol : null;
                    if (Intrinsics.areEqual((Object)symbol, (Object)(kaNamedFunctionSymbol != null ? kaNamedFunctionSymbol.getReceiverParameter() : null))) {
                        booleanRef.element = true;
                        boolean bl4 = true;
                        return bl4;
                    }
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    this_$iv$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv$iv, (KtElement)ktCallExpression2);
                }
                return this.$isReceiverReferenced.element;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public boolean visitThisExpression(UThisExpression node) {
                void this_$iv$iv$iv;
                void this_$iv$iv;
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                PsiElement psiElement = node.getSourcePsi();
                KtThisExpression ktThisExpression = psiElement instanceof KtThisExpression ? (KtThisExpression)psiElement : null;
                if (ktThisExpression == null) {
                    return this.$isReceiverReferenced.element;
                }
                KtThisExpression ktThisExpression2 = ktThisExpression;
                UMethod uMethod = this.$factoryMethod;
                psiElement = this.$isReceiverReferenced;
                boolean $i$f$analyze = false;
                Project project = ((KtElement)ktThisExpression2).getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                KaSessionProvider kaSessionProvider = KaSessionProvider.Companion.getInstance(project);
                boolean $i$f$analyse = false;
                void var8_8 = this_$iv$iv;
                KaSession analysisSession$iv$iv$iv = this_$iv$iv.getAnalysisSession((KtElement)ktThisExpression2);
                boolean $i$f$analyse2 = false;
                this_$iv$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv$iv, (KtElement)ktThisExpression2);
                try {
                    KaNamedFunctionSymbol enclosingMethodSymbol;
                    KaSymbol symbol;
                    KaSession $this$visitThisExpression_u24lambda_u241 = analysisSession$iv$iv$iv;
                    boolean bl = false;
                    KtReferenceExpression ktReferenceExpression = ktThisExpression2.getInstanceReference();
                    Intrinsics.checkNotNullExpressionValue((Object)ktReferenceExpression, (String)"getInstanceReference(...)");
                    KaSymbol kaSymbol = symbol = $this$visitThisExpression_u24lambda_u241.resolveToSymbol(ReferenceUtilsKt.getMainReference((KtReferenceExpression)ktReferenceExpression));
                    KaCallableSymbol referredMethodSymbol = kaSymbol instanceof KaReceiverParameterSymbol ? ((KaReceiverParameterSymbol)symbol).getOwningCallableSymbol() : (kaSymbol instanceof KaCallableSymbol ? (KaCallableSymbol)symbol : null);
                    PsiElement psiElement2 = uMethod.getSourcePsi();
                    KtDeclaration ktDeclaration = psiElement2 instanceof KtDeclaration ? (KtDeclaration)psiElement2 : null;
                    KaDeclarationSymbol kaDeclarationSymbol = ktDeclaration != null ? $this$visitThisExpression_u24lambda_u241.getSymbol(ktDeclaration) : null;
                    KaNamedFunctionSymbol kaNamedFunctionSymbol = enclosingMethodSymbol = kaDeclarationSymbol instanceof KaNamedFunctionSymbol ? (KaNamedFunctionSymbol)kaDeclarationSymbol : null;
                    if (Intrinsics.areEqual((Object)referredMethodSymbol, (Object)enclosingMethodSymbol)) {
                        psiElement.element = true;
                        boolean bl2 = true;
                        return bl2;
                    }
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    this_$iv$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv$iv, (KtElement)ktThisExpression2);
                }
                return this.$isReceiverReferenced.element;
            }
        });
        if (!isReceiverReferenced.element) {
            context.report(ModifierDeclarationDetector.Companion.getModifierFactoryUnreferencedReceiver(), $this$ensureReceiverIsReferenced, context.getNameLocation($this$ensureReceiverIsReferenced), "Modifier factory functions must use the receiver Modifier instance");
        }
    }

    private static final void checkReturnType(UMethod $this$checkReturnType, JavaContext context, PsiType returnType) {
        if (Intrinsics.areEqual((Object)returnType.getCanonicalText(), (Object)Names.Ui.INSTANCE.getModifier().getJavaFqn())) {
            return;
        }
        PsiElement source = $this$checkReturnType.getSourcePsi();
        if (source instanceof KtCallableDeclaration && ModifierDeclarationDetectorKt.getReturnTypeString((KtCallableDeclaration)source) != null) {
            ModifierDeclarationDetectorKt.checkReturnType$report$0(context, $this$checkReturnType, LintFix.Companion.create().replace().name("Change return type to Modifier").range(context.getLocation($this$checkReturnType)).text(ModifierDeclarationDetectorKt.getReturnTypeString((KtCallableDeclaration)source)).with(Names.Ui.INSTANCE.getModifier().getShortName()).autoFix().build());
            return;
        }
        if (source instanceof KtPropertyAccessor) {
            String getterReturnType;
            KtTypeReference ktTypeReference = ((KtPropertyAccessor)source).getReturnTypeReference();
            String string = getterReturnType = ktTypeReference != null ? ktTypeReference.getText() : null;
            if (getterReturnType != null) {
                ModifierDeclarationDetectorKt.checkReturnType$report$0(context, $this$checkReturnType, LintFix.Companion.create().replace().name("Change return type to Modifier").range(context.getLocation($this$checkReturnType)).text(getterReturnType).with(Names.Ui.INSTANCE.getModifier().getShortName()).autoFix().build());
                return;
            }
            KtProperty ktProperty = ((KtPropertyAccessor)source).getProperty();
            Intrinsics.checkNotNullExpressionValue((Object)ktProperty, (String)"getProperty(...)");
            String propertyType = ModifierDeclarationDetectorKt.getReturnTypeString((KtCallableDeclaration)ktProperty);
            if (propertyType != null) {
                LintFix.ReplaceStringBuilder replaceStringBuilder = LintFix.Companion.create().replace().name("Change return type to Modifier");
                KtProperty ktProperty2 = ((KtPropertyAccessor)source).getProperty();
                Intrinsics.checkNotNullExpressionValue((Object)ktProperty2, (String)"getProperty(...)");
                ModifierDeclarationDetectorKt.checkReturnType$report$0(context, $this$checkReturnType, replaceStringBuilder.range(context.getLocation((PsiElement)ktProperty2)).text(propertyType).with(Names.Ui.INSTANCE.getModifier().getShortName()).autoFix().build());
                return;
            }
        }
        if (source instanceof KtDeclarationWithBody) {
            ModifierDeclarationDetectorKt.checkReturnType$report$0(context, $this$checkReturnType, LintFix.Companion.create().replace().name("Add explicit Modifier return type").range(context.getLocation($this$checkReturnType)).pattern("[ \\t\\n]+=").with(": " + Names.Ui.INSTANCE.getModifier().getShortName() + " =").autoFix().build());
            return;
        }
    }

    private static final String getReturnTypeString(KtCallableDeclaration $this$returnTypeString) {
        KtTypeReference ktTypeReference = $this$returnTypeString.getTypeReference();
        return ktTypeReference != null ? ktTypeReference.getText() : null;
    }

    private static final void checkReceiver$report(JavaContext $context, UMethod $this_checkReceiver, LintFix lintFix) {
        $context.report(ModifierDeclarationDetector.Companion.getModifierFactoryExtensionFunction(), $this_checkReceiver, $context.getNameLocation($this_checkReceiver), "Modifier factory functions should be extensions on Modifier", lintFix);
    }

    static /* synthetic */ void checkReceiver$report$default(JavaContext javaContext, UMethod uMethod, LintFix lintFix, int n, Object object) {
        if ((n & 4) != 0) {
            lintFix = null;
        }
        ModifierDeclarationDetectorKt.checkReceiver$report(javaContext, uMethod, lintFix);
    }

    private static final void checkReturnType$report$0(JavaContext $context, UMethod $this_checkReturnType, LintFix lintFix) {
        $context.report(ModifierDeclarationDetector.Companion.getModifierFactoryReturnType(), $this_checkReturnType, $context.getNameLocation($this_checkReturnType), "Modifier factory functions should have a return type of Modifier", lintFix);
    }

    static /* synthetic */ void checkReturnType$report$0$default(JavaContext javaContext, UMethod uMethod, LintFix lintFix, int n, Object object) {
        if ((n & 4) != 0) {
            lintFix = null;
        }
        ModifierDeclarationDetectorKt.checkReturnType$report$0(javaContext, uMethod, lintFix);
    }

    public static final /* synthetic */ void access$checkReturnType(UMethod $receiver, JavaContext context, PsiType returnType) {
        ModifierDeclarationDetectorKt.checkReturnType($receiver, context, returnType);
    }

    public static final /* synthetic */ void access$checkReceiver(UMethod $receiver, JavaContext context) {
        ModifierDeclarationDetectorKt.checkReceiver($receiver, context);
    }
}

