/*
 * Decompiled with CFR 0.152.
 */
package androidx.paging;

import androidx.annotation.RestrictTo;
import androidx.paging.CompatLegacyPagingSource;
import androidx.paging.DataSource;
import androidx.paging.LoadType;
import androidx.paging.PagingSource;
import androidx.paging.PagingState;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.FunctionReferenceImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0007\u0018\u0000  *\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u00042\u00020\u0005:\u0001 B#\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0017J\u0016\u0010\u0012\u001a\u00020\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0014H\u0002J(\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00162\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0014H\u0096@\u00a2\u0006\u0002\u0010\u0017J#\u0010\u0018\u001a\u0004\u0018\u00018\u00002\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u001aH\u0016\u00a2\u0006\u0002\u0010\u001bR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\u00020\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006!"}, d2={"Landroidx/paging/LegacyPagingSource;", "Key", "", "Value", "Landroidx/paging/PagingSource;", "Landroidx/paging/CompatLegacyPagingSource;", "fetchContext", "Lkotlin/coroutines/CoroutineContext;", "dataSource", "Landroidx/paging/DataSource;", "<init>", "(Lkotlin/coroutines/CoroutineContext;Landroidx/paging/DataSource;)V", "getDataSource$paging_common", "()Landroidx/paging/DataSource;", "pageSize", "", "setPageSize", "", "guessPageSize", "params", "Landroidx/paging/PagingSource$LoadParams;", "load", "Landroidx/paging/PagingSource$LoadResult;", "(Landroidx/paging/PagingSource$LoadParams;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getRefreshKey", "state", "Landroidx/paging/PagingState;", "(Landroidx/paging/PagingState;)Ljava/lang/Object;", "jumpingSupported", "", "getJumpingSupported", "()Z", "Companion", "paging-common"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@SourceDebugExtension(value={"SMAP\nLegacyPagingSource.jvm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LegacyPagingSource.jvm.kt\nandroidx/paging/LegacyPagingSource\n+ 2 PagingState.kt\nandroidx/paging/PagingState\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,142:1\n257#2,8:143\n1#3:151\n*S KotlinDebug\n*F\n+ 1 LegacyPagingSource.jvm.kt\nandroidx/paging/LegacyPagingSource\n*L\n122#1:143,8\n*E\n"})
public final class LegacyPagingSource<Key, Value>
extends PagingSource<Key, Value>
implements CompatLegacyPagingSource {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineContext fetchContext;
    @NotNull
    private final DataSource<Key, Value> dataSource;
    private int pageSize;
    private static final int PAGE_SIZE_NOT_SET = Integer.MIN_VALUE;

    public LegacyPagingSource(@NotNull CoroutineContext fetchContext, @NotNull DataSource<Key, Value> dataSource) {
        Intrinsics.checkNotNullParameter((Object)fetchContext, (String)"fetchContext");
        Intrinsics.checkNotNullParameter(dataSource, (String)"dataSource");
        this.fetchContext = fetchContext;
        this.dataSource = dataSource;
        this.pageSize = Integer.MIN_VALUE;
        this.dataSource.addInvalidatedCallback(new DataSource.InvalidatedCallback(){

            @Override
            public final void onInvalidated() {
                this.invalidate();
            }

            public final Function<?> getFunctionDelegate() {
                return (Function)new FunctionReferenceImpl(0, this, LegacyPagingSource.class, "invalidate", "invalidate()V", 0);
            }

            public final boolean equals(Object other) {
                return other instanceof DataSource.InvalidatedCallback ? (other instanceof FunctionAdapter ? Intrinsics.areEqual((Object)((FunctionAdapter)this).getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return ((FunctionAdapter)this).getFunctionDelegate().hashCode();
            }
        });
        this.registerInvalidatedCallback((Function0<Unit>)((Function0)() -> LegacyPagingSource._init_$lambda$0(this)));
    }

    @NotNull
    public final DataSource<Key, Value> getDataSource$paging_common() {
        return this.dataSource;
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setPageSize(int pageSize) {
        if (!(this.pageSize == Integer.MIN_VALUE || pageSize == this.pageSize)) {
            boolean bl = false;
            String string = "Page size is already set to " + this.pageSize + ".";
            throw new IllegalStateException(string.toString());
        }
        this.pageSize = pageSize;
    }

    private final int guessPageSize(PagingSource.LoadParams<Key> params) {
        if (params instanceof PagingSource.LoadParams.Refresh && ((PagingSource.LoadParams.Refresh)params).getLoadSize() % 3 == 0) {
            return ((PagingSource.LoadParams.Refresh)params).getLoadSize() / 3;
        }
        return params.getLoadSize();
    }

    @Override
    @Nullable
    public Object load(@NotNull PagingSource.LoadParams<Key> params, @NotNull Continuation<? super PagingSource.LoadResult<Key, Value>> $completion) {
        LoadType loadType;
        PagingSource.LoadParams<Key> loadParams = params;
        if (loadParams instanceof PagingSource.LoadParams.Refresh) {
            loadType = LoadType.REFRESH;
        } else if (loadParams instanceof PagingSource.LoadParams.Append) {
            loadType = LoadType.APPEND;
        } else if (loadParams instanceof PagingSource.LoadParams.Prepend) {
            loadType = LoadType.PREPEND;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        LoadType type = loadType;
        if (this.pageSize == Integer.MIN_VALUE) {
            loadParams = "WARNING: pageSize on the LegacyPagingSource is not set.\nWhen using legacy DataSource / DataSourceFactory with Paging3, page size\nshould've been set by the paging library but it is not set yet.\n\nIf you are seeing this message in tests where you are testing DataSource\nin isolation (without a Pager), it is expected and page size will be estimated\nbased on parameters.\n\nIf you are seeing this message despite using a Pager, please file a bug:\nhttps://issuetracker.google.com/issues/new?component=413106";
            System.out.println(loadParams);
            this.pageSize = this.guessPageSize(params);
        }
        DataSource.Params<Key> dataSourceParams = new DataSource.Params<Key>(type, params.getKey(), params.getLoadSize(), params.getPlaceholdersEnabled(), this.pageSize);
        return BuildersKt.withContext((CoroutineContext)this.fetchContext, (Function2)new Function2<CoroutineScope, Continuation<? super PagingSource.LoadResult.Page<Key, Value>>, Object>(this, dataSourceParams, params, null){
            int label;
            final /* synthetic */ LegacyPagingSource<Key, Value> this$0;
            final /* synthetic */ DataSource.Params<Key> $dataSourceParams;
            final /* synthetic */ PagingSource.LoadParams<Key> $params;
            {
                this.this$0 = $receiver;
                this.$dataSourceParams = $dataSourceParams;
                this.$params = $params;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = this.this$0.getDataSource$paging_common().load$paging_common(this.$dataSourceParams, (Continuation)this);
                        if (v0 == var6_2) {
                            return var6_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        var2_3 = v0;
                        var3_4 = this.$params;
                        $this$invokeSuspend_u24lambda_u240 = (DataSource.BaseResult)var2_3;
                        $i$a$-run-LegacyPagingSource$load$2$1 = false;
                        return new PagingSource.LoadResult.Page<Object, Value>($this$invokeSuspend_u24lambda_u240.data, $this$invokeSuspend_u24lambda_u240.data.isEmpty() != false && var3_4 instanceof PagingSource.LoadParams.Prepend != false ? null : $this$invokeSuspend_u24lambda_u240.getPrevKey(), $this$invokeSuspend_u24lambda_u240.data.isEmpty() != false && var3_4 instanceof PagingSource.LoadParams.Append != false ? null : $this$invokeSuspend_u24lambda_u240.getNextKey(), $this$invokeSuspend_u24lambda_u240.getItemsBefore(), $this$invokeSuspend_u24lambda_u240.getItemsAfter());
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super PagingSource.LoadResult.Page<Key, Value>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Key getRefreshKey(@NotNull PagingState<Key, Value> state) {
        Object object;
        Intrinsics.checkNotNullParameter(state, (String)"state");
        switch (WhenMappings.$EnumSwitchMapping$0[this.dataSource.getType$paging_common().ordinal()]) {
            case 1: {
                Integer n = state.getAnchorPosition();
                if (n != null) {
                    int index$iv;
                    void this_$iv;
                    int anchorPosition = ((Number)n).intValue();
                    boolean bl = false;
                    PagingState<Key, Value> pagingState = state;
                    int anchorPosition$iv = anchorPosition;
                    boolean $i$f$anchorPositionToPagedIndices$paging_common = false;
                    int pageIndex$iv = 0;
                    for (index$iv = anchorPosition$iv - PagingState.access$getLeadingPlaceholderCount$p((PagingState)this_$iv); pageIndex$iv < CollectionsKt.getLastIndex(this_$iv.getPages()) && index$iv > CollectionsKt.getLastIndex(this_$iv.getPages().get(pageIndex$iv).getData()); index$iv -= this_$iv.getPages().get(pageIndex$iv).getData().size(), ++pageIndex$iv) {
                    }
                    int indexInPage = index$iv;
                    boolean bl2 = false;
                    PagingSource.LoadResult.Page<Key, Value> page = state.closestPageToPosition(anchorPosition);
                    if (page == null || (page = page.getPrevKey()) == null) {
                        page = 0;
                    }
                    PagingSource.LoadResult.Page<Key, Value> offset = page;
                    Intrinsics.checkNotNull((Object)offset, (String)"null cannot be cast to non-null type kotlin.Int");
                    object = (Integer)((Object)offset) + indexInPage;
                    break;
                }
                object = null;
                break;
            }
            case 2: {
                object = null;
                break;
            }
            case 3: {
                Integer n = state.getAnchorPosition();
                if (n != null) {
                    int anchorPosition = ((Number)n).intValue();
                    boolean bl = false;
                    Value Value = state.closestItemToPosition(anchorPosition);
                    if (Value != null) {
                        Value item = Value;
                        boolean bl3 = false;
                        object = this.dataSource.getKeyInternal$paging_common(item);
                        break;
                    }
                }
                object = null;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return (Key)object;
    }

    @Override
    public boolean getJumpingSupported() {
        return this.dataSource.getType$paging_common() == DataSource.KeyType.POSITIONAL;
    }

    private static final Unit _init_$lambda$0(LegacyPagingSource this$0) {
        this$0.dataSource.removeInvalidatedCallback(new DataSource.InvalidatedCallback(this$0){
            final /* synthetic */ LegacyPagingSource<Key, Value> $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final void onInvalidated() {
                this.$tmp0.invalidate();
            }

            public final Function<?> getFunctionDelegate() {
                return (Function)new FunctionReferenceImpl(0, this.$tmp0, LegacyPagingSource.class, "invalidate", "invalidate()V", 0);
            }

            public final boolean equals(Object other) {
                return other instanceof DataSource.InvalidatedCallback ? (other instanceof FunctionAdapter ? Intrinsics.areEqual((Object)((FunctionAdapter)this).getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return ((FunctionAdapter)this).getFunctionDelegate().hashCode();
            }
        });
        this$0.dataSource.invalidate();
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Landroidx/paging/LegacyPagingSource$Companion;", "", "<init>", "()V", "PAGE_SIZE_NOT_SET", "", "paging-common"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DataSource.KeyType.values().length];
            try {
                nArray[DataSource.KeyType.POSITIONAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataSource.KeyType.PAGE_KEYED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataSource.KeyType.ITEM_KEYED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

