/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.ExecutionContext;
import com.networknt.schema.JsonNodePath;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaRef;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import com.networknt.schema.annotation.JsonNodeAnnotation;
import com.networknt.schema.utils.JsonSchemaRefs;
import com.networknt.schema.utils.SetView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrefixItemsValidator
extends BaseJsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(PrefixItemsValidator.class);
    private final List<JsonSchema> tupleSchema;
    private Boolean hasUnevaluatedItemsValidator = null;

    public PrefixItemsValidator(SchemaLocation schemaLocation, JsonNodePath evaluationPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaLocation, evaluationPath, schemaNode, parentSchema, ValidatorTypeCode.PREFIX_ITEMS, validationContext);
        if (schemaNode instanceof ArrayNode && !schemaNode.isEmpty()) {
            int i2 = 0;
            this.tupleSchema = new ArrayList<JsonSchema>(schemaNode.size());
            for (JsonNode s2 : schemaNode) {
                this.tupleSchema.add(validationContext.newSchema(schemaLocation.append(i2), evaluationPath.append(i2), s2, parentSchema));
                ++i2;
            }
        } else {
            throw new IllegalArgumentException("The value of 'prefixItems' MUST be a non-empty array of valid JSON Schemas.");
        }
    }

    @Override
    public Set<ValidationMessage> validate(ExecutionContext executionContext, JsonNode node2, JsonNode rootNode, JsonNodePath instanceLocation) {
        PrefixItemsValidator.debug(logger, executionContext, node2, rootNode, instanceLocation);
        if (node2.isArray()) {
            SetView<ValidationMessage> errors = null;
            int count2 = Math.min(node2.size(), this.tupleSchema.size());
            for (int i2 = 0; i2 < count2; ++i2) {
                JsonNodePath path = instanceLocation.append(i2);
                Set<ValidationMessage> results = this.tupleSchema.get(i2).validate(executionContext, node2.get(i2), rootNode, path);
                if (results.isEmpty()) continue;
                if (errors == null) {
                    errors = new SetView<ValidationMessage>();
                }
                errors.union(results);
            }
            if (this.collectAnnotations() || this.collectAnnotations(executionContext)) {
                int schemas;
                int items2 = node2.isArray() ? node2.size() : 1;
                if (items2 > (schemas = this.tupleSchema.size())) {
                    executionContext.getAnnotations().put(JsonNodeAnnotation.builder().instanceLocation(instanceLocation).evaluationPath(this.evaluationPath).schemaLocation(this.schemaLocation).keyword(this.getKeyword()).value(schemas).build());
                } else {
                    executionContext.getAnnotations().put(JsonNodeAnnotation.builder().instanceLocation(instanceLocation).evaluationPath(this.evaluationPath).schemaLocation(this.schemaLocation).keyword(this.getKeyword()).value(true).build());
                }
            }
            return errors == null || errors.isEmpty() ? Collections.emptySet() : errors;
        }
        return Collections.emptySet();
    }

    @Override
    public Set<ValidationMessage> walk(ExecutionContext executionContext, JsonNode node2, JsonNode rootNode, JsonNodePath instanceLocation, boolean shouldValidateSchema) {
        LinkedHashSet<ValidationMessage> validationMessages = new LinkedHashSet<ValidationMessage>();
        if (node2 instanceof ArrayNode) {
            ArrayNode array2 = (ArrayNode)node2;
            int count2 = this.tupleSchema.size();
            for (int i2 = 0; i2 < count2; ++i2) {
                JsonNode n = node2.get(i2);
                if (this.validationContext.getConfig().getApplyDefaultsStrategy().shouldApplyArrayDefaults()) {
                    JsonNode defaultNode = PrefixItemsValidator.getDefaultNode(this.tupleSchema.get(i2));
                    if (n != null && n.isNull() && defaultNode != null) {
                        array2.set(i2, defaultNode);
                        n = defaultNode;
                    }
                }
                this.doWalk(executionContext, validationMessages, i2, n, rootNode, instanceLocation, shouldValidateSchema);
            }
            if (this.collectAnnotations() || this.collectAnnotations(executionContext)) {
                int schemas;
                int items2 = node2.isArray() ? node2.size() : 1;
                if (items2 > (schemas = this.tupleSchema.size())) {
                    executionContext.getAnnotations().put(JsonNodeAnnotation.builder().instanceLocation(instanceLocation).evaluationPath(this.evaluationPath).schemaLocation(this.schemaLocation).keyword(this.getKeyword()).value(schemas).build());
                } else {
                    executionContext.getAnnotations().put(JsonNodeAnnotation.builder().instanceLocation(instanceLocation).evaluationPath(this.evaluationPath).schemaLocation(this.schemaLocation).keyword(this.getKeyword()).value(true).build());
                }
            }
        } else {
            int count3 = this.tupleSchema.size();
            for (int i3 = 0; i3 < count3; ++i3) {
                this.doWalk(executionContext, validationMessages, i3, null, rootNode, instanceLocation, shouldValidateSchema);
            }
        }
        return validationMessages;
    }

    private static JsonNode getDefaultNode(JsonSchema schema) {
        JsonSchemaRef schemaRef;
        JsonNode result2 = schema.getSchemaNode().get("default");
        if (result2 == null && (schemaRef = JsonSchemaRefs.from(schema)) != null) {
            result2 = PrefixItemsValidator.getDefaultNode(schemaRef.getSchema());
        }
        return result2;
    }

    private void doWalk(ExecutionContext executionContext, Set<ValidationMessage> validationMessages, int i2, JsonNode node2, JsonNode rootNode, JsonNodePath instanceLocation, boolean shouldValidateSchema) {
        this.walkSchema(executionContext, this.tupleSchema.get(i2), node2, rootNode, instanceLocation.append(i2), shouldValidateSchema, validationMessages);
    }

    private void walkSchema(ExecutionContext executionContext, JsonSchema walkSchema, JsonNode node2, JsonNode rootNode, JsonNodePath instanceLocation, boolean shouldValidateSchema, Set<ValidationMessage> validationMessages) {
        boolean executeWalk = this.validationContext.getConfig().getItemWalkListenerRunner().runPreWalkListeners(executionContext, ValidatorTypeCode.PREFIX_ITEMS.getValue(), node2, rootNode, instanceLocation, walkSchema, this);
        if (executeWalk) {
            validationMessages.addAll(walkSchema.walk(executionContext, node2, rootNode, instanceLocation, shouldValidateSchema));
        }
        this.validationContext.getConfig().getItemWalkListenerRunner().runPostWalkListeners(executionContext, ValidatorTypeCode.PREFIX_ITEMS.getValue(), node2, rootNode, instanceLocation, walkSchema, this, validationMessages);
    }

    public List<JsonSchema> getTupleSchema() {
        return this.tupleSchema;
    }

    private boolean collectAnnotations() {
        return this.hasUnevaluatedItemsValidator();
    }

    private boolean hasUnevaluatedItemsValidator() {
        if (this.hasUnevaluatedItemsValidator == null) {
            this.hasUnevaluatedItemsValidator = this.hasAdjacentKeywordInEvaluationPath("unevaluatedItems");
        }
        return this.hasUnevaluatedItemsValidator;
    }

    @Override
    public void preloadJsonSchema() {
        this.preloadJsonSchemas(this.tupleSchema);
        this.collectAnnotations();
    }
}

