/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.asn1;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.kerby.asn1.Asn1;
import org.apache.kerby.asn1.Asn1Dumpable;
import org.apache.kerby.asn1.parse.Asn1Item;
import org.apache.kerby.asn1.parse.Asn1ParseResult;
import org.apache.kerby.asn1.parse.Asn1Parser;
import org.apache.kerby.asn1.type.Asn1Simple;
import org.apache.kerby.asn1.type.Asn1Specific;
import org.apache.kerby.asn1.type.Asn1Type;

public final class Asn1Dumper {
    private StringBuilder builder = new StringBuilder();

    public String output() {
        return this.builder.toString();
    }

    public void parseAndDump(byte[] content2) throws IOException {
        this.parseAndDump(ByteBuffer.wrap(content2));
    }

    public void decodeAndDump(byte[] content2) throws IOException {
        this.decodeAndDump(ByteBuffer.wrap(content2));
    }

    public void decodeAndDump(ByteBuffer content2) throws IOException {
        Asn1Type value = Asn1.decode(content2);
        this.dumpType(0, value);
    }

    public void parseAndDump(ByteBuffer content2) throws IOException {
        Asn1ParseResult parseResult = Asn1Parser.parse(content2);
        this.dumpParseResult(0, parseResult);
    }

    public void dumpType(Asn1Type value) {
        this.dumpType(0, value);
    }

    public Asn1Dumper dumpType(int indents, Asn1Type value) {
        if (value == null) {
            this.indent(indents).append("Null");
        } else if (value instanceof Asn1Simple) {
            this.indent(indents).append(value.toString());
        } else if (value instanceof Asn1Dumpable) {
            Asn1Dumpable dumpable = (Asn1Dumpable)((Object)value);
            dumpable.dumpWith(this, indents);
        } else if (value instanceof Asn1Specific) {
            this.indent(indents).append(value.toString());
        } else {
            this.indent(indents).append("<Unknown>");
        }
        return this;
    }

    public Asn1Dumper dumpParseResult(int indents, Asn1ParseResult value) {
        if (value == null) {
            this.indent(indents).append("Null");
        } else if (value instanceof Asn1Item) {
            this.indent(indents).append(value.toString());
        } else if (value instanceof Asn1Dumpable) {
            Asn1Dumpable dumpable = (Asn1Dumpable)((Object)value);
            dumpable.dumpWith(this, indents);
        } else {
            this.indent(indents).append("<Unknown>");
        }
        return this;
    }

    public Asn1Dumper indent(int numSpaces) {
        for (int i2 = 0; i2 < numSpaces; ++i2) {
            this.builder.append(' ');
        }
        return this;
    }

    public Asn1Dumper append(Asn1Simple<?> simpleValue) {
        if (simpleValue != null) {
            this.builder.append(simpleValue.toString());
        } else {
            this.builder.append("null");
        }
        return this;
    }

    public Asn1Dumper append(String string2) {
        this.builder.append(string2);
        return this;
    }

    public Asn1Dumper appendType(Class<?> cls) {
        this.builder.append("<").append(cls.getSimpleName()).append("> ");
        return this;
    }

    public Asn1Dumper newLine() {
        this.builder.append("\n");
        return this;
    }

    public Asn1Dumper dumpData(String hexData) {
        int pos;
        int range;
        for (pos = range = 100; pos < hexData.length(); pos += range) {
            System.out.println(hexData.substring(pos - range, pos));
        }
        System.out.println(hexData.substring(pos - range, hexData.length()));
        return this;
    }
}

