/*
 * Decompiled with CFR 0.152.
 */
package androidx.collection;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.collection.IndexBasedArrayIterator;
import androidx.collection.SimpleArrayMap;
import androidx.collection.internal.ContainerHelpersKt;
import java.lang.reflect.Array;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class ArrayMap<K, V>
extends SimpleArrayMap<K, V>
implements Map<K, V> {
    @Nullable
    EntrySet mEntrySet;
    @Nullable
    KeySet mKeySet;
    @Nullable
    ValueCollection mValues;

    public ArrayMap() {
    }

    public ArrayMap(int capacity) {
        super(capacity);
    }

    public ArrayMap(@Nullable SimpleArrayMap map2) {
        super(map2);
    }

    public boolean containsAll(@NonNull Collection<?> collection) {
        for (Object o : collection) {
            if (this.containsKey(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsKey(@Nullable Object key) {
        return super.containsKey(key);
    }

    @Override
    public boolean containsValue(@Nullable Object value) {
        return super.containsValue(value);
    }

    @Override
    public V get(@Nullable Object key) {
        return super.get(key);
    }

    @Override
    public V remove(@Nullable Object key) {
        return super.remove(key);
    }

    @Override
    public void putAll(@NonNull Map<? extends K, ? extends V> map2) {
        this.ensureCapacity(this.size() + map2.size());
        for (Map.Entry<K, V> entry : map2.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public boolean removeAll(@NonNull Collection<?> collection) {
        int oldSize = this.size();
        for (Object o : collection) {
            this.remove(o);
        }
        return oldSize != this.size();
    }

    public boolean retainAll(@NonNull Collection<?> collection) {
        int oldSize = this.size();
        for (int i2 = this.size() - 1; i2 >= 0; --i2) {
            if (collection.contains(this.keyAt(i2))) continue;
            this.removeAt(i2);
        }
        return oldSize != this.size();
    }

    @Override
    @NonNull
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet entrySet = this.mEntrySet;
        if (entrySet == null) {
            entrySet = this.mEntrySet = new EntrySet();
        }
        return entrySet;
    }

    @Override
    @NonNull
    public Set<K> keySet() {
        KeySet keySet = this.mKeySet;
        if (keySet == null) {
            keySet = this.mKeySet = new KeySet();
        }
        return keySet;
    }

    @Override
    @NonNull
    public Collection<V> values() {
        ValueCollection values2 = this.mValues;
        if (values2 == null) {
            values2 = this.mValues = new ValueCollection();
        }
        return values2;
    }

    static <T> boolean equalsSetHelper(Set<T> set2, Object object) {
        if (set2 == object) {
            return true;
        }
        if (object instanceof Set) {
            Set s2 = (Set)object;
            try {
                return set2.size() == s2.size() && set2.containsAll(s2);
            }
            catch (ClassCastException | NullPointerException runtimeException) {
                // empty catch block
            }
        }
        return false;
    }

    final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        EntrySet() {
        }

        @Override
        @NonNull
        public Iterator<Map.Entry<K, V>> iterator() {
            return new MapIterator();
        }

        @Override
        public int size() {
            return ArrayMap.this.size();
        }
    }

    final class KeySet
    implements Set<K> {
        KeySet() {
        }

        @Override
        public boolean add(K object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(@NonNull Collection<? extends K> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            ArrayMap.this.clear();
        }

        @Override
        public boolean contains(Object object) {
            return ArrayMap.this.containsKey(object);
        }

        @Override
        public boolean containsAll(@NonNull Collection<?> collection) {
            return ArrayMap.this.containsAll(collection);
        }

        @Override
        public boolean isEmpty() {
            return ArrayMap.this.isEmpty();
        }

        @Override
        @NonNull
        public Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public boolean remove(Object object) {
            int index2 = ArrayMap.this.indexOfKey(object);
            if (index2 >= 0) {
                ArrayMap.this.removeAt(index2);
                return true;
            }
            return false;
        }

        @Override
        public boolean removeAll(@NonNull Collection<?> collection) {
            return ArrayMap.this.removeAll(collection);
        }

        @Override
        public boolean retainAll(@NonNull Collection<?> collection) {
            return ArrayMap.this.retainAll(collection);
        }

        @Override
        public int size() {
            return ArrayMap.this.size();
        }

        @Override
        @NonNull
        public Object[] toArray() {
            int N = ArrayMap.this.size();
            Object[] result2 = new Object[N];
            for (int i2 = 0; i2 < N; ++i2) {
                result2[i2] = ArrayMap.this.keyAt(i2);
            }
            return result2;
        }

        @Override
        @NonNull
        public <T> T[] toArray(@NonNull T[] array2) {
            int mySize = this.size();
            if (array2.length < mySize) {
                array2 = (Object[])Array.newInstance(array2.getClass().getComponentType(), mySize);
            }
            for (int i2 = 0; i2 < mySize; ++i2) {
                array2[i2] = ArrayMap.this.keyAt(i2);
            }
            if (array2.length > mySize) {
                array2[mySize] = null;
            }
            return array2;
        }

        @Override
        public boolean equals(Object object) {
            return ArrayMap.equalsSetHelper(this, object);
        }

        @Override
        public int hashCode() {
            int result2 = 0;
            for (int i2 = ArrayMap.this.size() - 1; i2 >= 0; --i2) {
                Object obj = ArrayMap.this.keyAt(i2);
                result2 += obj == null ? 0 : obj.hashCode();
            }
            return result2;
        }
    }

    final class ValueCollection
    implements Collection<V> {
        ValueCollection() {
        }

        @Override
        public boolean add(V object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(@NonNull Collection<? extends V> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            ArrayMap.this.clear();
        }

        @Override
        public boolean contains(Object object) {
            return ArrayMap.this.__restricted$indexOfValue(object) >= 0;
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            for (Object o : collection) {
                if (this.contains(o)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isEmpty() {
            return ArrayMap.this.isEmpty();
        }

        @Override
        @NonNull
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public boolean remove(Object object) {
            int index2 = ArrayMap.this.__restricted$indexOfValue(object);
            if (index2 >= 0) {
                ArrayMap.this.removeAt(index2);
                return true;
            }
            return false;
        }

        @Override
        public boolean removeAll(@NonNull Collection<?> collection) {
            int N = ArrayMap.this.size();
            boolean changed = false;
            for (int i2 = 0; i2 < N; ++i2) {
                Object cur = ArrayMap.this.valueAt(i2);
                if (!collection.contains(cur)) continue;
                ArrayMap.this.removeAt(i2);
                --i2;
                --N;
                changed = true;
            }
            return changed;
        }

        @Override
        public boolean retainAll(@NonNull Collection<?> collection) {
            int N = ArrayMap.this.size();
            boolean changed = false;
            for (int i2 = 0; i2 < N; ++i2) {
                Object cur = ArrayMap.this.valueAt(i2);
                if (collection.contains(cur)) continue;
                ArrayMap.this.removeAt(i2);
                --i2;
                --N;
                changed = true;
            }
            return changed;
        }

        @Override
        public int size() {
            return ArrayMap.this.size();
        }

        @Override
        @NonNull
        public Object[] toArray() {
            int N = ArrayMap.this.size();
            Object[] result2 = new Object[N];
            for (int i2 = 0; i2 < N; ++i2) {
                result2[i2] = ArrayMap.this.valueAt(i2);
            }
            return result2;
        }

        @Override
        @NonNull
        public <T> T[] toArray(@NonNull T[] array2) {
            int mySize = this.size();
            if (array2.length < mySize) {
                array2 = (Object[])Array.newInstance(array2.getClass().getComponentType(), mySize);
            }
            for (int i2 = 0; i2 < mySize; ++i2) {
                array2[i2] = ArrayMap.this.valueAt(i2);
            }
            if (array2.length > mySize) {
                array2[mySize] = null;
            }
            return array2;
        }
    }

    final class MapIterator
    implements Iterator<Map.Entry<K, V>>,
    Map.Entry<K, V> {
        int mEnd;
        int mIndex;
        boolean mEntryValid;

        MapIterator() {
            this.mEnd = ArrayMap.this.size() - 1;
            this.mIndex = -1;
        }

        @Override
        public boolean hasNext() {
            return this.mIndex < this.mEnd;
        }

        @Override
        public Map.Entry<K, V> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.mIndex;
            this.mEntryValid = true;
            return this;
        }

        @Override
        public void remove() {
            if (!this.mEntryValid) {
                throw new IllegalStateException();
            }
            ArrayMap.this.removeAt(this.mIndex);
            --this.mIndex;
            --this.mEnd;
            this.mEntryValid = false;
        }

        @Override
        public K getKey() {
            if (!this.mEntryValid) {
                throw new IllegalStateException("This container does not support retaining Map.Entry objects");
            }
            return ArrayMap.this.keyAt(this.mIndex);
        }

        @Override
        public V getValue() {
            if (!this.mEntryValid) {
                throw new IllegalStateException("This container does not support retaining Map.Entry objects");
            }
            return ArrayMap.this.valueAt(this.mIndex);
        }

        @Override
        public V setValue(V object) {
            if (!this.mEntryValid) {
                throw new IllegalStateException("This container does not support retaining Map.Entry objects");
            }
            return ArrayMap.this.setValueAt(this.mIndex, object);
        }

        @Override
        public boolean equals(Object o) {
            if (!this.mEntryValid) {
                throw new IllegalStateException("This container does not support retaining Map.Entry objects");
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return ContainerHelpersKt.equal(e.getKey(), ArrayMap.this.keyAt(this.mIndex)) && ContainerHelpersKt.equal(e.getValue(), ArrayMap.this.valueAt(this.mIndex));
        }

        @Override
        public int hashCode() {
            if (!this.mEntryValid) {
                throw new IllegalStateException("This container does not support retaining Map.Entry objects");
            }
            Object key = ArrayMap.this.keyAt(this.mIndex);
            Object value = ArrayMap.this.valueAt(this.mIndex);
            return (key == null ? 0 : key.hashCode()) ^ (value == null ? 0 : value.hashCode());
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }

    final class ValueIterator
    extends IndexBasedArrayIterator<V> {
        ValueIterator() {
            super(ArrayMap.this.size());
        }

        @Override
        protected V elementAt(int index2) {
            return ArrayMap.this.valueAt(index2);
        }

        @Override
        protected void removeAt(int index2) {
            ArrayMap.this.removeAt(index2);
        }
    }

    final class KeyIterator
    extends IndexBasedArrayIterator<K> {
        KeyIterator() {
            super(ArrayMap.this.size());
        }

        @Override
        protected K elementAt(int index2) {
            return ArrayMap.this.keyAt(index2);
        }

        @Override
        protected void removeAt(int index2) {
            ArrayMap.this.removeAt(index2);
        }
    }
}

