/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.jws;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.webauthn4j.util.AssertUtil;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public enum JWAIdentifier {
    RS1("RS1", "SHA1withRSA"),
    RS256("RS256", "SHA256withRSA"),
    RS384("RS384", "SHA384withRSA"),
    RS512("RS512", "SHA512withRSA"),
    ES256("ES256", "SHA256withECDSA"),
    ES384("ES384", "SHA384withECDSA"),
    ES512("ES512", "SHA512withECDSA");

    private final String name;
    private final String jcaName;

    private JWAIdentifier(String name, String jcaName) {
        this.name = name;
        this.jcaName = jcaName;
    }

    @NotNull
    public static JWAIdentifier create(@NotNull String value) {
        AssertUtil.notNull(value, "value must not be null.");
        return Arrays.stream(JWAIdentifier.values()).filter(it -> it.name.equals(value)).findFirst().orElseThrow(() -> new IllegalArgumentException("Invalid JWA Identifier provided: " + value));
    }

    @JsonCreator
    @NotNull
    private static JWAIdentifier deserialize(@NotNull String value) throws InvalidFormatException {
        try {
            return JWAIdentifier.create(value);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidFormatException(null, "Invalid JWA Identifier provided", (Object)value, JWAIdentifier.class);
        }
    }

    @JsonValue
    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public String getJcaName() {
        return this.jcaName;
    }

    public String toString() {
        return this.name;
    }
}

