/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.unix;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;

public final class NativeInetAddress {
    private static final byte[] IPV4_MAPPED_IPV6_PREFIX = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1};
    final byte[] address;
    final int scopeId;

    public static NativeInetAddress newInstance(InetAddress addr) {
        byte[] bytes = addr.getAddress();
        if (addr instanceof Inet6Address) {
            return new NativeInetAddress(bytes, ((Inet6Address)addr).getScopeId());
        }
        return new NativeInetAddress(NativeInetAddress.ipv4MappedIpv6Address(bytes));
    }

    public NativeInetAddress(byte[] address2, int scopeId) {
        this.address = address2;
        this.scopeId = scopeId;
    }

    public NativeInetAddress(byte[] address2) {
        this(address2, 0);
    }

    public byte[] address() {
        return this.address;
    }

    public int scopeId() {
        return this.scopeId;
    }

    public static byte[] ipv4MappedIpv6Address(byte[] ipv4) {
        byte[] address2 = new byte[16];
        NativeInetAddress.copyIpv4MappedIpv6Address(ipv4, address2);
        return address2;
    }

    public static void copyIpv4MappedIpv6Address(byte[] ipv4, byte[] ipv6) {
        System.arraycopy(IPV4_MAPPED_IPV6_PREFIX, 0, ipv6, 0, IPV4_MAPPED_IPV6_PREFIX.length);
        System.arraycopy(ipv4, 0, ipv6, 12, ipv4.length);
    }

    public static InetSocketAddress address(byte[] addr, int offset, int len) {
        int port = NativeInetAddress.decodeInt(addr, offset + len - 4);
        try {
            InetAddress address2;
            switch (len) {
                case 8: {
                    byte[] ipv4 = new byte[4];
                    System.arraycopy(addr, offset, ipv4, 0, 4);
                    address2 = InetAddress.getByAddress(ipv4);
                    break;
                }
                case 24: {
                    byte[] ipv6 = new byte[16];
                    System.arraycopy(addr, offset, ipv6, 0, 16);
                    int scopeId = NativeInetAddress.decodeInt(addr, offset + len - 8);
                    if (scopeId != 0 || ipv6[0] == -2 && ipv6[1] == -128) {
                        address2 = Inet6Address.getByAddress(null, ipv6, scopeId);
                        break;
                    }
                    address2 = InetAddress.getByAddress(null, ipv6);
                    break;
                }
                default: {
                    throw new Error();
                }
            }
            return new InetSocketAddress(address2, port);
        }
        catch (UnknownHostException e) {
            throw new Error("Should never happen", e);
        }
    }

    static int decodeInt(byte[] addr, int index2) {
        return (addr[index2] & 0xFF) << 24 | (addr[index2 + 1] & 0xFF) << 16 | (addr[index2 + 2] & 0xFF) << 8 | addr[index2 + 3] & 0xFF;
    }
}

