/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.resources;

import androidx.compose.runtime.internal.StabilityInferred;
import java.io.Closeable;
import java.io.InputStream;
import java.net.URL;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.compose.resources.ExperimentalResourceApi;
import org.jetbrains.compose.resources.MissingResourceException;
import org.jetbrains.compose.resources.ResourceReader;

@ExperimentalResourceApi
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0096@\u00a2\u0006\u0002\u0010\nJ&\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0096@\u00a2\u0006\u0002\u0010\u000fJ\u0014\u0010\u0010\u001a\u00020\u0011*\u00020\u00122\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/compose/resources/JvmResourceReader;", "Lorg/jetbrains/compose/resources/ResourceReader;", "classLoader", "Ljava/lang/ClassLoader;", "<init>", "(Ljava/lang/ClassLoader;)V", "read", "", "path", "", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "readPart", "offset", "", "size", "(Ljava/lang/String;JJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "skipBytes", "", "Ljava/io/InputStream;", "getUri", "getResourceAsStream", "Companion", "library"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nResourceReader.desktop.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResourceReader.desktop.kt\norg/jetbrains/compose/resources/JvmResourceReader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,52:1\n1#2:53\n*E\n"})
public final class JvmResourceReader
implements ResourceReader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ClassLoader classLoader;
    public static final int $stable = 8;
    @NotNull
    private static final JvmResourceReader Default;

    public JvmResourceReader(@NotNull ClassLoader classLoader) {
        Intrinsics.checkNotNullParameter(classLoader, "classLoader");
        this.classLoader = classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Object read(@NotNull String path, @NotNull Continuation<? super byte[]> $completion) {
        byte[] byArray;
        InputStream resource2 = this.getResourceAsStream(path);
        Closeable closeable = resource2;
        Throwable throwable = null;
        try {
            InputStream input2 = (InputStream)closeable;
            boolean bl = false;
            byArray = ByteStreamsKt.readBytes(input2);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Object readPart(@NotNull String path, long offset, long size2, @NotNull Continuation<? super byte[]> $completion) {
        InputStream resource2 = this.getResourceAsStream(path);
        byte[] result2 = new byte[(int)size2];
        Closeable closeable = resource2;
        Throwable throwable = null;
        try {
            InputStream input2 = (InputStream)closeable;
            boolean bl = false;
            this.skipBytes(input2, offset);
            int n = input2.readNBytes(result2, 0, (int)size2);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        return result2;
    }

    private final void skipBytes(InputStream $this$skipBytes, long offset) {
        long count2;
        for (long skippedBytes = 0L; skippedBytes < offset && (count2 = $this$skipBytes.skip(offset - skippedBytes)) != 0L; skippedBytes += count2) {
        }
    }

    @Override
    @NotNull
    public String getUri(@NotNull String path) {
        Intrinsics.checkNotNullParameter(path, "path");
        URL uRL = this.classLoader.getResource(path);
        if (uRL == null) {
            throw new MissingResourceException(path);
        }
        URL resource2 = uRL;
        String string2 = resource2.toURI().toString();
        Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
        return string2;
    }

    private final InputStream getResourceAsStream(String path) {
        InputStream inputStream2 = this.classLoader.getResourceAsStream(path);
        if (inputStream2 == null) {
            throw new MissingResourceException(path);
        }
        return inputStream2;
    }

    static {
        ClassLoader classLoader = JvmResourceReader.class.getClassLoader();
        Intrinsics.checkNotNullExpressionValue(classLoader, "getClassLoader(...)");
        Default = new JvmResourceReader(classLoader);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/compose/resources/JvmResourceReader$Companion;", "", "<init>", "()V", "Default", "Lorg/jetbrains/compose/resources/JvmResourceReader;", "getDefault$library", "()Lorg/jetbrains/compose/resources/JvmResourceReader;", "library"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JvmResourceReader getDefault$library() {
            return Default;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

