/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.platform;

import androidx.compose.ui.awt.Utils_desktopKt;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.platform.DesktopTextInputService2Kt;
import androidx.compose.ui.platform.PlatformComponent;
import androidx.compose.ui.platform.PlatformTextInputMethodRequest;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.text.TextRangeKt;
import androidx.compose.ui.text.input.TextEditingScope;
import androidx.compose.ui.text.input.TextEditorState;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.InputMethodEvent;
import java.awt.font.TextHitInfo;
import java.awt.im.InputMethodRequests;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skiko.OS;
import org.jetbrains.skiko.OsArch_jvmKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020'H\u0016J\u001f\u0010)\u001a\u0004\u0018\u00010*2\u000e\u0010+\u001a\n\u0012\u0004\u0012\u00020-\u0018\u00010,H\u0016\u00a2\u0006\u0002\u0010.J\b\u0010/\u001a\u00020'H\u0016J\b\u00100\u001a\u00020'H\u0016J\u001d\u00101\u001a\u00020*2\u000e\u0010+\u001a\n\u0012\u0004\u0012\u00020-\u0018\u00010,H\u0016\u00a2\u0006\u0002\u0010.J\u0014\u00102\u001a\u0004\u0018\u0001032\b\u00104\u001a\u0004\u0018\u00010%H\u0016J-\u00105\u001a\u00020*2\u0006\u00106\u001a\u00020'2\u0006\u00107\u001a\u00020'2\u000e\u0010+\u001a\n\u0012\u0004\u0012\u00020-\u0018\u00010,H\u0016\u00a2\u0006\u0002\u00108J\u000e\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\u0004\u0018\u00010\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001e\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0014@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u001b\"\u0004\b \u0010\u001dR\u001a\u0010!\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u001b\"\u0004\b#\u0010\u001d\u00a8\u0006="}, d2={"Landroidx/compose/ui/platform/InputMethodSession;", "Ljava/awt/im/InputMethodRequests;", "component", "Landroidx/compose/ui/platform/PlatformComponent;", "request", "Landroidx/compose/ui/platform/PlatformTextInputMethodRequest;", "<init>", "(Landroidx/compose/ui/platform/PlatformComponent;Landroidx/compose/ui/platform/PlatformTextInputMethodRequest;)V", "state", "Landroidx/compose/ui/text/input/TextEditorState;", "getState", "()Landroidx/compose/ui/text/input/TextEditorState;", "selection", "Landroidx/compose/ui/text/TextRange;", "getSelection-d9O1mEE", "()J", "composition", "getComposition-MzsxiRA", "()Landroidx/compose/ui/text/TextRange;", "value", "", "imeComposingText", "getImeComposingText", "()Ljava/lang/String;", "ignoreNextInputMethodEvent", "", "getIgnoreNextInputMethodEvent", "()Z", "setIgnoreNextInputMethodEvent", "(Z)V", "charKeyPressed", "getCharKeyPressed", "setCharKeyPressed", "needToDeletePreviousChar", "getNeedToDeletePreviousChar", "setNeedToDeletePreviousChar", "getLocationOffset", "Ljava/awt/font/TextHitInfo;", "x", "", "y", "cancelLatestCommittedText", "Ljava/text/AttributedCharacterIterator;", "attributes", "", "Ljava/text/AttributedCharacterIterator$Attribute;", "([Ljava/text/AttributedCharacterIterator$Attribute;)Ljava/text/AttributedCharacterIterator;", "getInsertPositionOffset", "getCommittedTextLength", "getSelectedText", "getTextLocation", "Ljava/awt/Rectangle;", "offset", "getCommittedText", "beginIndex", "endIndex", "(II[Ljava/text/AttributedCharacterIterator$Attribute;)Ljava/text/AttributedCharacterIterator;", "inputMethodTextChanged", "", "event", "Ljava/awt/event/InputMethodEvent;", "ui"})
@SourceDebugExtension(value={"SMAP\nDesktopTextInputService2.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DesktopTextInputService2.kt\nandroidx/compose/ui/platform/InputMethodSession\n+ 2 Offset.kt\nandroidx/compose/ui/geometry/Offset\n+ 3 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n+ 4 InlineClassHelper.jvm.kt\nandroidx/compose/ui/util/InlineClassHelper_jvmKt\n*L\n1#1,331:1\n65#2:332\n60#3:333\n22#4:334\n*S KotlinDebug\n*F\n+ 1 DesktopTextInputService2.kt\nandroidx/compose/ui/platform/InputMethodSession\n*L\n203#1:332\n203#1:333\n203#1:334\n*E\n"})
final class InputMethodSession
implements InputMethodRequests {
    @NotNull
    private final PlatformComponent component;
    @NotNull
    private final PlatformTextInputMethodRequest request;
    @NotNull
    private String imeComposingText;
    private boolean ignoreNextInputMethodEvent;
    private boolean charKeyPressed;
    private boolean needToDeletePreviousChar;

    public InputMethodSession(@NotNull PlatformComponent component, @NotNull PlatformTextInputMethodRequest request) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this.component = component;
        this.request = request;
        this.imeComposingText = "";
    }

    private final TextEditorState getState() {
        return this.request.getState();
    }

    private final long getSelection-d9O1mEE() {
        return this.getState().getSelection-d9O1mEE();
    }

    private final TextRange getComposition-MzsxiRA() {
        return this.getState().getComposition-MzsxiRA();
    }

    @NotNull
    public final String getImeComposingText() {
        return this.imeComposingText;
    }

    public final boolean getIgnoreNextInputMethodEvent() {
        return this.ignoreNextInputMethodEvent;
    }

    public final void setIgnoreNextInputMethodEvent(boolean bl) {
        this.ignoreNextInputMethodEvent = bl;
    }

    public final boolean getCharKeyPressed() {
        return this.charKeyPressed;
    }

    public final void setCharKeyPressed(boolean bl) {
        this.charKeyPressed = bl;
    }

    public final boolean getNeedToDeletePreviousChar() {
        return this.needToDeletePreviousChar;
    }

    public final void setNeedToDeletePreviousChar(boolean bl) {
        this.needToDeletePreviousChar = bl;
    }

    @Override
    @Nullable
    public TextHitInfo getLocationOffset(int x, int y) {
        if (this.getComposition-MzsxiRA() != null) {
            return TextHitInfo.leading(0);
        }
        return null;
    }

    @Override
    @Nullable
    public AttributedCharacterIterator cancelLatestCommittedText(@Nullable AttributedCharacterIterator.Attribute[] attributes) {
        return null;
    }

    @Override
    public int getInsertPositionOffset() {
        TextRange textRange = this.getComposition-MzsxiRA();
        int composedStartIndex = textRange != null ? TextRange.getStart-impl((long)textRange.unbox-impl()) : 0;
        TextRange textRange2 = this.getComposition-MzsxiRA();
        int composedEndIndex = textRange2 != null ? TextRange.getEnd-impl((long)textRange2.unbox-impl()) : 0;
        int caretIndex = TextRange.getStart-impl((long)this.getSelection-d9O1mEE());
        if (caretIndex < composedStartIndex) {
            return caretIndex;
        }
        if (caretIndex < composedEndIndex) {
            return composedStartIndex;
        }
        return caretIndex - (composedEndIndex - composedStartIndex);
    }

    @Override
    public int getCommittedTextLength() {
        TextRange textRange = this.getComposition-MzsxiRA();
        return this.getState().length() - (textRange != null ? TextRange.getLength-impl((long)textRange.unbox-impl()) : 0);
    }

    @Override
    @NotNull
    public AttributedCharacterIterator getSelectedText(@Nullable AttributedCharacterIterator.Attribute[] attributes) {
        if (this.charKeyPressed && OsArch_jvmKt.getHostOs() == OS.MacOS) {
            this.needToDeletePreviousChar = true;
        }
        String str = TextRangeKt.substring-FDrldGo((CharSequence)((CharSequence)this.getState()), (long)this.getSelection-d9O1mEE());
        AttributedCharacterIterator attributedCharacterIterator = new AttributedString(str).getIterator();
        Intrinsics.checkNotNullExpressionValue((Object)attributedCharacterIterator, (String)"getIterator(...)");
        return attributedCharacterIterator;
    }

    @Override
    @Nullable
    public Rectangle getTextLocation(@Nullable TextHitInfo offset) {
        Object object;
        block3: {
            block2: {
                object = (Rect)this.request.getFocusedRectInRoot().invoke();
                if (object == null) break block2;
                Rect it = object;
                boolean bl = false;
                long arg0$iv = it.getTopCenter-F1C5BW0();
                boolean bl2 = false;
                long value$iv$iv = arg0$iv;
                boolean $i$f$unpackFloat1 = false;
                int bits$iv$iv$iv = (int)(value$iv$iv >> 32);
                boolean $i$f$floatFromBits = false;
                float centerX = Float.intBitsToFloat(bits$iv$iv$iv);
                Rectangle rectangle = Utils_desktopKt.toAwtRectangleRounded(Rect.copy$default((Rect)it, (float)centerX, (float)0.0f, (float)centerX, (float)0.0f, (int)10, null), this.component.getDensity());
                object = rectangle;
                if (rectangle != null) break block3;
            }
            return null;
        }
        Object awtRect = object;
        Point locationOnScreen = this.component.getLocationOnScreen();
        ((Rectangle)awtRect).translate(locationOnScreen.x, locationOnScreen.y);
        return awtRect;
    }

    @Override
    @NotNull
    public AttributedCharacterIterator getCommittedText(int beginIndex, int endIndex, @Nullable AttributedCharacterIterator.Attribute[] attributes) {
        TextRange comp = this.getComposition-MzsxiRA();
        long range = TextRangeKt.TextRange((int)RangesKt.coerceAtMost((int)beginIndex, (int)this.getState().length()), (int)RangesKt.coerceAtMost((int)endIndex, (int)this.getState().length()));
        if (comp == null) {
            String res = TextRangeKt.substring-FDrldGo((CharSequence)((CharSequence)this.getState()), (long)range);
            AttributedCharacterIterator attributedCharacterIterator = new AttributedString(res).getIterator();
            Intrinsics.checkNotNullExpressionValue((Object)attributedCharacterIterator, (String)"getIterator(...)");
            return attributedCharacterIterator;
        }
        String committed = TextRangeKt.substring-FDrldGo((CharSequence)((CharSequence)this.getState()), (long)TextRangeKt.TextRange((int)RangesKt.coerceAtMost((int)Math.min(TextRange.getMin-impl((long)range), TextRange.getMin-impl((long)comp.unbox-impl())), (int)this.getState().length()), (int)RangesKt.coerceAtMost((int)Math.max(TextRange.getMax-impl((long)range), TextRange.getMax-impl((long)comp.unbox-impl())), (int)this.getState().length())));
        AttributedCharacterIterator attributedCharacterIterator = new AttributedString(committed).getIterator();
        Intrinsics.checkNotNullExpressionValue((Object)attributedCharacterIterator, (String)"getIterator(...)");
        return attributedCharacterIterator;
    }

    public final void inputMethodTextChanged(@NotNull InputMethodEvent event) {
        String composing;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        String committed = DesktopTextInputService2Kt.getCommittedText(event);
        this.imeComposingText = composing = DesktopTextInputService2Kt.getComposingText(event);
        if (this.ignoreNextInputMethodEvent) {
            this.ignoreNextInputMethodEvent = false;
            return;
        }
        this.request.getEditText().invoke(arg_0 -> InputMethodSession.inputMethodTextChanged$lambda$1(this, composing, committed, arg_0));
    }

    private static final Unit inputMethodTextChanged$lambda$1(InputMethodSession this$0, String $composing, String $committed, TextEditingScope $this$editText) {
        Intrinsics.checkNotNullParameter((Object)$this$editText, (String)"$this$editText");
        if (this$0.needToDeletePreviousChar && TextRange.getMin-impl((long)this$0.getSelection-d9O1mEE()) > 0 && ((CharSequence)$composing).length() == 0) {
            this$0.needToDeletePreviousChar = false;
            $this$editText.deleteSurroundingTextInCodePoints(1, 0);
        }
        $this$editText.commitText((CharSequence)$committed, 1);
        if (((CharSequence)$composing).length() > 0) {
            $this$editText.setComposingText((CharSequence)$composing, 1);
        }
        return Unit.INSTANCE;
    }
}

