/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.extension.client;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.webauthn4j.data.extension.HMACGetSecretOutput;
import com.webauthn4j.data.extension.SingleValueExtensionOutputBase;
import com.webauthn4j.data.extension.UvmEntries;
import com.webauthn4j.data.extension.client.AuthenticationExtensionClientOutput;
import com.webauthn4j.data.extension.client.CredentialPropertiesExtensionClientOutput;
import com.webauthn4j.data.extension.client.CredentialPropertiesOutput;
import com.webauthn4j.data.extension.client.ExtensionClientOutput;
import com.webauthn4j.data.extension.client.FIDOAppIDExtensionClientOutput;
import com.webauthn4j.data.extension.client.HMACSecretAuthenticationExtensionClientOutput;
import com.webauthn4j.data.extension.client.HMACSecretRegistrationExtensionClientOutput;
import com.webauthn4j.data.extension.client.RegistrationExtensionClientOutput;
import com.webauthn4j.data.extension.client.UserVerificationMethodExtensionClientOutput;
import com.webauthn4j.util.AssertUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AuthenticationExtensionsClientOutputs<T extends ExtensionClientOutput> {
    @JsonIgnore
    private final Map<String, Object> unknowns = new HashMap<String, Object>();
    @JsonProperty
    private Boolean appid;
    @JsonProperty
    private UvmEntries uvm;
    @JsonProperty
    private CredentialPropertiesOutput credProps;
    @JsonProperty
    private Boolean hmacCreateSecret;
    @JsonProperty
    private HMACGetSecretOutput hmacGetSecret;
    @JsonIgnore
    private Map<Class<? extends T>, T> extensions;

    @JsonAnySetter
    private void setUnknowns(@NotNull String name, @Nullable Object value) {
        this.unknowns.put(name, value);
    }

    @JsonAnyGetter
    @NotNull
    private Map<String, Object> getUnknowns() {
        return this.unknowns;
    }

    @JsonIgnore
    @NotNull
    public Set<String> getKeys() {
        HashSet<String> keys2 = new HashSet<String>();
        if (this.appid != null) {
            keys2.add("appid");
        }
        if (this.uvm != null) {
            keys2.add("uvm");
        }
        if (this.credProps != null) {
            keys2.add("credProps");
        }
        if (this.hmacCreateSecret != null) {
            keys2.add("hmacCreateSecret");
        }
        if (this.hmacGetSecret != null) {
            keys2.add("hmacGetSecret");
        }
        keys2.addAll(this.getUnknownKeys());
        return keys2;
    }

    @JsonIgnore
    @NotNull
    public Set<String> getUnknownKeys() {
        return this.unknowns.keySet();
    }

    @JsonIgnore
    @Nullable
    public Object getValue(@NotNull String key) {
        switch (key) {
            case "appid": {
                return this.appid;
            }
            case "uvm": {
                return this.uvm;
            }
            case "credProps": {
                return this.credProps;
            }
            case "hmacCreateSecret": {
                return this.hmacCreateSecret;
            }
            case "hmacGetSecret": {
                return this.hmacGetSecret;
            }
        }
        return this.unknowns.get(key);
    }

    @JsonIgnore
    @Nullable
    public Boolean getAppid() {
        return this.appid;
    }

    @JsonIgnore
    @Nullable
    public UvmEntries getUvm() {
        return this.uvm;
    }

    @JsonIgnore
    @Nullable
    public Boolean getHMACCreateSecret() {
        return this.hmacCreateSecret;
    }

    @JsonIgnore
    @Nullable
    public HMACGetSecretOutput getHMACGetSecret() {
        return this.hmacGetSecret;
    }

    @JsonIgnore
    @Nullable
    public CredentialPropertiesOutput getCredProps() {
        return this.credProps;
    }

    @Nullable
    public <E extends T> E getExtension(@NotNull Class<E> tClass) {
        return (E)((ExtensionClientOutput)this.getExtensions().get(tClass));
    }

    @JsonIgnore
    @NotNull
    public Map<Class<? extends T>, T> getExtensions() {
        if (this.extensions == null) {
            HashMap<Class<HMACSecretAuthenticationExtensionClientOutput>, SingleValueExtensionOutputBase> map2 = new HashMap<Class<HMACSecretAuthenticationExtensionClientOutput>, SingleValueExtensionOutputBase>();
            if (this.appid != null) {
                map2.put(FIDOAppIDExtensionClientOutput.class, new FIDOAppIDExtensionClientOutput(this.appid));
            }
            if (this.uvm != null) {
                map2.put(UserVerificationMethodExtensionClientOutput.class, new UserVerificationMethodExtensionClientOutput(this.uvm));
            }
            if (this.credProps != null) {
                map2.put(CredentialPropertiesExtensionClientOutput.class, new CredentialPropertiesExtensionClientOutput(this.credProps));
            }
            if (this.hmacCreateSecret != null) {
                map2.put(HMACSecretRegistrationExtensionClientOutput.class, new HMACSecretRegistrationExtensionClientOutput(this.hmacCreateSecret));
            }
            if (this.hmacGetSecret != null) {
                map2.put(HMACSecretAuthenticationExtensionClientOutput.class, new HMACSecretAuthenticationExtensionClientOutput(this.hmacGetSecret));
            }
            this.extensions = Collections.unmodifiableMap(map2);
        }
        return this.extensions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticationExtensionsClientOutputs that = (AuthenticationExtensionsClientOutputs)o;
        return Objects.equals(this.unknowns, that.unknowns) && Objects.equals(this.appid, that.appid) && Objects.equals(this.uvm, that.uvm) && Objects.equals(this.credProps, that.credProps) && Objects.equals(this.hmacCreateSecret, that.hmacCreateSecret) && Objects.equals(this.hmacGetSecret, that.hmacGetSecret) && Objects.equals(this.extensions, that.extensions);
    }

    public int hashCode() {
        return Objects.hash(this.unknowns, this.appid, this.uvm, this.credProps, this.hmacCreateSecret, this.hmacGetSecret, this.extensions);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AuthenticationExtensionsAuthenticatorInputs(");
        String entries2 = this.getExtensions().values().stream().map(t -> String.format("%s=%s", t.getIdentifier(), t)).collect(Collectors.joining(", "));
        builder.append(entries2);
        String unknownsStr = this.getUnknowns().entrySet().stream().map(entry -> String.format("%s=%s", entry.getKey(), entry.getValue())).collect(Collectors.joining(", "));
        if (!unknownsStr.isEmpty()) {
            builder.append(", ");
            builder.append(unknownsStr);
        }
        builder.append(")");
        return builder.toString();
    }

    public static class BuilderForAuthentication {
        private final Map<String, Object> unknowns = new HashMap<String, Object>();
        private Boolean appid;
        private UvmEntries uvm;
        private HMACGetSecretOutput hmacGetSecret;

        @NotNull
        public AuthenticationExtensionsClientOutputs<AuthenticationExtensionClientOutput> build() {
            AuthenticationExtensionsClientOutputs<AuthenticationExtensionClientOutput> instance = new AuthenticationExtensionsClientOutputs<AuthenticationExtensionClientOutput>();
            instance.appid = this.appid;
            instance.uvm = this.uvm;
            instance.hmacGetSecret = this.hmacGetSecret;
            instance.unknowns.putAll(this.unknowns);
            return instance;
        }

        @NotNull
        public BuilderForAuthentication setAppid(@Nullable Boolean appid) {
            this.appid = appid;
            return this;
        }

        @NotNull
        public BuilderForAuthentication setUvm(@Nullable UvmEntries uvm) {
            this.uvm = uvm;
            return this;
        }

        @NotNull
        public BuilderForAuthentication setHMACGetSecret(@Nullable HMACGetSecretOutput hmacGetSecret) {
            this.hmacGetSecret = hmacGetSecret;
            return this;
        }

        @NotNull
        public BuilderForAuthentication set(@NotNull String key, @Nullable Object value) {
            AssertUtil.notNull(key, "key must not be null.");
            AssertUtil.notNull(value, "value must not be null.");
            this.unknowns.put(key, value);
            return this;
        }
    }

    public static class BuilderForRegistration {
        private final Map<String, Object> unknowns = new HashMap<String, Object>();
        private UvmEntries uvm;
        private CredentialPropertiesOutput credProps;
        private Boolean hmacCreateSecret;

        @NotNull
        public AuthenticationExtensionsClientOutputs<RegistrationExtensionClientOutput> build() {
            AuthenticationExtensionsClientOutputs<RegistrationExtensionClientOutput> instance = new AuthenticationExtensionsClientOutputs<RegistrationExtensionClientOutput>();
            instance.uvm = this.uvm;
            instance.credProps = this.credProps;
            instance.hmacCreateSecret = this.hmacCreateSecret;
            instance.unknowns.putAll(this.unknowns);
            return instance;
        }

        @NotNull
        public BuilderForRegistration setUvm(@Nullable UvmEntries uvm) {
            this.uvm = uvm;
            return this;
        }

        @NotNull
        public BuilderForRegistration setCredProps(@Nullable CredentialPropertiesOutput credProps) {
            this.credProps = credProps;
            return this;
        }

        @NotNull
        public BuilderForRegistration setHMACCreateSecret(@Nullable Boolean hmacCreateSecret) {
            this.hmacCreateSecret = hmacCreateSecret;
            return this;
        }

        @NotNull
        public BuilderForRegistration set(@NotNull String key, @Nullable Object value) {
            AssertUtil.notNull(key, "key must not be null.");
            AssertUtil.notNull(value, "value must not be null.");
            this.unknowns.put(key, value);
            return this;
        }
    }
}

