/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.CachedSupplier;
import com.networknt.schema.ExecutionContext;
import com.networknt.schema.InvalidSchemaRefException;
import com.networknt.schema.JsonNodePath;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaException;
import com.networknt.schema.JsonSchemaRef;
import com.networknt.schema.MessageSourceValidationMessage;
import com.networknt.schema.RefValidator;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import java.util.Collections;
import java.util.Set;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicRefValidator
extends BaseJsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(DynamicRefValidator.class);
    protected final JsonSchemaRef schema;

    public DynamicRefValidator(SchemaLocation schemaLocation, JsonNodePath evaluationPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaLocation, evaluationPath, schemaNode, parentSchema, ValidatorTypeCode.DYNAMIC_REF, validationContext);
        String refValue = schemaNode.asText();
        this.schema = DynamicRefValidator.getRefSchema(parentSchema, validationContext, refValue, evaluationPath);
    }

    static JsonSchemaRef getRefSchema(JsonSchema parentSchema, ValidationContext validationContext, String refValue, JsonNodePath evaluationPath) {
        String ref = DynamicRefValidator.resolve(parentSchema, refValue);
        return new JsonSchemaRef(DynamicRefValidator.getSupplier(() -> {
            JsonSchema refSchema = (JsonSchema)validationContext.getDynamicAnchors().get(ref);
            if (refSchema == null) {
                JsonSchemaRef r = RefValidator.getRefSchema(parentSchema, validationContext, refValue, evaluationPath);
                if (r != null) {
                    refSchema = r.getSchema();
                }
            } else {
                JsonSchema base2 = parentSchema;
                int index2 = ref.indexOf("#");
                String anchor = ref.substring(index2);
                String absoluteIri = ref.substring(0, index2);
                while (base2.getEvaluationParentSchema() != null) {
                    String baseAbsoluteIri = (base2 = base2.getEvaluationParentSchema()).getSchemaLocation().getAbsoluteIri() != null ? base2.getSchemaLocation().getAbsoluteIri().toString() : "";
                    if (baseAbsoluteIri.equals(absoluteIri)) continue;
                    absoluteIri = baseAbsoluteIri;
                    String parentRef = SchemaLocation.resolve(base2.getSchemaLocation(), anchor);
                    JsonSchema parentRefSchema = (JsonSchema)validationContext.getDynamicAnchors().get(parentRef);
                    if (parentRefSchema == null) continue;
                    refSchema = parentRefSchema;
                }
            }
            if (refSchema != null) {
                refSchema = refSchema.fromRef(parentSchema, evaluationPath);
            }
            return refSchema;
        }, validationContext.getConfig().isCacheRefs()));
    }

    static <T> Supplier<T> getSupplier(Supplier<T> supplier, boolean cache2) {
        return cache2 ? new CachedSupplier(supplier) : supplier;
    }

    private static String resolve(JsonSchema parentSchema, String refValue) {
        JsonSchema base2 = parentSchema;
        if (parentSchema.getId() != null && parentSchema.parentSchema != null) {
            base2 = parentSchema.parentSchema;
        }
        return SchemaLocation.resolve(base2.getSchemaLocation(), refValue);
    }

    @Override
    public Set<ValidationMessage> validate(ExecutionContext executionContext, JsonNode node2, JsonNode rootNode, JsonNodePath instanceLocation) {
        DynamicRefValidator.debug(logger, executionContext, node2, rootNode, instanceLocation);
        JsonSchema refSchema = this.schema.getSchema();
        if (refSchema == null) {
            ValidationMessage validationMessage = ((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)this.message().type(ValidatorTypeCode.DYNAMIC_REF.getValue())).code("internal.unresolvedRef")).message("{0}: Reference {1} cannot be resolved")).instanceLocation(instanceLocation)).evaluationPath(this.getEvaluationPath())).arguments(this.schemaNode.asText())).build();
            throw new InvalidSchemaRefException(validationMessage);
        }
        return refSchema.validate(executionContext, node2, rootNode, instanceLocation);
    }

    @Override
    public Set<ValidationMessage> walk(ExecutionContext executionContext, JsonNode node2, JsonNode rootNode, JsonNodePath instanceLocation, boolean shouldValidateSchema) {
        DynamicRefValidator.debug(logger, executionContext, node2, rootNode, instanceLocation);
        JsonSchema refSchema = this.schema.getSchema();
        if (refSchema == null) {
            ValidationMessage validationMessage = ((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)this.message().type(ValidatorTypeCode.DYNAMIC_REF.getValue())).code("internal.unresolvedRef")).message("{0}: Reference {1} cannot be resolved")).instanceLocation(instanceLocation)).evaluationPath(this.getEvaluationPath())).arguments(this.schemaNode.asText())).build();
            throw new InvalidSchemaRefException(validationMessage);
        }
        if (node2 == null) {
            SchemaLocation schemaLocation = refSchema.getSchemaLocation();
            JsonSchema check = refSchema;
            boolean circularDependency = false;
            while (check.getEvaluationParentSchema() != null) {
                if (!(check = check.getEvaluationParentSchema()).getSchemaLocation().equals(schemaLocation)) continue;
                circularDependency = true;
                break;
            }
            if (circularDependency) {
                return Collections.emptySet();
            }
        }
        return refSchema.walk(executionContext, node2, rootNode, instanceLocation, shouldValidateSchema);
    }

    public JsonSchemaRef getSchemaRef() {
        return this.schema;
    }

    @Override
    public void preloadJsonSchema() {
        JsonSchema jsonSchema = null;
        try {
            jsonSchema = this.schema.getSchema();
        }
        catch (JsonSchemaException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new JsonSchemaException(e);
        }
        SchemaLocation schemaLocation = jsonSchema.getSchemaLocation();
        JsonSchema check = jsonSchema;
        boolean circularDependency = false;
        int depth = 0;
        while (check.getEvaluationParentSchema() != null) {
            ++depth;
            if (!(check = check.getEvaluationParentSchema()).getSchemaLocation().equals(schemaLocation)) continue;
            circularDependency = true;
            break;
        }
        if (this.validationContext.getConfig().isCacheRefs() && !circularDependency && depth < this.validationContext.getConfig().getPreloadJsonSchemaRefMaxNestingDepth()) {
            jsonSchema.initializeValidators();
        }
    }
}

