/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.resource;

import com.networknt.schema.AbsoluteIri;
import com.networknt.schema.resource.ClasspathSchemaLoader;
import com.networknt.schema.resource.InputStreamSource;
import com.networknt.schema.resource.MetaSchemaMapper;
import com.networknt.schema.resource.SchemaLoader;
import com.networknt.schema.resource.SchemaMapper;
import com.networknt.schema.resource.UriSchemaLoader;
import java.util.ArrayList;
import java.util.List;

public class DefaultSchemaLoader
implements SchemaLoader {
    private static final List<SchemaLoader> DEFAULT;
    private static final MetaSchemaMapper META_SCHEMA_MAPPER;
    private final List<SchemaLoader> schemaLoaders;
    private final List<SchemaMapper> schemaMappers;

    public DefaultSchemaLoader(List<SchemaLoader> schemaLoaders, List<SchemaMapper> schemaMappers) {
        this.schemaLoaders = schemaLoaders;
        this.schemaMappers = schemaMappers;
    }

    @Override
    public InputStreamSource getSchema(AbsoluteIri absoluteIri) {
        InputStreamSource result2;
        AbsoluteIri mappedResult = absoluteIri;
        for (SchemaMapper mapper : this.schemaMappers) {
            AbsoluteIri mapped = mapper.map(mappedResult);
            if (mapped == null) continue;
            mappedResult = mapped;
        }
        AbsoluteIri mapped = META_SCHEMA_MAPPER.map(absoluteIri);
        if (mapped != null) {
            mappedResult = mapped;
        }
        for (SchemaLoader loader : this.schemaLoaders) {
            result2 = loader.getSchema(mappedResult);
            if (result2 == null) continue;
            return result2;
        }
        for (SchemaLoader loader : DEFAULT) {
            result2 = loader.getSchema(mappedResult);
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }

    static {
        META_SCHEMA_MAPPER = new MetaSchemaMapper();
        ArrayList<SchemaLoader> result2 = new ArrayList<SchemaLoader>();
        result2.add(new ClasspathSchemaLoader());
        result2.add(new UriSchemaLoader());
        DEFAULT = result2;
    }
}

