/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.attestation.statement;

import com.webauthn4j.data.attestation.statement.TPMUPublicParms;
import com.webauthn4j.util.ArrayUtil;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TPMSRSAParms
implements TPMUPublicParms {
    private final byte[] symmetric;
    private final byte[] scheme;
    private final byte[] keyBits;
    private final byte[] exponent;

    public TPMSRSAParms(@NotNull byte[] symmetric, @NotNull byte[] scheme, @NotNull byte[] keyBits, @NotNull byte[] exponent) {
        this.symmetric = symmetric;
        this.scheme = scheme;
        this.keyBits = keyBits;
        this.exponent = exponent;
    }

    @NotNull
    public byte[] getSymmetric() {
        return ArrayUtil.clone((byte[])this.symmetric);
    }

    @NotNull
    public byte[] getScheme() {
        return ArrayUtil.clone((byte[])this.scheme);
    }

    @NotNull
    public byte[] getKeyBits() {
        return ArrayUtil.clone((byte[])this.keyBits);
    }

    @NotNull
    public byte[] getExponent() {
        return ArrayUtil.clone((byte[])this.exponent);
    }

    @Override
    @NotNull
    public byte[] getBytes() {
        return ByteBuffer.allocate(10).put(this.symmetric).put(this.scheme).put(this.keyBits).put(this.exponent).array();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TPMSRSAParms that = (TPMSRSAParms)o;
        return Arrays.equals(this.symmetric, that.symmetric) && Arrays.equals(this.scheme, that.scheme) && Arrays.equals(this.keyBits, that.keyBits) && Arrays.equals(this.exponent, that.exponent);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.symmetric);
        result = 31 * result + Arrays.hashCode(this.scheme);
        result = 31 * result + Arrays.hashCode(this.keyBits);
        result = 31 * result + Arrays.hashCode(this.exponent);
        return result;
    }
}

