/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data;

import com.webauthn4j.data.attestation.AttestationObject;
import com.webauthn4j.util.ArrayUtil;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class CoreRegistrationData {
    private final AttestationObject attestationObject;
    private final byte[] attestationObjectBytes;
    private final byte[] clientDataHash;

    public CoreRegistrationData(@Nullable AttestationObject attestationObject, @Nullable byte[] attestationObjectBytes, @Nullable byte[] clientDataHash) {
        this.attestationObject = attestationObject;
        this.attestationObjectBytes = ArrayUtil.clone(attestationObjectBytes);
        this.clientDataHash = ArrayUtil.clone(clientDataHash);
    }

    @Nullable
    public AttestationObject getAttestationObject() {
        return this.attestationObject;
    }

    @Nullable
    public byte[] getAttestationObjectBytes() {
        return ArrayUtil.clone(this.attestationObjectBytes);
    }

    @Nullable
    public byte[] getClientDataHash() {
        return ArrayUtil.clone(this.clientDataHash);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoreRegistrationData that = (CoreRegistrationData)o;
        return Objects.equals(this.attestationObject, that.attestationObject) && Arrays.equals(this.attestationObjectBytes, that.attestationObjectBytes) && Arrays.equals(this.clientDataHash, that.clientDataHash);
    }

    public int hashCode() {
        int result2 = Objects.hash(this.attestationObject);
        result2 = 31 * result2 + Arrays.hashCode(this.attestationObjectBytes);
        result2 = 31 * result2 + Arrays.hashCode(this.clientDataHash);
        return result2;
    }

    public String toString() {
        return "CoreRegistrationData(attestationObject=" + this.attestationObject + ", attestationObjectBytes=" + ArrayUtil.toHexString(this.attestationObjectBytes) + ", clientDataHash=" + ArrayUtil.toHexString(this.clientDataHash) + ")";
    }
}

