/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.asn1.type;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import org.apache.kerby.asn1.UniversalTag;
import org.apache.kerby.asn1.type.Asn1Simple;

public class Asn1ObjectIdentifier
extends Asn1Simple<String> {
    public Asn1ObjectIdentifier() {
        this((String)null);
    }

    public Asn1ObjectIdentifier(String value) {
        super(UniversalTag.OBJECT_IDENTIFIER, value);
    }

    @Override
    protected void toBytes() {
        byte[][] bytesArr = this.convert((String)this.getValue());
        int allLen = 0;
        for (byte[] bytes : bytesArr) {
            allLen += bytes.length;
        }
        ByteBuffer buffer = ByteBuffer.allocate(allLen);
        for (byte[] bytes : bytesArr) {
            buffer.put(bytes);
        }
        this.setBytes(buffer.array());
    }

    @Override
    protected void toValue() {
        StringBuilder sb = new StringBuilder();
        byte[] bytes = this.getBytes();
        byte[][] bytesGroups = this.group(bytes);
        BigInteger[] coms = this.convert(bytesGroups);
        long first2 = coms[0].longValue();
        sb.append(first2 / 40L).append('.');
        sb.append(first2 % 40L);
        if (coms.length > 1) {
            sb.append('.');
        }
        for (int i2 = 1; i2 < coms.length; ++i2) {
            sb.append(coms[i2].toString());
            if (i2 == coms.length - 1) continue;
            sb.append('.');
        }
        String value = sb.toString();
        this.setValue(value);
    }

    private BigInteger[] convert(byte[][] bytesGroups) {
        BigInteger[] comps = new BigInteger[bytesGroups.length];
        for (int i2 = 0; i2 < bytesGroups.length; ++i2) {
            comps[i2] = this.convert(bytesGroups[i2]);
        }
        return comps;
    }

    private BigInteger convert(byte[] bytes) {
        BigInteger value = BigInteger.valueOf(bytes[0] & 0x7F);
        for (int i2 = 1; i2 < bytes.length; ++i2) {
            value = value.shiftLeft(7);
            value = value.or(BigInteger.valueOf(bytes[i2] & 0x7F));
        }
        return value;
    }

    private byte[][] group(byte[] bytes) {
        int i2;
        int count2 = 0;
        int[] countArr = new int[bytes.length];
        for (i2 = 0; i2 < countArr.length; ++i2) {
            countArr[i2] = 0;
        }
        int j = 0;
        for (i2 = 0; i2 < bytes.length; ++i2) {
            if ((bytes[i2] & 0x80) != 0) {
                int n = j;
                countArr[n] = countArr[n] + 1;
                continue;
            }
            int n = j++;
            countArr[n] = countArr[n] + 1;
        }
        count2 = j;
        byte[][] bytesGroups = new byte[count2][];
        for (i2 = 0; i2 < count2; ++i2) {
            bytesGroups[i2] = new byte[countArr[i2]];
        }
        int k = 0;
        j = 0;
        for (i2 = 0; i2 < bytes.length; ++i2) {
            bytesGroups[j][k++] = bytes[i2];
            if ((bytes[i2] & 0x80) != 0) continue;
            ++j;
            k = 0;
        }
        return bytesGroups;
    }

    private byte[][] convert(String oid) {
        String[] parts = oid.split("\\.");
        BigInteger[] coms = new BigInteger[parts.length - 1];
        for (int i2 = 1; i2 < parts.length; ++i2) {
            coms[i2 - 1] = new BigInteger(parts[i2]);
        }
        coms[0] = coms[0].add(BigInteger.valueOf((long)Integer.parseInt(parts[0]) * 40L));
        byte[][] bytesGroups = new byte[coms.length][];
        for (int i3 = 0; i3 < coms.length; ++i3) {
            bytesGroups[i3] = this.convert(coms[i3]);
        }
        return bytesGroups;
    }

    private byte[] convert(BigInteger value) {
        int bitLen = value.bitLength();
        if (bitLen < 8) {
            return new byte[]{value.byteValue()};
        }
        int len = (bitLen + 6) / 7;
        byte[] bytes = new byte[len];
        BigInteger tmpValue = value;
        for (int i2 = len - 1; i2 >= 0; --i2) {
            bytes[i2] = (byte)(tmpValue.byteValue() & 0x7F | 0x80);
            tmpValue = tmpValue.shiftRight(7);
        }
        int n = len - 1;
        bytes[n] = (byte)(bytes[n] & 0x7F);
        return bytes;
    }
}

