/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation;

import androidx.annotation.RestrictTo;
import androidx.navigation.BoolArrayNavType;
import androidx.navigation.BoolListNavType;
import androidx.navigation.BoolNavType;
import androidx.navigation.FloatArrayNavType;
import androidx.navigation.FloatListNavType;
import androidx.navigation.FloatNavType;
import androidx.navigation.IntArrayNavType;
import androidx.navigation.IntListNavType;
import androidx.navigation.IntNavType;
import androidx.navigation.LongArrayNavType;
import androidx.navigation.LongListNavType;
import androidx.navigation.LongNavType;
import androidx.navigation.NavTypeKt;
import androidx.navigation.StringArrayNavType;
import androidx.navigation.StringListNavType;
import androidx.navigation.StringNavType;
import androidx.savedstate.SavedState;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0016\b&\u0018\u0000 \"*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\"B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J%\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u000fJ \u0010\u0010\u001a\u0004\u0018\u00018\u00002\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u00a6\u0002\u00a2\u0006\u0002\u0010\u0011J\u0015\u0010\u0012\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00020\rH&\u00a2\u0006\u0002\u0010\u0013J\u001d\u0010\u0012\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0015J%\u0010\u0016\u001a\u00028\u00002\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0007\u00a2\u0006\u0002\u0010\u0017J/\u0010\u0016\u001a\u00028\u00002\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0014\u001a\u00028\u0000H\u0007\u00a2\u0006\u0002\u0010\u0018J\u0015\u0010\u0019\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u001d\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00028\u00002\u0006\u0010\u001f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010 J\b\u0010!\u001a\u00020\rH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0007R\u0014\u0010\u001b\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006#"}, d2={"Landroidx/navigation/NavType;", "T", "", "isNullableAllowed", "", "<init>", "(Z)V", "()Z", "put", "", "bundle", "Landroidx/savedstate/SavedState;", "key", "", "value", "(Landroidx/savedstate/SavedState;Ljava/lang/String;Ljava/lang/Object;)V", "get", "(Landroidx/savedstate/SavedState;Ljava/lang/String;)Ljava/lang/Object;", "parseValue", "(Ljava/lang/String;)Ljava/lang/Object;", "previousValue", "(Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;", "parseAndPut", "(Landroidx/savedstate/SavedState;Ljava/lang/String;Ljava/lang/String;)Ljava/lang/Object;", "(Landroidx/savedstate/SavedState;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;", "serializeAsValue", "(Ljava/lang/Object;)Ljava/lang/String;", "name", "getName", "()Ljava/lang/String;", "valueEquals", "other", "(Ljava/lang/Object;Ljava/lang/Object;)Z", "toString", "Companion", "navigation-common"})
public abstract class NavType<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean isNullableAllowed;
    @NotNull
    private final String name;
    @NotNull
    private static final NavType<Integer> IntType = new IntNavType();
    @NotNull
    private static final NavType<int[]> IntArrayType = new IntArrayNavType();
    @NotNull
    private static final NavType<List<Integer>> IntListType = new IntListNavType();
    @NotNull
    private static final NavType<Long> LongType = new LongNavType();
    @NotNull
    private static final NavType<long[]> LongArrayType = new LongArrayNavType();
    @NotNull
    private static final NavType<List<Long>> LongListType = new LongListNavType();
    @NotNull
    private static final NavType<Float> FloatType = new FloatNavType();
    @NotNull
    private static final NavType<float[]> FloatArrayType = new FloatArrayNavType();
    @NotNull
    private static final NavType<List<Float>> FloatListType = new FloatListNavType();
    @NotNull
    private static final NavType<Boolean> BoolType = new BoolNavType();
    @NotNull
    private static final NavType<boolean[]> BoolArrayType = new BoolArrayNavType();
    @NotNull
    private static final NavType<List<Boolean>> BoolListType = new BoolListNavType();
    @NotNull
    private static final NavType<String> StringType = new StringNavType();
    @NotNull
    private static final NavType<String[]> StringArrayType = new StringArrayNavType();
    @NotNull
    private static final NavType<List<String>> StringListType = new StringListNavType();

    public NavType(boolean isNullableAllowed) {
        this.isNullableAllowed = isNullableAllowed;
        this.name = "nav_type";
    }

    public boolean isNullableAllowed() {
        return this.isNullableAllowed;
    }

    public abstract void put(@NotNull SavedState var1, @NotNull String var2, T var3);

    @Nullable
    public abstract T get(@NotNull SavedState var1, @NotNull String var2);

    public abstract T parseValue(@NotNull String var1);

    public T parseValue(@NotNull String value, T previousValue) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.parseValue(value);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final T parseAndPut(@NotNull SavedState bundle, @NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return NavTypeKt.navTypeParseAndPut(this, bundle, key, value);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final T parseAndPut(@NotNull SavedState bundle, @NotNull String key, @Nullable String value, T previousValue) {
        Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return NavTypeKt.navTypeParseAndPut(this, bundle, key, value, previousValue);
    }

    @NotNull
    public String serializeAsValue(T value) {
        return String.valueOf(value);
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public boolean valueEquals(T value, T other) {
        return Intrinsics.areEqual(value, other);
    }

    @NotNull
    public String toString() {
        return this.getName();
    }

    @JvmStatic
    @NotNull
    public static NavType<?> fromArgType(@Nullable String type, @Nullable String packageName) {
        return Companion.fromArgType(type, packageName);
    }

    @JvmStatic
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    public static final NavType<Object> inferFromValue(@NotNull String value) {
        return Companion.inferFromValue(value);
    }

    @JvmStatic
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    public static final NavType<Object> inferFromValueType(@Nullable Object value) {
        return Companion.inferFromValueType(value);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0018\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0007H\u0017J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00010\u00052\u0006\u0010\n\u001a\u00020\u0007H\u0007J\u0018\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00010\u00052\b\u0010\n\u001a\u0004\u0018\u00010\u0001H\u0007R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0019\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR\u001f\u0010\u0013\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\r\u0018\u00010\u00140\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000fR\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u000fR\u0019\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001a0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u000fR\u001f\u0010\u001c\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u00140\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u000fR\u0017\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u000fR\u0019\u0010!\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\"0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u000fR\u001f\u0010$\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u00140\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u000fR\u0017\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u000fR\u0019\u0010)\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010*0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\u000fR\u001f\u0010,\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020'\u0018\u00010\u00140\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010\u000fR\u0019\u0010.\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010\u000fR\u001f\u00100\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0007\u0018\u0001010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010\u000fR\u001f\u00103\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00140\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u0010\u000f\u00a8\u00065"}, d2={"Landroidx/navigation/NavType$Companion;", "", "<init>", "()V", "fromArgType", "Landroidx/navigation/NavType;", "type", "", "packageName", "inferFromValue", "value", "inferFromValueType", "IntType", "", "getIntType", "()Landroidx/navigation/NavType;", "IntArrayType", "", "getIntArrayType", "IntListType", "", "getIntListType", "LongType", "", "getLongType", "LongArrayType", "", "getLongArrayType", "LongListType", "getLongListType", "FloatType", "", "getFloatType", "FloatArrayType", "", "getFloatArrayType", "FloatListType", "getFloatListType", "BoolType", "", "getBoolType", "BoolArrayType", "", "getBoolArrayType", "BoolListType", "getBoolListType", "StringType", "getStringType", "StringArrayType", "", "getStringArrayType", "StringListType", "getStringListType", "navigation-common"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public NavType<?> fromArgType(@Nullable String type, @Nullable String packageName) {
            NavType<Object> navType = NavTypeKt.navTypeFromArgType(type);
            if (navType == null) {
                CharSequence charSequence = type;
                if (!(charSequence == null || charSequence.length() == 0)) {
                    throw new IllegalArgumentException("Object of type " + type + " is not supported for navigation arguments.");
                }
                navType = this.getStringType();
            }
            return navType;
        }

        @JvmStatic
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NotNull
        public final NavType<Object> inferFromValue(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return NavTypeKt.navTypeInferFromValue(value);
        }

        @JvmStatic
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NotNull
        public final NavType<Object> inferFromValueType(@Nullable Object value) {
            NavType<Object> navType = NavTypeKt.navTypeInferFromValueType(value);
            if (navType == null) {
                if (value instanceof Object[]) {
                    NavType<String[]> navType2 = this.getStringArrayType();
                    navType = navType2;
                    Intrinsics.checkNotNull(navType2, (String)"null cannot be cast to non-null type androidx.navigation.NavType<kotlin.Any>");
                } else {
                    throw new IllegalArgumentException(value + " is not supported for navigation arguments.");
                }
            }
            return navType;
        }

        @NotNull
        public final NavType<Integer> getIntType() {
            return IntType;
        }

        @NotNull
        public final NavType<int[]> getIntArrayType() {
            return IntArrayType;
        }

        @NotNull
        public final NavType<List<Integer>> getIntListType() {
            return IntListType;
        }

        @NotNull
        public final NavType<Long> getLongType() {
            return LongType;
        }

        @NotNull
        public final NavType<long[]> getLongArrayType() {
            return LongArrayType;
        }

        @NotNull
        public final NavType<List<Long>> getLongListType() {
            return LongListType;
        }

        @NotNull
        public final NavType<Float> getFloatType() {
            return FloatType;
        }

        @NotNull
        public final NavType<float[]> getFloatArrayType() {
            return FloatArrayType;
        }

        @NotNull
        public final NavType<List<Float>> getFloatListType() {
            return FloatListType;
        }

        @NotNull
        public final NavType<Boolean> getBoolType() {
            return BoolType;
        }

        @NotNull
        public final NavType<boolean[]> getBoolArrayType() {
            return BoolArrayType;
        }

        @NotNull
        public final NavType<List<Boolean>> getBoolListType() {
            return BoolListType;
        }

        @NotNull
        public final NavType<String> getStringType() {
            return StringType;
        }

        @NotNull
        public final NavType<String[]> getStringArrayType() {
            return StringArrayType;
        }

        @NotNull
        public final NavType<List<String>> getStringListType() {
            return StringListType;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

