/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter.jackson;

import com.fasterxml.jackson.databind.module.SimpleModule;
import com.webauthn4j.converter.jackson.deserializer.json.AttachmentHintFromLongDeserializer;
import com.webauthn4j.converter.jackson.deserializer.json.AuthenticationAlgorithmFromIntDeserializer;
import com.webauthn4j.converter.jackson.deserializer.json.AuthenticatorAttestationTypeFromIntDeserializer;
import com.webauthn4j.converter.jackson.deserializer.json.ChallengeDeserializer;
import com.webauthn4j.converter.jackson.deserializer.json.CredentialProtectionPolicyDeserializer;
import com.webauthn4j.converter.jackson.deserializer.json.JWSHeaderDeserializer;
import com.webauthn4j.converter.jackson.deserializer.json.KeyProtectionTypeFromIntDeserializer;
import com.webauthn4j.converter.jackson.deserializer.json.MatcherProtectionTypeFromIntDeserializer;
import com.webauthn4j.converter.jackson.deserializer.json.PublicKeyRepresentationFormatFromIntDeserializer;
import com.webauthn4j.converter.jackson.deserializer.json.TransactionConfirmationDisplayFromIntDeserializer;
import com.webauthn4j.converter.jackson.deserializer.json.UserVerificationMethodFromLongDeserializer;
import com.webauthn4j.converter.jackson.deserializer.json.X509CertificateDeserializer;
import com.webauthn4j.converter.jackson.serializer.json.AttachmentHintToLongSerializer;
import com.webauthn4j.converter.jackson.serializer.json.AuthenticationAlgorithmToIntSerializer;
import com.webauthn4j.converter.jackson.serializer.json.AuthenticatorAttestationTypeToIntSerializer;
import com.webauthn4j.converter.jackson.serializer.json.ChallengeSerializer;
import com.webauthn4j.converter.jackson.serializer.json.CredentialProtectionPolicySerializer;
import com.webauthn4j.converter.jackson.serializer.json.JWSHeaderSerializer;
import com.webauthn4j.converter.jackson.serializer.json.KeyProtectionTypeToIntSerializer;
import com.webauthn4j.converter.jackson.serializer.json.MatcherProtectionTypeToIntSerializer;
import com.webauthn4j.converter.jackson.serializer.json.OriginSerializer;
import com.webauthn4j.converter.jackson.serializer.json.PublicKeyRepresentationFormatToIntSerializer;
import com.webauthn4j.converter.jackson.serializer.json.TransactionConfirmationDisplayToIntSerializer;
import com.webauthn4j.converter.jackson.serializer.json.UserVerificationMethodToLongSerializer;
import com.webauthn4j.converter.jackson.serializer.json.X509CertificateSerializer;
import com.webauthn4j.converter.util.ObjectConverter;
import com.webauthn4j.data.AttachmentHint;
import com.webauthn4j.data.AuthenticationAlgorithm;
import com.webauthn4j.data.AuthenticatorAttestationType;
import com.webauthn4j.data.KeyProtectionType;
import com.webauthn4j.data.MatcherProtectionType;
import com.webauthn4j.data.PublicKeyRepresentationFormat;
import com.webauthn4j.data.TransactionConfirmationDisplay;
import com.webauthn4j.data.UserVerificationMethod;
import com.webauthn4j.data.client.challenge.Challenge;
import com.webauthn4j.data.extension.CredentialProtectionPolicy;
import com.webauthn4j.data.jws.JWSHeader;
import com.webauthn4j.util.AssertUtil;
import java.security.cert.X509Certificate;
import org.jetbrains.annotations.NotNull;

public class WebAuthnJSONModule
extends SimpleModule {
    public WebAuthnJSONModule(@NotNull ObjectConverter objectConverter) {
        super("WebAuthnJSONModule");
        AssertUtil.notNull(objectConverter, "objectConverter must not be null");
        this.addDeserializer(AttachmentHint.class, new AttachmentHintFromLongDeserializer());
        this.addDeserializer(AuthenticatorAttestationType.class, new AuthenticatorAttestationTypeFromIntDeserializer());
        this.addDeserializer(AuthenticationAlgorithm.class, new AuthenticationAlgorithmFromIntDeserializer());
        this.addDeserializer(Challenge.class, new ChallengeDeserializer());
        this.addDeserializer(CredentialProtectionPolicy.class, new CredentialProtectionPolicyDeserializer());
        this.addDeserializer(JWSHeader.class, new JWSHeaderDeserializer());
        this.addDeserializer(KeyProtectionType.class, new KeyProtectionTypeFromIntDeserializer());
        this.addDeserializer(MatcherProtectionType.class, new MatcherProtectionTypeFromIntDeserializer());
        this.addDeserializer(PublicKeyRepresentationFormat.class, new PublicKeyRepresentationFormatFromIntDeserializer());
        this.addDeserializer(TransactionConfirmationDisplay.class, new TransactionConfirmationDisplayFromIntDeserializer());
        this.addDeserializer(UserVerificationMethod.class, new UserVerificationMethodFromLongDeserializer());
        this.addDeserializer(X509Certificate.class, new X509CertificateDeserializer());
        this.addSerializer(AttachmentHint.class, new AttachmentHintToLongSerializer());
        this.addSerializer(AuthenticatorAttestationType.class, new AuthenticatorAttestationTypeToIntSerializer());
        this.addSerializer(AuthenticationAlgorithm.class, new AuthenticationAlgorithmToIntSerializer());
        this.addSerializer(new ChallengeSerializer());
        this.addSerializer(new CredentialProtectionPolicySerializer());
        this.addSerializer(new JWSHeaderSerializer());
        this.addSerializer(new KeyProtectionTypeToIntSerializer());
        this.addSerializer(new MatcherProtectionTypeToIntSerializer());
        this.addSerializer(new OriginSerializer());
        this.addSerializer(PublicKeyRepresentationFormat.class, new PublicKeyRepresentationFormatToIntSerializer());
        this.addSerializer(TransactionConfirmationDisplay.class, new TransactionConfirmationDisplayToIntSerializer());
        this.addSerializer(UserVerificationMethod.class, new UserVerificationMethodToLongSerializer());
        this.addSerializer(new X509CertificateSerializer());
    }
}

