/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation;

import androidx.compose.animation.SplineBasedFloatDecayAnimationSpec;
import androidx.compose.animation.core.DecayAnimationSpec;
import androidx.compose.animation.core.DecayAnimationSpecKt;
import androidx.compose.ui.unit.Density;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u000e\"\u0004\b\u0000\u0010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Inflection", "", "StartTension", "EndTension", "P1", "P2", "computeSplineInfo", "", "splinePositions", "", "splineTimes", "nbSamples", "", "splineBasedDecay", "Landroidx/compose/animation/core/DecayAnimationSpec;", "T", "density", "Landroidx/compose/ui/unit/Density;", "animation"})
public final class SplineBasedDecayKt {
    private static final float Inflection = 0.35f;
    private static final float StartTension = 0.5f;
    private static final float EndTension = 1.0f;
    private static final float P1 = 0.175f;
    private static final float P2 = 0.35000002f;

    private static final void computeSplineInfo(float[] splinePositions, float[] splineTimes, int nbSamples) {
        float xMin = 0.0f;
        float yMin = 0.0f;
        for (int i2 = 0; i2 < nbSamples; ++i2) {
            float alpha2 = (float)i2 / (float)nbSamples;
            float xMax = 1.0f;
            float x2 = 0.0f;
            float tx = 0.0f;
            float coef = 0.0f;
            while (!((double)Math.abs((tx = (coef = 3.0f * (x2 = xMin + (xMax - xMin) / 2.0f) * (1.0f - x2)) * ((1.0f - x2) * 0.175f + x2 * 0.35000002f) + x2 * x2 * x2) - alpha2) < 1.0E-5)) {
                if (tx > alpha2) {
                    xMax = x2;
                    continue;
                }
                xMin = x2;
            }
            splinePositions[i2] = coef * ((1.0f - x2) * 0.5f + x2) + x2 * x2 * x2;
            float yMax = 1.0f;
            float y2 = 0.0f;
            float dy = 0.0f;
            while (!((double)Math.abs((dy = (coef = 3.0f * (y2 = yMin + (yMax - yMin) / 2.0f) * (1.0f - y2)) * ((1.0f - y2) * 0.5f + y2) + y2 * y2 * y2) - alpha2) < 1.0E-5)) {
                if (dy > alpha2) {
                    yMax = y2;
                    continue;
                }
                yMin = y2;
            }
            splineTimes[i2] = coef * ((1.0f - y2) * 0.175f + y2 * 0.35000002f) + y2 * y2 * y2;
        }
        splineTimes[nbSamples] = 1.0f;
        splinePositions[nbSamples] = splineTimes[nbSamples];
    }

    @NotNull
    public static final <T> DecayAnimationSpec<T> splineBasedDecay(@NotNull Density density) {
        Intrinsics.checkNotNullParameter(density, "density");
        return DecayAnimationSpecKt.generateDecayAnimationSpec(new SplineBasedFloatDecayAnimationSpec(density));
    }

    public static final /* synthetic */ void access$computeSplineInfo(float[] splinePositions, float[] splineTimes, int nbSamples) {
        SplineBasedDecayKt.computeSplineInfo(splinePositions, splineTimes, nbSamples);
    }
}

