/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.output;

import com.networknt.schema.ExecutionContext;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.output.OutputUnit;
import com.networknt.schema.output.OutputUnitData;
import com.networknt.schema.output.OutputUnitKey;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class ListOutputUnitFormatter {
    public static OutputUnit format(OutputUnit root, OutputUnitData data2) {
        Map<OutputUnitKey, Boolean> valid = data2.getValid();
        Map<OutputUnitKey, Map<String, Object>> errors = data2.getErrors();
        Map<OutputUnitKey, Map<String, Object>> annotations = data2.getAnnotations();
        Map<OutputUnitKey, Map<String, Object>> droppedAnnotations = data2.getDroppedAnnotations();
        for (Map.Entry<OutputUnitKey, Boolean> entry : valid.entrySet()) {
            List<OutputUnit> details2;
            Map<String, Object> map2;
            Map<String, Object> annotationsMap;
            OutputUnit output2 = new OutputUnit();
            OutputUnitKey key = entry.getKey();
            output2.setValid(entry.getValue());
            output2.setEvaluationPath(key.getEvaluationPath().toString());
            output2.setSchemaLocation(key.getSchemaLocation().toString());
            output2.setInstanceLocation(key.getInstanceLocation().toString());
            Map<String, Object> errorMap = errors.get(key);
            if (errorMap != null && !errorMap.isEmpty()) {
                if (output2.getErrors() == null) {
                    output2.setErrors(new LinkedHashMap<String, Object>());
                }
                for (Map.Entry<String, Object> entry2 : errorMap.entrySet()) {
                    output2.getErrors().put(entry2.getKey(), entry2.getValue());
                }
            }
            if ((annotationsMap = annotations.get(key)) != null && !annotationsMap.isEmpty()) {
                if (output2.getAnnotations() == null) {
                    output2.setAnnotations(new LinkedHashMap<String, Object>());
                }
                for (Object annotationEntry : annotationsMap.entrySet()) {
                    output2.getAnnotations().put((String)annotationEntry.getKey(), annotationEntry.getValue());
                }
            }
            if ((map2 = droppedAnnotations.get(key)) != null && !map2.isEmpty()) {
                Object annotationEntry;
                if (output2.getDroppedAnnotations() == null) {
                    output2.setDroppedAnnotations(new LinkedHashMap<String, Object>());
                }
                annotationEntry = map2.entrySet().iterator();
                while (annotationEntry.hasNext()) {
                    Map.Entry entry3 = (Map.Entry)annotationEntry.next();
                    output2.getDroppedAnnotations().put((String)entry3.getKey(), entry3.getValue());
                }
            }
            if ((details2 = root.getDetails()) == null) {
                details2 = new ArrayList<OutputUnit>();
                root.setDetails(details2);
            }
            details2.add(output2);
        }
        return root;
    }

    public static OutputUnit format(Set<ValidationMessage> validationMessages, ExecutionContext executionContext, ValidationContext validationContext, Function<ValidationMessage, Object> assertionMapper) {
        OutputUnit root = new OutputUnit();
        root.setValid(validationMessages.isEmpty());
        return ListOutputUnitFormatter.format(root, OutputUnitData.from(validationMessages, executionContext, assertionMapper));
    }
}

