/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter.jackson.deserializer.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.webauthn4j.data.AttachmentHint;
import java.io.IOException;

public class AttachmentHintFromStringDeserializer
extends StdDeserializer<AttachmentHint> {
    public AttachmentHintFromStringDeserializer() {
        super(AttachmentHint.class);
    }

    @Override
    public AttachmentHint deserialize(JsonParser p2, DeserializationContext ctxt) throws IOException {
        String value = p2.getValueAsString();
        try {
            return AttachmentHint.create(value);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidFormatException(null, "value is out of range", (Object)value, AttachmentHint.class);
        }
    }
}

