package world.respect.datalayer.db.opds.daos

import androidx.room.EntityInsertAdapter
import androidx.room.RoomDatabase
import androidx.room.util.getColumnIndexOrThrow
import androidx.room.util.performSuspending
import androidx.sqlite.SQLiteStatement
import javax.`annotation`.processing.Generated
import kotlin.Boolean
import kotlin.Double
import kotlin.IllegalArgumentException
import kotlin.Int
import kotlin.Long
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.MutableList
import kotlin.collections.mutableListOf
import kotlin.reflect.KClass
import world.respect.datalayer.db.opds.OpdsParentType
import world.respect.datalayer.db.opds.OpdsTypeConverters
import world.respect.datalayer.db.opds.entities.ReadiumLinkEntity
import world.respect.datalayer.db.shared.SharedConverters

@Generated(value = ["androidx.room.RoomProcessor"])
@Suppress(names = ["UNCHECKED_CAST", "DEPRECATION", "REDUNDANT_PROJECTION", "REMOVAL"])
public class ReadiumLinkEntityDao_Impl(
  __db: RoomDatabase,
) : ReadiumLinkEntityDao() {
  private val __db: RoomDatabase

  private val __insertAdapterOfReadiumLinkEntity: EntityInsertAdapter<ReadiumLinkEntity>

  private val __opdsTypeConverters: OpdsTypeConverters = OpdsTypeConverters()

  private val __sharedConverters: SharedConverters = SharedConverters()
  init {
    this.__db = __db
    this.__insertAdapterOfReadiumLinkEntity = object : EntityInsertAdapter<ReadiumLinkEntity>() {
      protected override fun createQuery(): String = "INSERT OR ABORT INTO `ReadiumLinkEntity` (`rleId`,`rleOpdsParentType`,`rleOpdsParentUid`,`rlePropType`,`rlePropFk`,`rleIndex`,`rleHref`,`rleRel`,`rleType`,`rleTitle`,`rleTemplated`,`rleProperties`,`rleHeight`,`rleWidth`,`rleSize`,`rleBitrate`,`rleDuration`,`rleLanguage`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)"

      protected override fun bind(statement: SQLiteStatement, entity: ReadiumLinkEntity) {
        statement.bindLong(1, entity.rleId)
        val _tmp: Int = __opdsTypeConverters.fromOpdsTopParentType(entity.rleOpdsParentType)
        statement.bindLong(2, _tmp.toLong())
        statement.bindLong(3, entity.rleOpdsParentUid)
        statement.bindText(4, __PropertyType_enumToString(entity.rlePropType))
        statement.bindLong(5, entity.rlePropFk)
        statement.bindLong(6, entity.rleIndex.toLong())
        statement.bindText(7, entity.rleHref)
        val _tmpRleRel: List<String>? = entity.rleRel
        val _tmp_1: String? = __sharedConverters.fromStringList(_tmpRleRel)
        if (_tmp_1 == null) {
          statement.bindNull(8)
        } else {
          statement.bindText(8, _tmp_1)
        }
        val _tmpRleType: String? = entity.rleType
        if (_tmpRleType == null) {
          statement.bindNull(9)
        } else {
          statement.bindText(9, _tmpRleType)
        }
        val _tmpRleTitle: String? = entity.rleTitle
        if (_tmpRleTitle == null) {
          statement.bindNull(10)
        } else {
          statement.bindText(10, _tmpRleTitle)
        }
        val _tmpRleTemplated: Boolean? = entity.rleTemplated
        val _tmp_2: Int? = _tmpRleTemplated?.let { if (it) 1 else 0 }
        if (_tmp_2 == null) {
          statement.bindNull(11)
        } else {
          statement.bindLong(11, _tmp_2.toLong())
        }
        val _tmpRleProperties: String? = entity.rleProperties
        if (_tmpRleProperties == null) {
          statement.bindNull(12)
        } else {
          statement.bindText(12, _tmpRleProperties)
        }
        val _tmpRleHeight: Int? = entity.rleHeight
        if (_tmpRleHeight == null) {
          statement.bindNull(13)
        } else {
          statement.bindLong(13, _tmpRleHeight.toLong())
        }
        val _tmpRleWidth: Int? = entity.rleWidth
        if (_tmpRleWidth == null) {
          statement.bindNull(14)
        } else {
          statement.bindLong(14, _tmpRleWidth.toLong())
        }
        val _tmpRleSize: Int? = entity.rleSize
        if (_tmpRleSize == null) {
          statement.bindNull(15)
        } else {
          statement.bindLong(15, _tmpRleSize.toLong())
        }
        val _tmpRleBitrate: Double? = entity.rleBitrate
        if (_tmpRleBitrate == null) {
          statement.bindNull(16)
        } else {
          statement.bindDouble(16, _tmpRleBitrate)
        }
        val _tmpRleDuration: Double? = entity.rleDuration
        if (_tmpRleDuration == null) {
          statement.bindNull(17)
        } else {
          statement.bindDouble(17, _tmpRleDuration)
        }
        val _tmpRleLanguage: List<String>? = entity.rleLanguage
        val _tmp_3: String? = __sharedConverters.fromStringList(_tmpRleLanguage)
        if (_tmp_3 == null) {
          statement.bindNull(18)
        } else {
          statement.bindText(18, _tmp_3)
        }
      }
    }
  }

  public override suspend fun insertList(entities: List<ReadiumLinkEntity>): Unit = performSuspending(__db, false, true) { _connection ->
    __insertAdapterOfReadiumLinkEntity.insert(_connection, entities)
  }

  public override suspend fun findAllByFeedUid(feedUid: Long): List<ReadiumLinkEntity> {
    val _sql: String = """
        |
        |         WITH 
        |            FeedPublicationUids(publicationUid) AS(
        |             SELECT OpdsPublicationEntity.opeUid
        |               FROM OpdsPublicationEntity
        |              WHERE OpdsPublicationEntity.opeOfeUid = ? 
        |        )
        |         
        |
        |       SELECT ReadiumLinkEntity.*
        |         FROM ReadiumLinkEntity
        |        WHERE 
        |              (     ReadiumLinkEntity.rleOpdsParentType = 1
        |                AND ReadiumLinkEntity.rleOpdsParentUid = ?)
        |          OR  (     ReadiumLinkEntity.rleOpdsParentType = 2
        |                AND ReadiumLinkEntity.rleOpdsParentUid IN (SELECT publicationUid FROM FeedPublicationUids))  
        |        
        |    
        """.trimMargin()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, feedUid)
        _argIndex = 2
        _stmt.bindLong(_argIndex, feedUid)
        val _columnIndexOfRleId: Int = getColumnIndexOrThrow(_stmt, "rleId")
        val _columnIndexOfRleOpdsParentType: Int = getColumnIndexOrThrow(_stmt, "rleOpdsParentType")
        val _columnIndexOfRleOpdsParentUid: Int = getColumnIndexOrThrow(_stmt, "rleOpdsParentUid")
        val _columnIndexOfRlePropType: Int = getColumnIndexOrThrow(_stmt, "rlePropType")
        val _columnIndexOfRlePropFk: Int = getColumnIndexOrThrow(_stmt, "rlePropFk")
        val _columnIndexOfRleIndex: Int = getColumnIndexOrThrow(_stmt, "rleIndex")
        val _columnIndexOfRleHref: Int = getColumnIndexOrThrow(_stmt, "rleHref")
        val _columnIndexOfRleRel: Int = getColumnIndexOrThrow(_stmt, "rleRel")
        val _columnIndexOfRleType: Int = getColumnIndexOrThrow(_stmt, "rleType")
        val _columnIndexOfRleTitle: Int = getColumnIndexOrThrow(_stmt, "rleTitle")
        val _columnIndexOfRleTemplated: Int = getColumnIndexOrThrow(_stmt, "rleTemplated")
        val _columnIndexOfRleProperties: Int = getColumnIndexOrThrow(_stmt, "rleProperties")
        val _columnIndexOfRleHeight: Int = getColumnIndexOrThrow(_stmt, "rleHeight")
        val _columnIndexOfRleWidth: Int = getColumnIndexOrThrow(_stmt, "rleWidth")
        val _columnIndexOfRleSize: Int = getColumnIndexOrThrow(_stmt, "rleSize")
        val _columnIndexOfRleBitrate: Int = getColumnIndexOrThrow(_stmt, "rleBitrate")
        val _columnIndexOfRleDuration: Int = getColumnIndexOrThrow(_stmt, "rleDuration")
        val _columnIndexOfRleLanguage: Int = getColumnIndexOrThrow(_stmt, "rleLanguage")
        val _result: MutableList<ReadiumLinkEntity> = mutableListOf()
        while (_stmt.step()) {
          val _item: ReadiumLinkEntity
          val _tmpRleId: Long
          _tmpRleId = _stmt.getLong(_columnIndexOfRleId)
          val _tmpRleOpdsParentType: OpdsParentType
          val _tmp: Int
          _tmp = _stmt.getLong(_columnIndexOfRleOpdsParentType).toInt()
          _tmpRleOpdsParentType = __opdsTypeConverters.toOpdsTopParentType(_tmp)
          val _tmpRleOpdsParentUid: Long
          _tmpRleOpdsParentUid = _stmt.getLong(_columnIndexOfRleOpdsParentUid)
          val _tmpRlePropType: ReadiumLinkEntity.PropertyType
          _tmpRlePropType = __PropertyType_stringToEnum(_stmt.getText(_columnIndexOfRlePropType))
          val _tmpRlePropFk: Long
          _tmpRlePropFk = _stmt.getLong(_columnIndexOfRlePropFk)
          val _tmpRleIndex: Int
          _tmpRleIndex = _stmt.getLong(_columnIndexOfRleIndex).toInt()
          val _tmpRleHref: String
          _tmpRleHref = _stmt.getText(_columnIndexOfRleHref)
          val _tmpRleRel: List<String>?
          val _tmp_1: String?
          if (_stmt.isNull(_columnIndexOfRleRel)) {
            _tmp_1 = null
          } else {
            _tmp_1 = _stmt.getText(_columnIndexOfRleRel)
          }
          _tmpRleRel = __sharedConverters.toStringList(_tmp_1)
          val _tmpRleType: String?
          if (_stmt.isNull(_columnIndexOfRleType)) {
            _tmpRleType = null
          } else {
            _tmpRleType = _stmt.getText(_columnIndexOfRleType)
          }
          val _tmpRleTitle: String?
          if (_stmt.isNull(_columnIndexOfRleTitle)) {
            _tmpRleTitle = null
          } else {
            _tmpRleTitle = _stmt.getText(_columnIndexOfRleTitle)
          }
          val _tmpRleTemplated: Boolean?
          val _tmp_2: Int?
          if (_stmt.isNull(_columnIndexOfRleTemplated)) {
            _tmp_2 = null
          } else {
            _tmp_2 = _stmt.getLong(_columnIndexOfRleTemplated).toInt()
          }
          _tmpRleTemplated = _tmp_2?.let { it != 0 }
          val _tmpRleProperties: String?
          if (_stmt.isNull(_columnIndexOfRleProperties)) {
            _tmpRleProperties = null
          } else {
            _tmpRleProperties = _stmt.getText(_columnIndexOfRleProperties)
          }
          val _tmpRleHeight: Int?
          if (_stmt.isNull(_columnIndexOfRleHeight)) {
            _tmpRleHeight = null
          } else {
            _tmpRleHeight = _stmt.getLong(_columnIndexOfRleHeight).toInt()
          }
          val _tmpRleWidth: Int?
          if (_stmt.isNull(_columnIndexOfRleWidth)) {
            _tmpRleWidth = null
          } else {
            _tmpRleWidth = _stmt.getLong(_columnIndexOfRleWidth).toInt()
          }
          val _tmpRleSize: Int?
          if (_stmt.isNull(_columnIndexOfRleSize)) {
            _tmpRleSize = null
          } else {
            _tmpRleSize = _stmt.getLong(_columnIndexOfRleSize).toInt()
          }
          val _tmpRleBitrate: Double?
          if (_stmt.isNull(_columnIndexOfRleBitrate)) {
            _tmpRleBitrate = null
          } else {
            _tmpRleBitrate = _stmt.getDouble(_columnIndexOfRleBitrate)
          }
          val _tmpRleDuration: Double?
          if (_stmt.isNull(_columnIndexOfRleDuration)) {
            _tmpRleDuration = null
          } else {
            _tmpRleDuration = _stmt.getDouble(_columnIndexOfRleDuration)
          }
          val _tmpRleLanguage: List<String>?
          val _tmp_3: String?
          if (_stmt.isNull(_columnIndexOfRleLanguage)) {
            _tmp_3 = null
          } else {
            _tmp_3 = _stmt.getText(_columnIndexOfRleLanguage)
          }
          _tmpRleLanguage = __sharedConverters.toStringList(_tmp_3)
          _item = ReadiumLinkEntity(_tmpRleId,_tmpRleOpdsParentType,_tmpRleOpdsParentUid,_tmpRlePropType,_tmpRlePropFk,_tmpRleIndex,_tmpRleHref,_tmpRleRel,_tmpRleType,_tmpRleTitle,_tmpRleTemplated,_tmpRleProperties,_tmpRleHeight,_tmpRleWidth,_tmpRleSize,_tmpRleBitrate,_tmpRleDuration,_tmpRleLanguage)
          _result.add(_item)
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun findAllByPubUid(publicationUid: Long): List<ReadiumLinkEntity> {
    val _sql: String = """
        |
        |        SELECT ReadiumLinkEntity.*
        |          FROM ReadiumLinkEntity
        |         WHERE ReadiumLinkEntity.rleOpdsParentType = 2
        |           AND ReadiumLinkEntity.rleOpdsParentUid = ?
        |    
        """.trimMargin()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, publicationUid)
        val _columnIndexOfRleId: Int = getColumnIndexOrThrow(_stmt, "rleId")
        val _columnIndexOfRleOpdsParentType: Int = getColumnIndexOrThrow(_stmt, "rleOpdsParentType")
        val _columnIndexOfRleOpdsParentUid: Int = getColumnIndexOrThrow(_stmt, "rleOpdsParentUid")
        val _columnIndexOfRlePropType: Int = getColumnIndexOrThrow(_stmt, "rlePropType")
        val _columnIndexOfRlePropFk: Int = getColumnIndexOrThrow(_stmt, "rlePropFk")
        val _columnIndexOfRleIndex: Int = getColumnIndexOrThrow(_stmt, "rleIndex")
        val _columnIndexOfRleHref: Int = getColumnIndexOrThrow(_stmt, "rleHref")
        val _columnIndexOfRleRel: Int = getColumnIndexOrThrow(_stmt, "rleRel")
        val _columnIndexOfRleType: Int = getColumnIndexOrThrow(_stmt, "rleType")
        val _columnIndexOfRleTitle: Int = getColumnIndexOrThrow(_stmt, "rleTitle")
        val _columnIndexOfRleTemplated: Int = getColumnIndexOrThrow(_stmt, "rleTemplated")
        val _columnIndexOfRleProperties: Int = getColumnIndexOrThrow(_stmt, "rleProperties")
        val _columnIndexOfRleHeight: Int = getColumnIndexOrThrow(_stmt, "rleHeight")
        val _columnIndexOfRleWidth: Int = getColumnIndexOrThrow(_stmt, "rleWidth")
        val _columnIndexOfRleSize: Int = getColumnIndexOrThrow(_stmt, "rleSize")
        val _columnIndexOfRleBitrate: Int = getColumnIndexOrThrow(_stmt, "rleBitrate")
        val _columnIndexOfRleDuration: Int = getColumnIndexOrThrow(_stmt, "rleDuration")
        val _columnIndexOfRleLanguage: Int = getColumnIndexOrThrow(_stmt, "rleLanguage")
        val _result: MutableList<ReadiumLinkEntity> = mutableListOf()
        while (_stmt.step()) {
          val _item: ReadiumLinkEntity
          val _tmpRleId: Long
          _tmpRleId = _stmt.getLong(_columnIndexOfRleId)
          val _tmpRleOpdsParentType: OpdsParentType
          val _tmp: Int
          _tmp = _stmt.getLong(_columnIndexOfRleOpdsParentType).toInt()
          _tmpRleOpdsParentType = __opdsTypeConverters.toOpdsTopParentType(_tmp)
          val _tmpRleOpdsParentUid: Long
          _tmpRleOpdsParentUid = _stmt.getLong(_columnIndexOfRleOpdsParentUid)
          val _tmpRlePropType: ReadiumLinkEntity.PropertyType
          _tmpRlePropType = __PropertyType_stringToEnum(_stmt.getText(_columnIndexOfRlePropType))
          val _tmpRlePropFk: Long
          _tmpRlePropFk = _stmt.getLong(_columnIndexOfRlePropFk)
          val _tmpRleIndex: Int
          _tmpRleIndex = _stmt.getLong(_columnIndexOfRleIndex).toInt()
          val _tmpRleHref: String
          _tmpRleHref = _stmt.getText(_columnIndexOfRleHref)
          val _tmpRleRel: List<String>?
          val _tmp_1: String?
          if (_stmt.isNull(_columnIndexOfRleRel)) {
            _tmp_1 = null
          } else {
            _tmp_1 = _stmt.getText(_columnIndexOfRleRel)
          }
          _tmpRleRel = __sharedConverters.toStringList(_tmp_1)
          val _tmpRleType: String?
          if (_stmt.isNull(_columnIndexOfRleType)) {
            _tmpRleType = null
          } else {
            _tmpRleType = _stmt.getText(_columnIndexOfRleType)
          }
          val _tmpRleTitle: String?
          if (_stmt.isNull(_columnIndexOfRleTitle)) {
            _tmpRleTitle = null
          } else {
            _tmpRleTitle = _stmt.getText(_columnIndexOfRleTitle)
          }
          val _tmpRleTemplated: Boolean?
          val _tmp_2: Int?
          if (_stmt.isNull(_columnIndexOfRleTemplated)) {
            _tmp_2 = null
          } else {
            _tmp_2 = _stmt.getLong(_columnIndexOfRleTemplated).toInt()
          }
          _tmpRleTemplated = _tmp_2?.let { it != 0 }
          val _tmpRleProperties: String?
          if (_stmt.isNull(_columnIndexOfRleProperties)) {
            _tmpRleProperties = null
          } else {
            _tmpRleProperties = _stmt.getText(_columnIndexOfRleProperties)
          }
          val _tmpRleHeight: Int?
          if (_stmt.isNull(_columnIndexOfRleHeight)) {
            _tmpRleHeight = null
          } else {
            _tmpRleHeight = _stmt.getLong(_columnIndexOfRleHeight).toInt()
          }
          val _tmpRleWidth: Int?
          if (_stmt.isNull(_columnIndexOfRleWidth)) {
            _tmpRleWidth = null
          } else {
            _tmpRleWidth = _stmt.getLong(_columnIndexOfRleWidth).toInt()
          }
          val _tmpRleSize: Int?
          if (_stmt.isNull(_columnIndexOfRleSize)) {
            _tmpRleSize = null
          } else {
            _tmpRleSize = _stmt.getLong(_columnIndexOfRleSize).toInt()
          }
          val _tmpRleBitrate: Double?
          if (_stmt.isNull(_columnIndexOfRleBitrate)) {
            _tmpRleBitrate = null
          } else {
            _tmpRleBitrate = _stmt.getDouble(_columnIndexOfRleBitrate)
          }
          val _tmpRleDuration: Double?
          if (_stmt.isNull(_columnIndexOfRleDuration)) {
            _tmpRleDuration = null
          } else {
            _tmpRleDuration = _stmt.getDouble(_columnIndexOfRleDuration)
          }
          val _tmpRleLanguage: List<String>?
          val _tmp_3: String?
          if (_stmt.isNull(_columnIndexOfRleLanguage)) {
            _tmp_3 = null
          } else {
            _tmp_3 = _stmt.getText(_columnIndexOfRleLanguage)
          }
          _tmpRleLanguage = __sharedConverters.toStringList(_tmp_3)
          _item = ReadiumLinkEntity(_tmpRleId,_tmpRleOpdsParentType,_tmpRleOpdsParentUid,_tmpRlePropType,_tmpRlePropFk,_tmpRleIndex,_tmpRleHref,_tmpRleRel,_tmpRleType,_tmpRleTitle,_tmpRleTemplated,_tmpRleProperties,_tmpRleHeight,_tmpRleWidth,_tmpRleSize,_tmpRleBitrate,_tmpRleDuration,_tmpRleLanguage)
          _result.add(_item)
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun deleteAllByFeedUid(feedUid: Long) {
    val _sql: String = """
        |
        |        WITH 
        |            FeedPublicationUids(publicationUid) AS(
        |             SELECT OpdsPublicationEntity.opeUid
        |               FROM OpdsPublicationEntity
        |              WHERE OpdsPublicationEntity.opeOfeUid = ? 
        |        )
        |         
        |        
        |       DELETE
        |         FROM ReadiumLinkEntity
        |        WHERE 
        |              (     ReadiumLinkEntity.rleOpdsParentType = 1
        |                AND ReadiumLinkEntity.rleOpdsParentUid = ?)
        |          OR  (     ReadiumLinkEntity.rleOpdsParentType = 2
        |                AND ReadiumLinkEntity.rleOpdsParentUid IN (SELECT publicationUid FROM FeedPublicationUids))  
        |        
        |    
        """.trimMargin()
    return performSuspending(__db, false, true) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, feedUid)
        _argIndex = 2
        _stmt.bindLong(_argIndex, feedUid)
        _stmt.step()
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun deleteAllByPublicationUid(publicationUid: Long) {
    val _sql: String = """
        | 
        |       DELETE
        |         FROM ReadiumLinkEntity
        |        WHERE ReadiumLinkEntity.rleOpdsParentUid = ?
        |          AND ReadiumLinkEntity.rleOpdsParentType = 2
        |    
        """.trimMargin()
    return performSuspending(__db, false, true) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, publicationUid)
        _stmt.step()
      } finally {
        _stmt.close()
      }
    }
  }

  private fun __PropertyType_enumToString(_value: ReadiumLinkEntity.PropertyType): String = when (_value) {
    ReadiumLinkEntity.PropertyType.LINK_ALTERNATE -> "LINK_ALTERNATE"
    ReadiumLinkEntity.PropertyType.LINK_CHILDREN -> "LINK_CHILDREN"
    ReadiumLinkEntity.PropertyType.LINK_SUB_COLLECTION -> "LINK_SUB_COLLECTION"
    ReadiumLinkEntity.PropertyType.OPDS_PUB_LINKS -> "OPDS_PUB_LINKS"
    ReadiumLinkEntity.PropertyType.OPDS_PUB_IMAGES -> "OPDS_PUB_IMAGES"
    ReadiumLinkEntity.PropertyType.OPDS_PUB_READING_ORDER -> "OPDS_PUB_READING_ORDER"
    ReadiumLinkEntity.PropertyType.OPDS_PUB_RESOURCES -> "OPDS_PUB_RESOURCES"
    ReadiumLinkEntity.PropertyType.OPDS_PUB_TOC -> "OPDS_PUB_TOC"
    ReadiumLinkEntity.PropertyType.OPDS_PUB_SUBJECT_LINKS -> "OPDS_PUB_SUBJECT_LINKS"
    ReadiumLinkEntity.PropertyType.OPDS_FACET_LINKS -> "OPDS_FACET_LINKS"
    ReadiumLinkEntity.PropertyType.OPDS_GROUP_LINKS -> "OPDS_GROUP_LINKS"
    ReadiumLinkEntity.PropertyType.OPDS_GROUP_NAVIGATION -> "OPDS_GROUP_NAVIGATION"
    ReadiumLinkEntity.PropertyType.OPDS_FEED_LINKS -> "OPDS_FEED_LINKS"
    ReadiumLinkEntity.PropertyType.OPDS_FEED_NAVIGATION -> "OPDS_FEED_NAVIGATION"
    ReadiumLinkEntity.PropertyType.READIUM_CONTRIBUTOR -> "READIUM_CONTRIBUTOR"
    ReadiumLinkEntity.PropertyType.READIUM_SUBJECT_LINKS -> "READIUM_SUBJECT_LINKS"
  }

  private fun __PropertyType_stringToEnum(_value: String): ReadiumLinkEntity.PropertyType = when (_value) {
    "LINK_ALTERNATE" -> ReadiumLinkEntity.PropertyType.LINK_ALTERNATE
    "LINK_CHILDREN" -> ReadiumLinkEntity.PropertyType.LINK_CHILDREN
    "LINK_SUB_COLLECTION" -> ReadiumLinkEntity.PropertyType.LINK_SUB_COLLECTION
    "OPDS_PUB_LINKS" -> ReadiumLinkEntity.PropertyType.OPDS_PUB_LINKS
    "OPDS_PUB_IMAGES" -> ReadiumLinkEntity.PropertyType.OPDS_PUB_IMAGES
    "OPDS_PUB_READING_ORDER" -> ReadiumLinkEntity.PropertyType.OPDS_PUB_READING_ORDER
    "OPDS_PUB_RESOURCES" -> ReadiumLinkEntity.PropertyType.OPDS_PUB_RESOURCES
    "OPDS_PUB_TOC" -> ReadiumLinkEntity.PropertyType.OPDS_PUB_TOC
    "OPDS_PUB_SUBJECT_LINKS" -> ReadiumLinkEntity.PropertyType.OPDS_PUB_SUBJECT_LINKS
    "OPDS_FACET_LINKS" -> ReadiumLinkEntity.PropertyType.OPDS_FACET_LINKS
    "OPDS_GROUP_LINKS" -> ReadiumLinkEntity.PropertyType.OPDS_GROUP_LINKS
    "OPDS_GROUP_NAVIGATION" -> ReadiumLinkEntity.PropertyType.OPDS_GROUP_NAVIGATION
    "OPDS_FEED_LINKS" -> ReadiumLinkEntity.PropertyType.OPDS_FEED_LINKS
    "OPDS_FEED_NAVIGATION" -> ReadiumLinkEntity.PropertyType.OPDS_FEED_NAVIGATION
    "READIUM_CONTRIBUTOR" -> ReadiumLinkEntity.PropertyType.READIUM_CONTRIBUTOR
    "READIUM_SUBJECT_LINKS" -> ReadiumLinkEntity.PropertyType.READIUM_SUBJECT_LINKS
    else -> throw IllegalArgumentException("Can't convert value to enum, unknown value: " + _value)
  }

  public companion object {
    public fun getRequiredConverters(): List<KClass<*>> = emptyList()
  }
}
