/*
 * Decompiled with CFR 0.152.
 */
package androidx.collection;

import androidx.collection.CollectionPlatformUtils;
import androidx.collection.SparseArrayCompatKt;
import androidx.collection.internal.ContainerHelpersKt;
import java.util.Arrays;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001a\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u001f\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0016\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0011\b\u0007\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001d\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0016J\b\u0010\u0017\u001a\u00020\u0013H\u0016J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000H\u0016J\u0010\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0004H\u0016J\u0015\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001bJ\u0010\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0004H\u0017J\u0018\u0010\u001d\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0014\u001a\u00020\u0004H\u0096\u0002\u00a2\u0006\u0002\u0010\u001eJ\u001d\u0010\u001d\u001a\u00028\u00002\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010 J\u0010\u0010!\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0004H\u0016J\u0015\u0010\"\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010#J\b\u0010\b\u001a\u00020\u0007H\u0016J\u0010\u0010$\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u0004H\u0016J\u001d\u0010&\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0016J\u0018\u0010'\u001a\u00020\u00132\u000e\u0010(\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u0000H\u0016J\u001f\u0010)\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010 J\u0010\u0010*\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0004H\u0016J\u001a\u0010*\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00042\b\u0010\u0015\u001a\u0004\u0018\u00010\u0010H\u0016J\u0010\u0010+\u001a\u00020\u00132\u0006\u0010%\u001a\u00020\u0004H\u0016J\u0018\u0010,\u001a\u00020\u00132\u0006\u0010%\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004H\u0016J\u001f\u0010-\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010 J%\u0010-\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010.\u001a\u00028\u00002\u0006\u0010/\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u00100J\u001d\u00101\u001a\u00020\u00132\u0006\u0010%\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0016J\b\u0010\r\u001a\u00020\u0004H\u0016J\b\u00102\u001a\u000203H\u0016J\u0015\u00104\u001a\u00028\u00002\u0006\u0010%\u001a\u00020\u0004H\u0016\u00a2\u0006\u0002\u0010\u001eR\u0012\u0010\u0006\u001a\u00020\u00078\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\u00078G\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u00020\f8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u00020\u00048\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000f8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0011\u00a8\u00065"}, d2={"Landroidx/collection/SparseArrayCompat;", "E", "", "initialCapacity", "", "(I)V", "garbage", "", "isEmpty", "getIsEmpty", "()Z", "keys", "", "size", "values", "", "", "[Ljava/lang/Object;", "append", "", "key", "value", "(ILjava/lang/Object;)V", "clear", "clone", "containsKey", "containsValue", "(Ljava/lang/Object;)Z", "delete", "get", "(I)Ljava/lang/Object;", "defaultValue", "(ILjava/lang/Object;)Ljava/lang/Object;", "indexOfKey", "indexOfValue", "(Ljava/lang/Object;)I", "keyAt", "index", "put", "putAll", "other", "putIfAbsent", "remove", "removeAt", "removeAtRange", "replace", "oldValue", "newValue", "(ILjava/lang/Object;Ljava/lang/Object;)Z", "setValueAt", "toString", "", "valueAt", "collection"})
@SourceDebugExtension(value={"SMAP\nSparseArrayCompat.jvm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SparseArrayCompat.jvm.kt\nandroidx/collection/SparseArrayCompat\n+ 2 SparseArrayCompat.kt\nandroidx/collection/SparseArrayCompatKt\n+ 3 CollectionPlatformUtils.jvm.kt\nandroidx/collection/CollectionPlatformUtils\n*L\n1#1,263:1\n250#2,9:264\n263#2,5:273\n271#2,5:278\n279#2,7:283\n294#2,9:290\n327#2,30:299\n360#2,2:329\n327#2,37:331\n367#2,3:368\n327#2,30:371\n371#2:401\n376#2,4:402\n383#2:406\n387#2,4:407\n395#2,5:411\n401#2:417\n406#2,5:418\n414#2,4:423\n422#2,9:427\n435#2:436\n440#2:437\n422#2,9:438\n445#2,8:447\n456#2,17:455\n476#2,21:472\n24#3:416\n*S KotlinDebug\n*F\n+ 1 SparseArrayCompat.jvm.kt\nandroidx/collection/SparseArrayCompat\n*L\n123#1:264,9\n126#1:273,5\n135#1:278,5\n144#1:283,7\n155#1:290,9\n161#1:299,30\n168#1:329,2\n168#1:331,37\n179#1:368,3\n179#1:371,30\n179#1:401\n182#1:402,4\n198#1:406\n204#1:407,4\n210#1:411,5\n210#1:417\n216#1:418,5\n226#1:423,4\n238#1:427,9\n241#1:436\n244#1:437\n244#1:438,9\n247#1:447,8\n253#1:455,17\n261#1:472,21\n210#1:416\n*E\n"})
public class SparseArrayCompat<E>
implements Cloneable {
    @JvmField
    public /* synthetic */ boolean garbage;
    @JvmField
    public /* synthetic */ int[] keys;
    @JvmField
    public /* synthetic */ Object[] values;
    @JvmField
    public /* synthetic */ int size;

    @JvmOverloads
    public SparseArrayCompat(int initialCapacity) {
        if (initialCapacity == 0) {
            this.keys = ContainerHelpersKt.EMPTY_INTS;
            this.values = ContainerHelpersKt.EMPTY_OBJECTS;
        } else {
            int capacity = ContainerHelpersKt.idealIntArraySize(initialCapacity);
            this.keys = new int[capacity];
            this.values = new Object[capacity];
        }
    }

    public /* synthetic */ SparseArrayCompat(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 10;
        }
        this(n);
    }

    @NotNull
    public SparseArrayCompat<E> clone() {
        Object object = super.clone();
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type androidx.collection.SparseArrayCompat<E of androidx.collection.SparseArrayCompat>");
        SparseArrayCompat clone = (SparseArrayCompat)object;
        clone.keys = (int[])this.keys.clone();
        clone.values = (Object[])this.values.clone();
        return clone;
    }

    @Nullable
    public E get(int key) {
        return SparseArrayCompatKt.commonGet(this, key);
    }

    public E get(int key, E defaultValue) {
        return SparseArrayCompatKt.commonGet(this, key, defaultValue);
    }

    @Deprecated(message="Alias for remove(int).", replaceWith=@ReplaceWith(expression="remove(key)", imports={}))
    public void delete(int key) {
        this.remove(key);
    }

    public void remove(int key) {
        SparseArrayCompatKt.commonRemove(this, key);
    }

    public boolean remove(int key, @Nullable Object value) {
        boolean bl;
        E mapValue$iv;
        SparseArrayCompat $this$commonRemove$iv = this;
        boolean $i$f$commonRemove = false;
        int index$iv = $this$commonRemove$iv.indexOfKey(key);
        if (index$iv >= 0 && Intrinsics.areEqual(value, mapValue$iv = $this$commonRemove$iv.valueAt(index$iv))) {
            $this$commonRemove$iv.removeAt(index$iv);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public void removeAt(int index2) {
        SparseArrayCompat $this$commonRemoveAt$iv = this;
        boolean $i$f$commonRemoveAt = false;
        if ($this$commonRemoveAt$iv.values[index2] != SparseArrayCompatKt.access$getDELETED$p()) {
            $this$commonRemoveAt$iv.values[index2] = SparseArrayCompatKt.access$getDELETED$p();
            $this$commonRemoveAt$iv.garbage = true;
        }
    }

    public void removeAtRange(int index2, int size2) {
        SparseArrayCompat $this$commonRemoveAtRange$iv = this;
        boolean $i$f$commonRemoveAtRange = false;
        int end$iv = Math.min(size2, index2 + size2);
        for (int i$iv = index2; i$iv < end$iv; ++i$iv) {
            $this$commonRemoveAtRange$iv.removeAt(i$iv);
        }
    }

    @Nullable
    public E replace(int key, E value) {
        Object object;
        SparseArrayCompat $this$commonReplace$iv = this;
        boolean $i$f$commonReplace = false;
        int index$iv = $this$commonReplace$iv.indexOfKey(key);
        if (index$iv >= 0) {
            Object oldValue$iv = $this$commonReplace$iv.values[index$iv];
            $this$commonReplace$iv.values[index$iv] = value;
            object = oldValue$iv;
        } else {
            object = null;
        }
        return (E)object;
    }

    public boolean replace(int key, E oldValue, E newValue) {
        boolean bl;
        Object mapValue$iv;
        SparseArrayCompat $this$commonReplace$iv = this;
        boolean $i$f$commonReplace = false;
        int index$iv = $this$commonReplace$iv.indexOfKey(key);
        if (index$iv >= 0 && Intrinsics.areEqual(mapValue$iv = $this$commonReplace$iv.values[index$iv], oldValue)) {
            $this$commonReplace$iv.values[index$iv] = newValue;
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public void put(int key, E value) {
        SparseArrayCompat $this$commonPut$iv = this;
        boolean $i$f$commonPut = false;
        int i$iv = ContainerHelpersKt.binarySearch($this$commonPut$iv.keys, $this$commonPut$iv.size, key);
        if (i$iv >= 0) {
            $this$commonPut$iv.values[i$iv] = value;
        } else if ((i$iv ^= 0xFFFFFFFF) < $this$commonPut$iv.size && $this$commonPut$iv.values[i$iv] == SparseArrayCompatKt.access$getDELETED$p()) {
            $this$commonPut$iv.keys[i$iv] = key;
            $this$commonPut$iv.values[i$iv] = value;
        } else {
            if ($this$commonPut$iv.garbage && $this$commonPut$iv.size >= $this$commonPut$iv.keys.length) {
                SparseArrayCompatKt.access$gc($this$commonPut$iv);
                i$iv = ~ContainerHelpersKt.binarySearch($this$commonPut$iv.keys, $this$commonPut$iv.size, key);
            }
            if ($this$commonPut$iv.size >= $this$commonPut$iv.keys.length) {
                int n$iv = ContainerHelpersKt.idealIntArraySize($this$commonPut$iv.size + 1);
                int[] nArray = Arrays.copyOf($this$commonPut$iv.keys, n$iv);
                Intrinsics.checkNotNullExpressionValue(nArray, "copyOf(...)");
                $this$commonPut$iv.keys = nArray;
                Object[] objectArray = Arrays.copyOf($this$commonPut$iv.values, n$iv);
                Intrinsics.checkNotNullExpressionValue(objectArray, "copyOf(...)");
                $this$commonPut$iv.values = objectArray;
            }
            if ($this$commonPut$iv.size - i$iv != 0) {
                ArraysKt.copyInto($this$commonPut$iv.keys, $this$commonPut$iv.keys, i$iv + 1, i$iv, $this$commonPut$iv.size);
                ArraysKt.copyInto($this$commonPut$iv.values, $this$commonPut$iv.values, i$iv + 1, i$iv, $this$commonPut$iv.size);
            }
            $this$commonPut$iv.keys[i$iv] = key;
            $this$commonPut$iv.values[i$iv] = value;
            int n = $this$commonPut$iv.size;
            $this$commonPut$iv.size = n + 1;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void putAll(@NotNull SparseArrayCompat<? extends E> other) {
        Intrinsics.checkNotNullParameter(other, "other");
        SparseArrayCompat $this$commonPutAll$iv = this;
        boolean $i$f$commonPutAll = false;
        int n = other.size();
        for (int i$iv = 0; i$iv < n; ++i$iv) {
            void key$iv$iv;
            void $this$commonPut$iv$iv;
            SparseArrayCompat sparseArrayCompat = $this$commonPutAll$iv;
            int n2 = other.keyAt(i$iv);
            E value$iv$iv = other.valueAt(i$iv);
            boolean $i$f$commonPut = false;
            int i$iv$iv = ContainerHelpersKt.binarySearch($this$commonPut$iv$iv.keys, $this$commonPut$iv$iv.size, (int)key$iv$iv);
            if (i$iv$iv >= 0) {
                $this$commonPut$iv$iv.values[i$iv$iv] = value$iv$iv;
                continue;
            }
            if ((i$iv$iv ^= 0xFFFFFFFF) < $this$commonPut$iv$iv.size && $this$commonPut$iv$iv.values[i$iv$iv] == SparseArrayCompatKt.access$getDELETED$p()) {
                $this$commonPut$iv$iv.keys[i$iv$iv] = key$iv$iv;
                $this$commonPut$iv$iv.values[i$iv$iv] = value$iv$iv;
                continue;
            }
            if ($this$commonPut$iv$iv.garbage && $this$commonPut$iv$iv.size >= $this$commonPut$iv$iv.keys.length) {
                SparseArrayCompatKt.access$gc((SparseArrayCompat)$this$commonPut$iv$iv);
                i$iv$iv = ~ContainerHelpersKt.binarySearch($this$commonPut$iv$iv.keys, $this$commonPut$iv$iv.size, (int)key$iv$iv);
            }
            if ($this$commonPut$iv$iv.size >= $this$commonPut$iv$iv.keys.length) {
                int n$iv$iv = ContainerHelpersKt.idealIntArraySize($this$commonPut$iv$iv.size + 1);
                Intrinsics.checkNotNullExpressionValue(Arrays.copyOf($this$commonPut$iv$iv.keys, n$iv$iv), "copyOf(...)");
                $this$commonPut$iv$iv.keys = $this$commonPut$iv$iv.keys;
                Intrinsics.checkNotNullExpressionValue(Arrays.copyOf($this$commonPut$iv$iv.values, n$iv$iv), "copyOf(...)");
                $this$commonPut$iv$iv.values = $this$commonPut$iv$iv.values;
            }
            if ($this$commonPut$iv$iv.size - i$iv$iv != 0) {
                ArraysKt.copyInto($this$commonPut$iv$iv.keys, $this$commonPut$iv$iv.keys, i$iv$iv + 1, i$iv$iv, $this$commonPut$iv$iv.size);
                ArraysKt.copyInto($this$commonPut$iv$iv.values, $this$commonPut$iv$iv.values, i$iv$iv + 1, i$iv$iv, $this$commonPut$iv$iv.size);
            }
            $this$commonPut$iv$iv.keys[i$iv$iv] = key$iv$iv;
            $this$commonPut$iv$iv.values[i$iv$iv] = value$iv$iv;
            int n3 = $this$commonPut$iv$iv.size;
            $this$commonPut$iv$iv.size = n3 + 1;
        }
    }

    @Nullable
    public E putIfAbsent(int key, E value) {
        SparseArrayCompat $this$commonPutIfAbsent$iv = this;
        boolean $i$f$commonPutIfAbsent = false;
        Object mapValue$iv = SparseArrayCompatKt.commonGet($this$commonPutIfAbsent$iv, key);
        if (mapValue$iv == null) {
            SparseArrayCompat $this$commonPut$iv$iv = $this$commonPutIfAbsent$iv;
            boolean $i$f$commonPut = false;
            int i$iv$iv = ContainerHelpersKt.binarySearch($this$commonPut$iv$iv.keys, $this$commonPut$iv$iv.size, key);
            if (i$iv$iv >= 0) {
                $this$commonPut$iv$iv.values[i$iv$iv] = value;
            } else if ((i$iv$iv ^= 0xFFFFFFFF) < $this$commonPut$iv$iv.size && $this$commonPut$iv$iv.values[i$iv$iv] == SparseArrayCompatKt.access$getDELETED$p()) {
                $this$commonPut$iv$iv.keys[i$iv$iv] = key;
                $this$commonPut$iv$iv.values[i$iv$iv] = value;
            } else {
                if ($this$commonPut$iv$iv.garbage && $this$commonPut$iv$iv.size >= $this$commonPut$iv$iv.keys.length) {
                    SparseArrayCompatKt.access$gc($this$commonPut$iv$iv);
                    i$iv$iv = ~ContainerHelpersKt.binarySearch($this$commonPut$iv$iv.keys, $this$commonPut$iv$iv.size, key);
                }
                if ($this$commonPut$iv$iv.size >= $this$commonPut$iv$iv.keys.length) {
                    int n$iv$iv = ContainerHelpersKt.idealIntArraySize($this$commonPut$iv$iv.size + 1);
                    int[] nArray = Arrays.copyOf($this$commonPut$iv$iv.keys, n$iv$iv);
                    Intrinsics.checkNotNullExpressionValue(nArray, "copyOf(...)");
                    $this$commonPut$iv$iv.keys = nArray;
                    Object[] objectArray = Arrays.copyOf($this$commonPut$iv$iv.values, n$iv$iv);
                    Intrinsics.checkNotNullExpressionValue(objectArray, "copyOf(...)");
                    $this$commonPut$iv$iv.values = objectArray;
                }
                if ($this$commonPut$iv$iv.size - i$iv$iv != 0) {
                    ArraysKt.copyInto($this$commonPut$iv$iv.keys, $this$commonPut$iv$iv.keys, i$iv$iv + 1, i$iv$iv, $this$commonPut$iv$iv.size);
                    ArraysKt.copyInto($this$commonPut$iv$iv.values, $this$commonPut$iv$iv.values, i$iv$iv + 1, i$iv$iv, $this$commonPut$iv$iv.size);
                }
                $this$commonPut$iv$iv.keys[i$iv$iv] = key;
                $this$commonPut$iv$iv.values[i$iv$iv] = value;
                int n = $this$commonPut$iv$iv.size;
                $this$commonPut$iv$iv.size = n + 1;
            }
        }
        return mapValue$iv;
    }

    public int size() {
        SparseArrayCompat $this$commonSize$iv = this;
        boolean $i$f$commonSize = false;
        if ($this$commonSize$iv.garbage) {
            SparseArrayCompatKt.access$gc($this$commonSize$iv);
        }
        return $this$commonSize$iv.size;
    }

    @JvmName(name="getIsEmpty")
    public final boolean getIsEmpty() {
        return this.isEmpty();
    }

    public boolean isEmpty() {
        SparseArrayCompat $this$commonIsEmpty$iv = this;
        boolean $i$f$commonIsEmpty = false;
        return $this$commonIsEmpty$iv.size() == 0;
    }

    public int keyAt(int index2) {
        SparseArrayCompat $this$commonKeyAt$iv = this;
        boolean $i$f$commonKeyAt = false;
        if ($this$commonKeyAt$iv.garbage) {
            SparseArrayCompatKt.access$gc($this$commonKeyAt$iv);
        }
        return $this$commonKeyAt$iv.keys[index2];
    }

    public E valueAt(int index2) {
        SparseArrayCompat $this$commonValueAt$iv = this;
        boolean $i$f$commonValueAt = false;
        if ($this$commonValueAt$iv.garbage) {
            SparseArrayCompatKt.access$gc($this$commonValueAt$iv);
        }
        if (index2 >= $this$commonValueAt$iv.values.length) {
            CollectionPlatformUtils this_$iv$iv = CollectionPlatformUtils.INSTANCE;
            boolean $i$f$createIndexOutOfBoundsException$collection = false;
            throw (IndexOutOfBoundsException)new ArrayIndexOutOfBoundsException();
        }
        return (E)$this$commonValueAt$iv.values[index2];
    }

    public void setValueAt(int index2, E value) {
        SparseArrayCompat $this$commonSetValueAt$iv = this;
        boolean $i$f$commonSetValueAt = false;
        if ($this$commonSetValueAt$iv.garbage) {
            SparseArrayCompatKt.access$gc($this$commonSetValueAt$iv);
        }
        $this$commonSetValueAt$iv.values[index2] = value;
    }

    public int indexOfKey(int key) {
        SparseArrayCompat $this$commonIndexOfKey$iv = this;
        boolean $i$f$commonIndexOfKey = false;
        if ($this$commonIndexOfKey$iv.garbage) {
            SparseArrayCompatKt.access$gc($this$commonIndexOfKey$iv);
        }
        return ContainerHelpersKt.binarySearch($this$commonIndexOfKey$iv.keys, $this$commonIndexOfKey$iv.size, key);
    }

    public int indexOfValue(E value) {
        int n;
        block2: {
            SparseArrayCompat $this$commonIndexOfValue$iv = this;
            boolean $i$f$commonIndexOfValue = false;
            if ($this$commonIndexOfValue$iv.garbage) {
                SparseArrayCompatKt.access$gc($this$commonIndexOfValue$iv);
            }
            int n2 = $this$commonIndexOfValue$iv.size;
            for (int i$iv = 0; i$iv < n2; ++i$iv) {
                if ($this$commonIndexOfValue$iv.values[i$iv] != value) continue;
                n = i$iv;
                break block2;
            }
            n = -1;
        }
        return n;
    }

    public boolean containsKey(int key) {
        SparseArrayCompat $this$commonContainsKey$iv = this;
        boolean $i$f$commonContainsKey = false;
        return $this$commonContainsKey$iv.indexOfKey(key) >= 0;
    }

    public boolean containsValue(E value) {
        int n;
        block2: {
            SparseArrayCompat $this$commonContainsValue$iv = this;
            boolean $i$f$commonContainsValue = false;
            SparseArrayCompat $this$commonIndexOfValue$iv$iv = $this$commonContainsValue$iv;
            boolean $i$f$commonIndexOfValue = false;
            if ($this$commonIndexOfValue$iv$iv.garbage) {
                SparseArrayCompatKt.access$gc($this$commonIndexOfValue$iv$iv);
            }
            int n2 = $this$commonIndexOfValue$iv$iv.size;
            for (int i$iv$iv = 0; i$iv$iv < n2; ++i$iv$iv) {
                if ($this$commonIndexOfValue$iv$iv.values[i$iv$iv] != value) continue;
                n = i$iv$iv;
                break block2;
            }
            n = -1;
        }
        return n >= 0;
    }

    public void clear() {
        SparseArrayCompat $this$commonClear$iv = this;
        boolean $i$f$commonClear = false;
        int n$iv = $this$commonClear$iv.size;
        Object[] values$iv = $this$commonClear$iv.values;
        for (int i$iv = 0; i$iv < n$iv; ++i$iv) {
            values$iv[i$iv] = null;
        }
        $this$commonClear$iv.size = 0;
        $this$commonClear$iv.garbage = false;
    }

    public void append(int key, E value) {
        SparseArrayCompat $this$commonAppend$iv = this;
        boolean $i$f$commonAppend = false;
        if ($this$commonAppend$iv.size != 0 && key <= $this$commonAppend$iv.keys[$this$commonAppend$iv.size - 1]) {
            $this$commonAppend$iv.put(key, value);
        } else {
            int pos$iv;
            if ($this$commonAppend$iv.garbage && $this$commonAppend$iv.size >= $this$commonAppend$iv.keys.length) {
                SparseArrayCompatKt.access$gc($this$commonAppend$iv);
            }
            if ((pos$iv = $this$commonAppend$iv.size) >= $this$commonAppend$iv.keys.length) {
                int n$iv = ContainerHelpersKt.idealIntArraySize(pos$iv + 1);
                int[] nArray = Arrays.copyOf($this$commonAppend$iv.keys, n$iv);
                Intrinsics.checkNotNullExpressionValue(nArray, "copyOf(...)");
                $this$commonAppend$iv.keys = nArray;
                Object[] objectArray = Arrays.copyOf($this$commonAppend$iv.values, n$iv);
                Intrinsics.checkNotNullExpressionValue(objectArray, "copyOf(...)");
                $this$commonAppend$iv.values = objectArray;
            }
            $this$commonAppend$iv.keys[pos$iv] = key;
            $this$commonAppend$iv.values[pos$iv] = value;
            $this$commonAppend$iv.size = pos$iv + 1;
        }
    }

    @NotNull
    public String toString() {
        String string2;
        SparseArrayCompat $this$commonToString$iv = this;
        boolean $i$f$commonToString = false;
        if ($this$commonToString$iv.size() <= 0) {
            string2 = "{}";
        } else {
            StringBuilder buffer$iv = new StringBuilder($this$commonToString$iv.size * 28);
            buffer$iv.append('{');
            int n = $this$commonToString$iv.size;
            for (int i$iv = 0; i$iv < n; ++i$iv) {
                if (i$iv > 0) {
                    buffer$iv.append(", ");
                }
                int key$iv = $this$commonToString$iv.keyAt(i$iv);
                buffer$iv.append(key$iv);
                buffer$iv.append('=');
                E value$iv = $this$commonToString$iv.valueAt(i$iv);
                if (value$iv != $this$commonToString$iv) {
                    buffer$iv.append(value$iv);
                    continue;
                }
                buffer$iv.append("(this Map)");
            }
            buffer$iv.append('}');
            String string3 = buffer$iv.toString();
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue(string3, "toString(...)");
        }
        return string2;
    }

    @JvmOverloads
    public SparseArrayCompat() {
        this(0, 1, null);
    }
}

