/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.asn1.parse;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.kerby.asn1.Tag;
import org.apache.kerby.asn1.parse.Asn1Header;

public final class Asn1Reader {
    private ByteBuffer buffer;
    private int position;

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    public Asn1Header readHeader() throws IOException {
        Tag tag = this.readTag();
        int valueLength = this.readLength();
        Asn1Header header2 = new Asn1Header(tag, valueLength);
        return header2;
    }

    public Asn1Reader(ByteBuffer buffer) {
        this.buffer = buffer;
        this.position = buffer.position();
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public boolean available() {
        return this.position < this.buffer.limit();
    }

    protected byte readByte() throws IOException {
        return this.buffer.get(this.position++);
    }

    private Tag readTag() throws IOException {
        int tagFlags = this.readTagFlags();
        int tagNo = this.readTagNo(tagFlags);
        return new Tag(tagFlags, tagNo);
    }

    private int readTagFlags() throws IOException {
        int tagFlags = this.readByte() & 0xFF;
        return tagFlags;
    }

    private int readTagNo(int tagFlags) throws IOException {
        int tagNo = tagFlags & 0x1F;
        if (tagNo == 31) {
            tagNo = 0;
            int b2 = this.readByte() & 0xFF;
            if ((b2 & 0x7F) == 0) {
                throw new IOException("Invalid high tag number found");
            }
            while (b2 >= 0 && (b2 & 0x80) != 0) {
                tagNo |= b2 & 0x7F;
                tagNo <<= 7;
                b2 = this.readByte();
            }
            tagNo |= b2 & 0x7F;
        }
        return tagNo;
    }

    private int readLength() throws IOException {
        int result2 = this.readByte() & 0xFF;
        if (result2 == 128) {
            return -1;
        }
        if (result2 > 127) {
            int length = result2 & 0x7F;
            if (length > 4) {
                throw new IOException("Bad length of more than 4 bytes: " + length);
            }
            result2 = 0;
            for (int i2 = 0; i2 < length; ++i2) {
                int tmp = this.readByte() & 0xFF;
                result2 = (result2 << 8) + tmp;
            }
        }
        if (result2 < 0) {
            throw new IOException("Invalid length " + result2);
        }
        return result2;
    }
}

