/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractDerivedByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.DuplicatedByteBuf;
import io.netty.util.ByteProcessor;
import io.netty.util.internal.MathUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.charset.Charset;

abstract class AbstractUnpooledSlicedByteBuf
extends AbstractDerivedByteBuf {
    private final ByteBuf buffer;
    private final int adjustment;

    AbstractUnpooledSlicedByteBuf(ByteBuf buffer, int index2, int length) {
        super(length);
        AbstractUnpooledSlicedByteBuf.checkSliceOutOfBounds(index2, length, buffer);
        if (buffer instanceof AbstractUnpooledSlicedByteBuf) {
            this.buffer = ((AbstractUnpooledSlicedByteBuf)buffer).buffer;
            this.adjustment = ((AbstractUnpooledSlicedByteBuf)buffer).adjustment + index2;
        } else if (buffer instanceof DuplicatedByteBuf) {
            this.buffer = buffer.unwrap();
            this.adjustment = index2;
        } else {
            this.buffer = buffer;
            this.adjustment = index2;
        }
        this.initLength(length);
        this.writerIndex(length);
    }

    void initLength(int length) {
    }

    int length() {
        return this.capacity();
    }

    @Override
    public ByteBuf unwrap() {
        return this.buffer;
    }

    @Override
    public ByteBufAllocator alloc() {
        return this.unwrap().alloc();
    }

    @Override
    @Deprecated
    public ByteOrder order() {
        return this.unwrap().order();
    }

    @Override
    public boolean isDirect() {
        return this.unwrap().isDirect();
    }

    @Override
    public ByteBuf capacity(int newCapacity) {
        throw new UnsupportedOperationException("sliced buffer");
    }

    @Override
    public boolean hasArray() {
        return this.unwrap().hasArray();
    }

    @Override
    public byte[] array() {
        return this.unwrap().array();
    }

    @Override
    public int arrayOffset() {
        return this.idx(this.unwrap().arrayOffset());
    }

    @Override
    public boolean hasMemoryAddress() {
        return this.unwrap().hasMemoryAddress();
    }

    @Override
    public long memoryAddress() {
        return this.unwrap().memoryAddress() + (long)this.adjustment;
    }

    @Override
    public byte getByte(int index2) {
        this.checkIndex(index2, 1);
        return this._getByte(index2);
    }

    @Override
    protected byte _getByte(int index2) {
        return this.unwrap().getByte(this.idx(index2));
    }

    @Override
    public short getShort(int index2) {
        this.checkIndex(index2, 2);
        return this._getShort(index2);
    }

    @Override
    protected short _getShort(int index2) {
        return this.unwrap().getShort(this.idx(index2));
    }

    @Override
    public short getShortLE(int index2) {
        this.checkIndex(index2, 2);
        return this._getShortLE(index2);
    }

    @Override
    protected short _getShortLE(int index2) {
        return this.unwrap().getShortLE(this.idx(index2));
    }

    @Override
    public int getUnsignedMedium(int index2) {
        this.checkIndex(index2, 3);
        return this._getUnsignedMedium(index2);
    }

    @Override
    protected int _getUnsignedMedium(int index2) {
        return this.unwrap().getUnsignedMedium(this.idx(index2));
    }

    @Override
    public int getUnsignedMediumLE(int index2) {
        this.checkIndex(index2, 3);
        return this._getUnsignedMediumLE(index2);
    }

    @Override
    protected int _getUnsignedMediumLE(int index2) {
        return this.unwrap().getUnsignedMediumLE(this.idx(index2));
    }

    @Override
    public int getInt(int index2) {
        this.checkIndex(index2, 4);
        return this._getInt(index2);
    }

    @Override
    protected int _getInt(int index2) {
        return this.unwrap().getInt(this.idx(index2));
    }

    @Override
    public int getIntLE(int index2) {
        this.checkIndex(index2, 4);
        return this._getIntLE(index2);
    }

    @Override
    protected int _getIntLE(int index2) {
        return this.unwrap().getIntLE(this.idx(index2));
    }

    @Override
    public long getLong(int index2) {
        this.checkIndex(index2, 8);
        return this._getLong(index2);
    }

    @Override
    protected long _getLong(int index2) {
        return this.unwrap().getLong(this.idx(index2));
    }

    @Override
    public long getLongLE(int index2) {
        this.checkIndex(index2, 8);
        return this._getLongLE(index2);
    }

    @Override
    protected long _getLongLE(int index2) {
        return this.unwrap().getLongLE(this.idx(index2));
    }

    @Override
    public ByteBuf duplicate() {
        return this.slice(0, this.capacity()).setIndex(this.readerIndex(), this.writerIndex());
    }

    @Override
    public ByteBuf retainedDuplicate() {
        return this.retainedSlice(0, this.capacity()).setIndex(this.readerIndex(), this.writerIndex());
    }

    @Override
    public ByteBuf copy(int index2, int length) {
        this.checkIndex0(index2, length);
        return this.unwrap().copy(this.idx(index2), length);
    }

    @Override
    public ByteBuf slice(int index2, int length) {
        this.checkIndex0(index2, length);
        return this.unwrap().slice(this.idx(index2), length);
    }

    @Override
    public ByteBuf getBytes(int index2, ByteBuf dst, int dstIndex, int length) {
        this.checkIndex0(index2, length);
        this.unwrap().getBytes(this.idx(index2), dst, dstIndex, length);
        return this;
    }

    @Override
    public ByteBuf getBytes(int index2, byte[] dst, int dstIndex, int length) {
        this.checkIndex0(index2, length);
        this.unwrap().getBytes(this.idx(index2), dst, dstIndex, length);
        return this;
    }

    @Override
    public ByteBuf getBytes(int index2, ByteBuffer dst) {
        this.checkIndex0(index2, dst.remaining());
        this.unwrap().getBytes(this.idx(index2), dst);
        return this;
    }

    @Override
    public ByteBuf setByte(int index2, int value) {
        this.checkIndex(index2, 1);
        this._setByte(index2, value);
        return this;
    }

    @Override
    public CharSequence getCharSequence(int index2, int length, Charset charset) {
        this.checkIndex0(index2, length);
        return this.unwrap().getCharSequence(this.idx(index2), length, charset);
    }

    @Override
    protected void _setByte(int index2, int value) {
        this.unwrap().setByte(this.idx(index2), value);
    }

    @Override
    public ByteBuf setShort(int index2, int value) {
        this.checkIndex(index2, 2);
        this._setShort(index2, value);
        return this;
    }

    @Override
    protected void _setShort(int index2, int value) {
        this.unwrap().setShort(this.idx(index2), value);
    }

    @Override
    public ByteBuf setShortLE(int index2, int value) {
        this.checkIndex(index2, 2);
        this._setShortLE(index2, value);
        return this;
    }

    @Override
    protected void _setShortLE(int index2, int value) {
        this.unwrap().setShortLE(this.idx(index2), value);
    }

    @Override
    public ByteBuf setMedium(int index2, int value) {
        this.checkIndex(index2, 3);
        this._setMedium(index2, value);
        return this;
    }

    @Override
    protected void _setMedium(int index2, int value) {
        this.unwrap().setMedium(this.idx(index2), value);
    }

    @Override
    public ByteBuf setMediumLE(int index2, int value) {
        this.checkIndex(index2, 3);
        this._setMediumLE(index2, value);
        return this;
    }

    @Override
    protected void _setMediumLE(int index2, int value) {
        this.unwrap().setMediumLE(this.idx(index2), value);
    }

    @Override
    public ByteBuf setInt(int index2, int value) {
        this.checkIndex(index2, 4);
        this._setInt(index2, value);
        return this;
    }

    @Override
    protected void _setInt(int index2, int value) {
        this.unwrap().setInt(this.idx(index2), value);
    }

    @Override
    public ByteBuf setIntLE(int index2, int value) {
        this.checkIndex(index2, 4);
        this._setIntLE(index2, value);
        return this;
    }

    @Override
    protected void _setIntLE(int index2, int value) {
        this.unwrap().setIntLE(this.idx(index2), value);
    }

    @Override
    public ByteBuf setLong(int index2, long value) {
        this.checkIndex(index2, 8);
        this._setLong(index2, value);
        return this;
    }

    @Override
    protected void _setLong(int index2, long value) {
        this.unwrap().setLong(this.idx(index2), value);
    }

    @Override
    public ByteBuf setLongLE(int index2, long value) {
        this.checkIndex(index2, 8);
        this._setLongLE(index2, value);
        return this;
    }

    @Override
    protected void _setLongLE(int index2, long value) {
        this.unwrap().setLongLE(this.idx(index2), value);
    }

    @Override
    public ByteBuf setBytes(int index2, byte[] src, int srcIndex, int length) {
        this.checkIndex0(index2, length);
        this.unwrap().setBytes(this.idx(index2), src, srcIndex, length);
        return this;
    }

    @Override
    public ByteBuf setBytes(int index2, ByteBuf src, int srcIndex, int length) {
        this.checkIndex0(index2, length);
        this.unwrap().setBytes(this.idx(index2), src, srcIndex, length);
        return this;
    }

    @Override
    public ByteBuf setBytes(int index2, ByteBuffer src) {
        this.checkIndex0(index2, src.remaining());
        this.unwrap().setBytes(this.idx(index2), src);
        return this;
    }

    @Override
    public ByteBuf getBytes(int index2, OutputStream out, int length) throws IOException {
        this.checkIndex0(index2, length);
        this.unwrap().getBytes(this.idx(index2), out, length);
        return this;
    }

    @Override
    public int getBytes(int index2, GatheringByteChannel out, int length) throws IOException {
        this.checkIndex0(index2, length);
        return this.unwrap().getBytes(this.idx(index2), out, length);
    }

    @Override
    public int getBytes(int index2, FileChannel out, long position, int length) throws IOException {
        this.checkIndex0(index2, length);
        return this.unwrap().getBytes(this.idx(index2), out, position, length);
    }

    @Override
    public int setBytes(int index2, InputStream in, int length) throws IOException {
        this.checkIndex0(index2, length);
        return this.unwrap().setBytes(this.idx(index2), in, length);
    }

    @Override
    public int setBytes(int index2, ScatteringByteChannel in, int length) throws IOException {
        this.checkIndex0(index2, length);
        return this.unwrap().setBytes(this.idx(index2), in, length);
    }

    @Override
    public int setBytes(int index2, FileChannel in, long position, int length) throws IOException {
        this.checkIndex0(index2, length);
        return this.unwrap().setBytes(this.idx(index2), in, position, length);
    }

    @Override
    public int nioBufferCount() {
        return this.unwrap().nioBufferCount();
    }

    @Override
    public ByteBuffer nioBuffer(int index2, int length) {
        this.checkIndex0(index2, length);
        return this.unwrap().nioBuffer(this.idx(index2), length);
    }

    @Override
    public ByteBuffer[] nioBuffers(int index2, int length) {
        this.checkIndex0(index2, length);
        return this.unwrap().nioBuffers(this.idx(index2), length);
    }

    @Override
    public int forEachByte(int index2, int length, ByteProcessor processor) {
        this.checkIndex0(index2, length);
        int ret = this.unwrap().forEachByte(this.idx(index2), length, processor);
        if (ret >= this.adjustment) {
            return ret - this.adjustment;
        }
        return -1;
    }

    @Override
    public int forEachByteDesc(int index2, int length, ByteProcessor processor) {
        this.checkIndex0(index2, length);
        int ret = this.unwrap().forEachByteDesc(this.idx(index2), length, processor);
        if (ret >= this.adjustment) {
            return ret - this.adjustment;
        }
        return -1;
    }

    final int idx(int index2) {
        return index2 + this.adjustment;
    }

    static void checkSliceOutOfBounds(int index2, int length, ByteBuf buffer) {
        if (MathUtil.isOutOfBounds(index2, length, buffer.capacity())) {
            throw new IndexOutOfBoundsException(buffer + ".slice(" + index2 + ", " + length + ')');
        }
    }
}

