/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data;

import com.webauthn4j.data.AuthenticatorResponse;
import com.webauthn4j.util.ArrayUtil;
import com.webauthn4j.util.AssertUtil;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AuthenticatorAssertionResponse
extends AuthenticatorResponse {
    private final byte[] authenticatorData;
    private final byte[] signature;
    private final byte[] userHandle;

    public AuthenticatorAssertionResponse(@NotNull byte[] clientDataJSON, @NotNull byte[] authenticatorData, @NotNull byte[] signature, @Nullable byte[] userHandle) {
        super(clientDataJSON);
        AssertUtil.notNull(authenticatorData, "authenticatorData must not be null");
        AssertUtil.notNull(signature, "signature must not be null");
        this.authenticatorData = authenticatorData;
        this.signature = signature;
        this.userHandle = userHandle;
    }

    @NotNull
    public byte[] getAuthenticatorData() {
        return ArrayUtil.clone(this.authenticatorData);
    }

    @NotNull
    public byte[] getSignature() {
        return ArrayUtil.clone(this.signature);
    }

    @Nullable
    public byte[] getUserHandle() {
        return ArrayUtil.clone(this.userHandle);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticatorAssertionResponse that = (AuthenticatorAssertionResponse)o;
        return Arrays.equals(this.authenticatorData, that.authenticatorData) && Arrays.equals(this.signature, that.signature) && Arrays.equals(this.userHandle, that.userHandle);
    }

    public int hashCode() {
        int result2 = Arrays.hashCode(this.authenticatorData);
        result2 = 31 * result2 + Arrays.hashCode(this.signature);
        result2 = 31 * result2 + Arrays.hashCode(this.userHandle);
        return result2;
    }

    @Override
    public String toString() {
        return "AuthenticatorAssertionResponse(authenticatorData=" + ArrayUtil.toHexString(this.authenticatorData) + ", signature=" + ArrayUtil.toHexString(this.signature) + ", userHandle=" + ArrayUtil.toHexString(this.userHandle) + ")";
    }
}

