/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.attestation.authenticator;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.webauthn4j.data.attestation.authenticator.COSEKey;
import com.webauthn4j.data.attestation.statement.COSEAlgorithmIdentifier;
import com.webauthn4j.data.attestation.statement.COSEKeyOperation;
import com.webauthn4j.data.attestation.statement.COSEKeyType;
import com.webauthn4j.util.ArrayUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCOSEKey
implements COSEKey {
    @JsonProperty(value="2")
    private final byte[] keyId;
    @JsonProperty(value="3")
    private final COSEAlgorithmIdentifier algorithm;
    @JsonProperty(value="4")
    private final List<COSEKeyOperation> keyOps;
    @JsonProperty(value="5")
    private final byte[] baseIV;

    @JsonCreator
    AbstractCOSEKey(@JsonProperty(value="2") @Nullable byte[] keyId, @JsonProperty(value="3") @Nullable COSEAlgorithmIdentifier algorithm, @JsonProperty(value="4") @Nullable List<COSEKeyOperation> keyOps, @JsonProperty(value="5") @Nullable byte[] baseIV) {
        this.keyId = keyId;
        this.algorithm = algorithm;
        this.keyOps = keyOps;
        this.baseIV = baseIV;
    }

    @Override
    @JsonProperty(value="1")
    @Nullable
    public abstract COSEKeyType getKeyType();

    @Override
    @Nullable
    public byte[] getKeyId() {
        return ArrayUtil.clone(this.keyId);
    }

    @Override
    @Nullable
    public COSEAlgorithmIdentifier getAlgorithm() {
        return this.algorithm;
    }

    @Override
    @Nullable
    public List<COSEKeyOperation> getKeyOps() {
        return this.keyOps;
    }

    @Override
    @Nullable
    public byte[] getBaseIV() {
        return ArrayUtil.clone(this.baseIV);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractCOSEKey that = (AbstractCOSEKey)o;
        return Arrays.equals(this.keyId, that.keyId) && Objects.equals(this.algorithm, that.algorithm) && Objects.equals(this.keyOps, that.keyOps) && Arrays.equals(this.baseIV, that.baseIV);
    }

    public int hashCode() {
        int result2 = Objects.hash(this.algorithm, this.keyOps);
        result2 = 31 * result2 + Arrays.hashCode(this.keyId);
        result2 = 31 * result2 + Arrays.hashCode(this.baseIV);
        return result2;
    }
}

