/*
 * Decompiled with CFR 0.152.
 */
package com.ethlo.time.internal;

import com.ethlo.time.Duration;
import com.ethlo.time.internal.DurationPartsConsumer;
import com.ethlo.time.internal.fixed.ITUParser;

public class ItuDurationParser {
    public static final int NANOS_IN_SECOND = 1000000000;
    public static final char SEP_T = 'T';
    public static final char UNIT_WEEK = 'W';
    public static final char UNIT_DAY = 'D';
    public static final char UNIT_HOUR = 'H';
    public static final char UNIT_MINUTE = 'M';
    public static final char UNIT_SECOND = 'S';
    public static final char DOT = '.';
    public static final char DIGIT_ZERO = '0';
    public static final char DIGIT_NINE = '9';
    public static final char MINUS = '-';
    public static final char UNIT_UNDEFINED = '\u0000';

    public static Duration parse(String chars) {
        return ItuDurationParser.parse(chars, 0);
    }

    public static Duration parse(String text, int offset) {
        int availableLength = ITUParser.sanityCheckInputParams(text, offset);
        if (availableLength == 0) {
            DurationPartsConsumer.error("Duration cannot be empty", text, text.length() - 1);
        }
        boolean negative = false;
        int index2 = offset;
        if (text.charAt(offset) == '-') {
            negative = true;
            ++index2;
        }
        DurationPartsConsumer handler = new DurationPartsConsumer(index2, negative);
        int length = text.length();
        while (index2 < length) {
            index2 = ItuDurationParser.readUntilNonDigit(text, index2, handler);
        }
        handler.validate(text, index2);
        return handler.getResult();
    }

    private static int readUntilNonDigit(String text, int offset, DurationPartsConsumer consumer) {
        int index2;
        long value = 0L;
        int startIndex = index2 = offset;
        while (index2 < text.length()) {
            char c = text.charAt(index2);
            if (c < '0' || c > '9') {
                int length = index2 - startIndex;
                consumer.accept(text, index2, length, c, value);
                value = 0L;
                startIndex = index2 + 1;
                break;
            }
            int digit = c - 48;
            value = Math.addExact(Math.multiplyExact(value, 10), (long)digit);
            ++index2;
        }
        int length = index2 - startIndex;
        if (index2 - startIndex > 0) {
            consumer.accept(text, index2, length, '\u0000', value);
        }
        return index2 + 1;
    }
}

