/*
 * Decompiled with CFR 0.152.
 */
package androidx.lifecycle;

import androidx.annotation.AnyThread;
import androidx.annotation.MainThread;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Queue;
import kotlin.Metadata;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.MainCoroutineDispatcher;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000b\u001a\u00020\fH\u0007J\b\u0010\r\u001a\u00020\fH\u0007J\b\u0010\u000e\u001a\u00020\fH\u0007J\b\u0010\u000f\u001a\u00020\fH\u0007J\b\u0010\u0010\u001a\u00020\u0005H\u0007J\u0018\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\nH\u0007J\u0010\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\nH\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Landroidx/lifecycle/DispatchQueue;", "", "<init>", "()V", "paused", "", "finished", "isDraining", "queue", "Ljava/util/Queue;", "Ljava/lang/Runnable;", "pause", "", "resume", "finish", "drainQueue", "canRun", "dispatchAndEnqueue", "context", "Lkotlin/coroutines/CoroutineContext;", "runnable", "enqueue", "lifecycle-common"})
@SourceDebugExtension(value={"SMAP\nDispatchQueue.jvm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DispatchQueue.jvm.kt\nandroidx/lifecycle/DispatchQueue\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,109:1\n1#2:110\n*E\n"})
public final class DispatchQueue {
    private boolean paused = true;
    private boolean finished;
    private boolean isDraining;
    @NotNull
    private final Queue<Runnable> queue = new ArrayDeque();

    @MainThread
    public final void pause() {
        this.paused = true;
    }

    @MainThread
    public final void resume() {
        if (!this.paused) {
            return;
        }
        if (!(!this.finished)) {
            boolean bl = false;
            String string = "Cannot resume a finished dispatcher";
            throw new IllegalStateException(string.toString());
        }
        this.paused = false;
        this.drainQueue();
    }

    @MainThread
    public final void finish() {
        this.finished = true;
        this.drainQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void drainQueue() {
        if (this.isDraining) {
            return;
        }
        try {
            this.isDraining = true;
            while (!((Collection)this.queue).isEmpty()) {
                if (!this.canRun()) {
                    break;
                }
                Runnable runnable = this.queue.poll();
                if (runnable == null) continue;
                runnable.run();
            }
        }
        finally {
            this.isDraining = false;
        }
    }

    @MainThread
    public final boolean canRun() {
        return this.finished || !this.paused;
    }

    @AnyThread
    public final void dispatchAndEnqueue(@NotNull CoroutineContext context, @NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        MainCoroutineDispatcher $this$dispatchAndEnqueue_u24lambda_u242 = Dispatchers.getMain().getImmediate();
        boolean bl = false;
        if ($this$dispatchAndEnqueue_u24lambda_u242.isDispatchNeeded(context) || this.canRun()) {
            $this$dispatchAndEnqueue_u24lambda_u242.dispatch(context, () -> DispatchQueue.dispatchAndEnqueue$lambda$2$lambda$1(this, runnable));
        } else {
            this.enqueue(runnable);
        }
    }

    @MainThread
    private final void enqueue(Runnable runnable) {
        if (!this.queue.offer(runnable)) {
            boolean bl = false;
            String string = "cannot enqueue any more runnables";
            throw new IllegalStateException(string.toString());
        }
        this.drainQueue();
    }

    private static final void dispatchAndEnqueue$lambda$2$lambda$1(DispatchQueue this$0, Runnable $runnable) {
        this$0.enqueue($runnable);
    }
}

