/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.argparse4j.impl.type;

import java.io.File;
import net.sourceforge.argparse4j.impl.type.FileVerification;
import net.sourceforge.argparse4j.inf.Argument;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.ArgumentType;

public class FileArgumentType
implements ArgumentType<File> {
    private boolean acceptSystemIn = false;
    private final FileVerification firstFileVerification;
    private FileVerification currentFileVerification = this.firstFileVerification = new FileVerification();

    public FileArgumentType acceptSystemIn() {
        this.acceptSystemIn = true;
        return this;
    }

    public FileArgumentType verifyExists() {
        this.currentFileVerification.verifyExists = true;
        return this;
    }

    public FileArgumentType verifyNotExists() {
        this.currentFileVerification.verifyNotExists = true;
        return this;
    }

    public FileArgumentType verifyIsFile() {
        this.currentFileVerification.verifyIsFile = true;
        return this;
    }

    public FileArgumentType verifyIsDirectory() {
        this.currentFileVerification.verifyIsDirectory = true;
        return this;
    }

    public FileArgumentType verifyCanRead() {
        this.currentFileVerification.verifyCanRead = true;
        return this;
    }

    public FileArgumentType verifyCanWrite() {
        this.currentFileVerification.verifyCanWrite = true;
        return this;
    }

    public FileArgumentType verifyCanWriteParent() {
        this.currentFileVerification.verifyCanWriteParent = true;
        return this;
    }

    public FileArgumentType verifyCanCreate() {
        this.currentFileVerification.verifyCanCreate = true;
        return this;
    }

    public FileArgumentType verifyCanExecute() {
        this.currentFileVerification.verifyCanExecute = true;
        return this;
    }

    public FileArgumentType verifyIsAbsolute() {
        this.currentFileVerification.verifyIsAbsolute = true;
        return this;
    }

    public FileArgumentType or() {
        this.currentFileVerification = this.currentFileVerification.or();
        return this;
    }

    @Override
    public File convert(ArgumentParser parser, Argument arg, String value) throws ArgumentParserException {
        File file = new File(value);
        if (!this.isSystemIn(file)) {
            this.firstFileVerification.verify(parser, arg, file);
        }
        return file;
    }

    private boolean isSystemIn(File file) {
        return this.acceptSystemIn && file.getPath().equals("-");
    }
}

