/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.argparse4j.impl.type;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import net.sourceforge.argparse4j.helper.MessageLocalization;
import net.sourceforge.argparse4j.helper.TextHelper;
import net.sourceforge.argparse4j.helper.TypeNameLocalization;
import net.sourceforge.argparse4j.inf.Argument;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.ArgumentType;
import net.sourceforge.argparse4j.inf.MetavarInference;

public class ReflectArgumentType<T>
implements ArgumentType<T>,
MetavarInference {
    private final Class<T> type_;

    public ReflectArgumentType(Class<T> type2) {
        this.type_ = type2;
    }

    @Override
    public T convert(ArgumentParser parser, Argument arg, String value) throws ArgumentParserException {
        if (this.type_.isEnum()) {
            try {
                return Enum.valueOf(this.type_, value);
            }
            catch (IllegalArgumentException e) {
                throw new ArgumentParserException(String.format(TextHelper.LOCALE_ROOT, MessageLocalization.localize(parser.getConfig().getResourceBundle(), "couldNotConvertChooseFromError"), value, this.inferMetavar()[0]), parser, arg);
            }
        }
        Method m = null;
        try {
            m = this.type_.getMethod("valueOf", String.class);
        }
        catch (NoSuchMethodException e) {
            return this.convertUsingConstructor(parser, arg, value);
        }
        catch (SecurityException e) {
            this.handleInstantiationError(e);
        }
        if (!Modifier.isStatic(m.getModifiers()) || !this.type_.isAssignableFrom(m.getReturnType())) {
            return this.convertUsingConstructor(parser, arg, value);
        }
        Object obj = null;
        try {
            obj = m.invoke(null, value);
        }
        catch (IllegalAccessException e) {
            return this.convertUsingConstructor(parser, arg, value);
        }
        catch (IllegalArgumentException e) {
            this.handleInstantiationError(e);
        }
        catch (InvocationTargetException e) {
            this.throwArgumentParserException(parser, arg, value, e.getCause() == null ? e : e.getCause());
        }
        return (T)obj;
    }

    private T convertUsingConstructor(ArgumentParser parser, Argument arg, String value) throws ArgumentParserException {
        T obj = null;
        try {
            obj = this.type_.getConstructor(String.class).newInstance(value);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException e) {
            this.handleInstantiationError(e);
        }
        catch (InvocationTargetException e) {
            this.throwArgumentParserException(parser, arg, value, e.getCause() == null ? e : e.getCause());
        }
        return obj;
    }

    private void throwArgumentParserException(ArgumentParser parser, Argument arg, String value, Throwable t) throws ArgumentParserException {
        String localizedTypeName = TypeNameLocalization.localizeTypeNameIfPossible(parser, this.type_);
        throw new ArgumentParserException(String.format(TextHelper.LOCALE_ROOT, MessageLocalization.localize(parser.getConfig().getResourceBundle(), "couldNotConvertToError"), value, localizedTypeName), t, parser, arg);
    }

    private void handleInstantiationError(Exception e) {
        throw new IllegalArgumentException("reflect type conversion error", e);
    }

    @Override
    public String[] inferMetavar() {
        if (Boolean.class.equals(this.type_)) {
            return new String[]{TextHelper.concat(new String[]{"true", "false"}, 0, ",", "{", "}")};
        }
        if (this.type_.isEnum()) {
            T[] enumConstants = this.type_.getEnumConstants();
            String[] names = new String[enumConstants.length];
            int i2 = 0;
            for (T t : enumConstants) {
                names[i2++] = ((Enum)t).name();
            }
            return new String[]{TextHelper.concat(names, 0, ",", "{", "}")};
        }
        return null;
    }
}

