/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.ihttp.okhttp.request;

import com.ustadmobile.ihttp.headers.IHttpHeaders;
import com.ustadmobile.ihttp.okhttp.headers.OkHttpHeadersAdapterKt;
import com.ustadmobile.ihttp.request.IHttpRequest;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Request;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0015\u001a\u00020\rH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0016"}, d2={"Lcom/ustadmobile/ihttp/okhttp/request/OkHttpRequestAdapter;", "Lcom/ustadmobile/ihttp/request/IHttpRequest;", "request", "Lokhttp3/Request;", "<init>", "(Lokhttp3/Request;)V", "getRequest$respect_lib_ihttp_okhttp", "()Lokhttp3/Request;", "headers", "Lcom/ustadmobile/ihttp/headers/IHttpHeaders;", "getHeaders", "()Lcom/ustadmobile/ihttp/headers/IHttpHeaders;", "url", "", "getUrl", "()Ljava/lang/String;", "method", "Lcom/ustadmobile/ihttp/request/IHttpRequest$Companion$Method;", "getMethod", "()Lcom/ustadmobile/ihttp/request/IHttpRequest$Companion$Method;", "queryParam", "name", "respect-lib-ihttp-okhttp"})
public final class OkHttpRequestAdapter
implements IHttpRequest {
    @NotNull
    private final Request request;
    @NotNull
    private final IHttpHeaders headers;
    @NotNull
    private final String url;
    @NotNull
    private final IHttpRequest.Companion.Method method;

    public OkHttpRequestAdapter(@NotNull Request request2) {
        Intrinsics.checkNotNullParameter(request2, "request");
        this.request = request2;
        this.headers = OkHttpHeadersAdapterKt.asIHttpHeaders(this.request.headers());
        this.url = this.request.url().toString();
        this.method = IHttpRequest.Companion.Method.Companion.forName(this.request.method());
    }

    @NotNull
    public final Request getRequest$respect_lib_ihttp_okhttp() {
        return this.request;
    }

    @Override
    @NotNull
    public IHttpHeaders getHeaders() {
        return this.headers;
    }

    @Override
    @NotNull
    public String getUrl() {
        return this.url;
    }

    @Override
    @NotNull
    public IHttpRequest.Companion.Method getMethod() {
        return this.method;
    }

    @Override
    @Nullable
    public String queryParam(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return CollectionsKt.firstOrNull(this.request.url().queryParameterValues(name));
    }
}

