/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.netty.http1;

import io.ktor.http.HttpHeaders;
import io.ktor.http.HttpMethod;
import io.ktor.http.RequestConnectionPoint;
import io.ktor.http.URLProtocol;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpRequest;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0017\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\t\u0010\nR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u000bR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\fR\u0014\u0010\u000e\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\nR\u0014\u0010\u0010\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\nR\u0014\u0010\u0014\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u001b\u0010\u0018\u001a\u00020\b8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\nR\u001a\u0010\u001c\u001a\u00020\b8VX\u0097\u0004\u00a2\u0006\f\u0012\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u0019\u0010\nR\u001a\u0010!\u001a\u00020\u001d8VX\u0097\u0004\u00a2\u0006\f\u0012\u0004\b \u0010\u001b\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010#\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\nR\u0014\u0010%\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\nR\u0014\u0010'\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\nR\u0014\u0010)\u001a\u00020\u001d8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u001fR\u0014\u0010+\u001a\u00020\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u001fR\u0014\u0010-\u001a\u00020\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010\u001fR\u0014\u0010/\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010\nR\u0014\u00101\u001a\u00020\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u0010\u001fR\u0014\u00103\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u0010\n\u00a8\u00064"}, d2={"Lio/ktor/server/netty/http1/NettyConnectionPoint;", "Lio/ktor/http/RequestConnectionPoint;", "Lio/netty/handler/codec/http/HttpRequest;", "request", "Lio/netty/channel/ChannelHandlerContext;", "context", "<init>", "(Lio/netty/handler/codec/http/HttpRequest;Lio/netty/channel/ChannelHandlerContext;)V", "", "toString", "()Ljava/lang/String;", "Lio/netty/handler/codec/http/HttpRequest;", "Lio/netty/channel/ChannelHandlerContext;", "getVersion", "version", "getUri", "uri", "Lio/ktor/http/HttpMethod;", "getMethod", "()Lio/ktor/http/HttpMethod;", "method", "scheme$delegate", "Lkotlin/Lazy;", "getScheme", "scheme", "getHost", "getHost$annotations", "()V", "host", "", "getPort", "()I", "getPort$annotations", "port", "getLocalHost", "localHost", "getServerHost", "serverHost", "getLocalAddress", "localAddress", "getDefaultPort", "defaultPort", "getLocalPort", "localPort", "getServerPort", "serverPort", "getRemoteHost", "remoteHost", "getRemotePort", "remotePort", "getRemoteAddress", "remoteAddress", "ktor-server-netty"})
@SourceDebugExtension(value={"SMAP\nNettyConnectionPoint.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NettyConnectionPoint.kt\nio/ktor/server/netty/http1/NettyConnectionPoint\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,84:1\n1#2:85\n*E\n"})
public final class NettyConnectionPoint
implements RequestConnectionPoint {
    @NotNull
    private final HttpRequest request;
    @NotNull
    private final ChannelHandlerContext context;
    @NotNull
    private final Lazy scheme$delegate;

    public NettyConnectionPoint(@NotNull HttpRequest request2, @NotNull ChannelHandlerContext context) {
        Intrinsics.checkNotNullParameter(request2, "request");
        Intrinsics.checkNotNullParameter(context, "context");
        this.request = request2;
        this.context = context;
        this.scheme$delegate = LazyKt.lazy(() -> NettyConnectionPoint.scheme_delegate$lambda$0(this));
    }

    @Override
    @NotNull
    public String getVersion() {
        String string = this.request.protocolVersion().text();
        Intrinsics.checkNotNullExpressionValue(string, "text(...)");
        return string;
    }

    @Override
    @NotNull
    public String getUri() {
        String string = this.request.uri();
        Intrinsics.checkNotNullExpressionValue(string, "uri(...)");
        return string;
    }

    @Override
    @NotNull
    public HttpMethod getMethod() {
        String string = this.request.method().name();
        Intrinsics.checkNotNullExpressionValue(string, "name(...)");
        return HttpMethod.Companion.parse(string);
    }

    @Override
    @NotNull
    public String getScheme() {
        Lazy lazy = this.scheme$delegate;
        return (String)lazy.getValue();
    }

    @Override
    @NotNull
    public String getHost() {
        String string = this.request.headers().get(HttpHeaders.INSTANCE.getHost());
        if (string == null || (string = StringsKt.substringBefore$default(string, ":", null, 2, null)) == null) {
            String string2;
            InetSocketAddress inetSocketAddress;
            SocketAddress socketAddress = this.context.channel().localAddress();
            InetSocketAddress inetSocketAddress2 = inetSocketAddress = socketAddress instanceof InetSocketAddress ? (InetSocketAddress)socketAddress : null;
            if (inetSocketAddress != null) {
                InetSocketAddress it = inetSocketAddress;
                boolean bl = false;
                string2 = it.getHostName();
                if (string2 == null) {
                    string2 = it.getAddress().getHostAddress();
                }
            } else {
                string2 = string = null;
            }
            if (string2 == null) {
                string = "localhost";
            }
        }
        return string;
    }

    @Deprecated(message="Use localHost or serverHost instead", level=DeprecationLevel.ERROR)
    public static /* synthetic */ void getHost$annotations() {
    }

    @Override
    public int getPort() {
        SocketAddress socketAddress = this.context.channel().localAddress();
        InetSocketAddress inetSocketAddress = socketAddress instanceof InetSocketAddress ? (InetSocketAddress)socketAddress : null;
        return inetSocketAddress != null ? inetSocketAddress.getPort() : 80;
    }

    @Deprecated(message="Use localPort or serverPort instead", level=DeprecationLevel.ERROR)
    public static /* synthetic */ void getPort$annotations() {
    }

    @Override
    @NotNull
    public String getLocalHost() {
        Object object;
        block5: {
            block4: {
                SocketAddress socketAddress = this.context.channel().localAddress();
                object = socketAddress instanceof InetSocketAddress ? (InetSocketAddress)socketAddress : null;
                if (object == null) break block4;
                InetSocketAddress it = object;
                boolean bl = false;
                String string = it.getHostName();
                if (string == null) {
                    string = it.getHostString();
                }
                object = string;
                if (string != null) break block5;
            }
            object = "localhost";
        }
        return object;
    }

    @Override
    @NotNull
    public String getServerHost() {
        String string = this.request.headers().get(HttpHeaders.INSTANCE.getHost());
        if (string == null || (string = StringsKt.substringBeforeLast$default(string, ":", null, 2, null)) == null) {
            string = this.getLocalHost();
        }
        return string;
    }

    @Override
    @NotNull
    public String getLocalAddress() {
        SocketAddress socketAddress = this.context.channel().localAddress();
        Object object = socketAddress instanceof InetSocketAddress ? (InetSocketAddress)socketAddress : null;
        if (object == null || (object = ((InetSocketAddress)object).getHostString()) == null) {
            object = "localhost";
        }
        return object;
    }

    private final int getDefaultPort() {
        return URLProtocol.Companion.createOrDefault(this.getScheme()).getDefaultPort();
    }

    @Override
    public int getLocalPort() {
        SocketAddress socketAddress = this.context.channel().localAddress();
        InetSocketAddress inetSocketAddress = socketAddress instanceof InetSocketAddress ? (InetSocketAddress)socketAddress : null;
        return inetSocketAddress != null ? inetSocketAddress.getPort() : this.getDefaultPort();
    }

    @Override
    public int getServerPort() {
        String string = this.request.headers().get(HttpHeaders.INSTANCE.getHost());
        return string != null && (string = StringsKt.substringAfterLast(string, ":", String.valueOf(this.getDefaultPort()))) != null ? Integer.parseInt(string) : this.getLocalPort();
    }

    @Override
    @NotNull
    public String getRemoteHost() {
        Object object;
        block5: {
            block4: {
                SocketAddress socketAddress = this.context.channel().remoteAddress();
                object = socketAddress instanceof InetSocketAddress ? (InetSocketAddress)socketAddress : null;
                if (object == null) break block4;
                InetSocketAddress it = object;
                boolean bl = false;
                String string = it.getHostName();
                if (string == null) {
                    string = it.getAddress().getHostAddress();
                }
                object = string;
                if (string != null) break block5;
            }
            object = "unknown";
        }
        return object;
    }

    @Override
    public int getRemotePort() {
        SocketAddress socketAddress = this.context.channel().remoteAddress();
        InetSocketAddress inetSocketAddress = socketAddress instanceof InetSocketAddress ? (InetSocketAddress)socketAddress : null;
        return inetSocketAddress != null ? inetSocketAddress.getPort() : 0;
    }

    @Override
    @NotNull
    public String getRemoteAddress() {
        SocketAddress socketAddress = this.context.channel().remoteAddress();
        Object object = socketAddress instanceof InetSocketAddress ? (InetSocketAddress)socketAddress : null;
        if (object == null || (object = ((InetSocketAddress)object).getHostString()) == null) {
            object = "unknown";
        }
        return object;
    }

    @NotNull
    public String toString() {
        return "NettyConnectionPoint(uri=" + this.getUri() + ", method=" + this.getMethod() + ", version=" + this.getVersion() + ", localAddress=" + this.getLocalAddress() + ", localPort=" + this.getLocalPort() + ", remoteAddress=" + this.getRemoteAddress() + ", remotePort=" + this.getRemotePort() + ')';
    }

    private static final String scheme_delegate$lambda$0(NettyConnectionPoint this$0) {
        return this$0.context.pipeline().context("ssl") == null ? "http" : "https";
    }
}

