/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import io.ktor.http.ContentType;
import io.ktor.http.ContentTypesKt;
import io.ktor.http.Cookie;
import io.ktor.http.CookieKt;
import io.ktor.http.HeaderValue;
import io.ktor.http.HttpHeaderValueParserKt;
import io.ktor.http.HttpHeaders;
import io.ktor.http.HttpMessage;
import io.ktor.http.HttpMessageBuilder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0019\u0010\u0004\u001a\u00020\u0003*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0005\u001a\u0019\u0010\b\u001a\u00020\u0003*\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\t\u001a\u0019\u0010\f\u001a\u00020\u0003*\u00020\u00002\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\r\u001a\u0019\u0010\u000f\u001a\u00020\u0003*\u00020\u00002\u0006\u0010\u000e\u001a\u00020\n\u00a2\u0006\u0004\b\u000f\u0010\r\u001a\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0001*\u00020\u0000\u00a2\u0006\u0004\b\u0004\u0010\u0010\u001a\u0019\u0010\u0013\u001a\n\u0018\u00010\u0011j\u0004\u0018\u0001`\u0012*\u00020\u0000\u00a2\u0006\u0004\b\u0013\u0010\u0014\u001a\u0013\u0010\u0015\u001a\u0004\u0018\u00010\n*\u00020\u0000\u00a2\u0006\u0004\b\u0015\u0010\u0016\u001a\u0019\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u0017*\u00020\u0000\u00a2\u0006\u0004\b\u0018\u0010\u0019\u001a\u0013\u0010\u001b\u001a\u0004\u0018\u00010\u001a*\u00020\u0000\u00a2\u0006\u0004\b\u001b\u0010\u001c\u001a\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0001*\u00020\u001d\u00a2\u0006\u0004\b\u0004\u0010\u001e\u001a\u0019\u0010\u0013\u001a\n\u0018\u00010\u0011j\u0004\u0018\u0001`\u0012*\u00020\u001d\u00a2\u0006\u0004\b\u0013\u0010\u001f\u001a\u0013\u0010\u0015\u001a\u0004\u0018\u00010\n*\u00020\u001d\u00a2\u0006\u0004\b\u0015\u0010 \u001a\u0019\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u0017*\u00020\u001d\u00a2\u0006\u0004\b\u0018\u0010!\u001a\u0013\u0010\u001b\u001a\u0004\u0018\u00010\u001a*\u00020\u001d\u00a2\u0006\u0004\b\u001b\u0010\"\u001a\u0017\u0010$\u001a\b\u0012\u0004\u0012\u00020#0\u0017*\u00020\u001d\u00a2\u0006\u0004\b$\u0010!\u001a\u0017\u0010%\u001a\b\u0012\u0004\u0012\u00020#0\u0017*\u00020\u0000\u00a2\u0006\u0004\b%\u0010\u0019\u001a\u0017\u0010'\u001a\b\u0012\u0004\u0012\u00020&0\u0017*\u00020\u001d\u00a2\u0006\u0004\b'\u0010!\u001a\u0019\u0010(\u001a\b\u0012\u0004\u0012\u00020\n0\u0017*\u00020\nH\u0000\u00a2\u0006\u0004\b(\u0010)\u00a8\u0006*"}, d2={"Lio/ktor/http/HttpMessageBuilder;", "Lio/ktor/http/ContentType;", "type", "", "contentType", "(Lio/ktor/http/HttpMessageBuilder;Lio/ktor/http/ContentType;)V", "", "seconds", "maxAge", "(Lio/ktor/http/HttpMessageBuilder;I)V", "", "value", "ifNoneMatch", "(Lio/ktor/http/HttpMessageBuilder;Ljava/lang/String;)V", "content", "userAgent", "(Lio/ktor/http/HttpMessageBuilder;)Lio/ktor/http/ContentType;", "Ljava/nio/charset/Charset;", "Lio/ktor/utils/io/charsets/Charset;", "charset", "(Lio/ktor/http/HttpMessageBuilder;)Ljava/nio/charset/Charset;", "etag", "(Lio/ktor/http/HttpMessageBuilder;)Ljava/lang/String;", "", "vary", "(Lio/ktor/http/HttpMessageBuilder;)Ljava/util/List;", "", "contentLength", "(Lio/ktor/http/HttpMessageBuilder;)Ljava/lang/Long;", "Lio/ktor/http/HttpMessage;", "(Lio/ktor/http/HttpMessage;)Lio/ktor/http/ContentType;", "(Lio/ktor/http/HttpMessage;)Ljava/nio/charset/Charset;", "(Lio/ktor/http/HttpMessage;)Ljava/lang/String;", "(Lio/ktor/http/HttpMessage;)Ljava/util/List;", "(Lio/ktor/http/HttpMessage;)Ljava/lang/Long;", "Lio/ktor/http/Cookie;", "setCookie", "cookies", "Lio/ktor/http/HeaderValue;", "cacheControl", "splitSetCookieHeader", "(Ljava/lang/String;)Ljava/util/List;", "ktor-http"})
@SourceDebugExtension(value={"SMAP\nHttpMessageProperties.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpMessageProperties.kt\nio/ktor/http/HttpMessagePropertiesKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,193:1\n1#2:194\n1374#3:195\n1460#3,2:196\n1563#3:198\n1634#3,3:199\n1462#3,3:202\n1374#3:205\n1460#3,2:206\n1563#3:208\n1634#3,3:209\n1462#3,3:212\n1374#3:215\n1460#3,5:216\n1563#3:221\n1634#3,3:222\n1563#3:225\n1634#3,3:226\n*S KotlinDebug\n*F\n+ 1 HttpMessageProperties.kt\nio/ktor/http/HttpMessagePropertiesKt\n*L\n67#1:195\n67#1:196,2\n68#1:198\n68#1:199,3\n67#1:202,3\n104#1:205\n104#1:206,2\n105#1:208\n105#1:209,3\n104#1:212,3\n121#1:215\n121#1:216,5\n122#1:221\n122#1:222,3\n131#1:225\n131#1:226,3\n*E\n"})
public final class HttpMessagePropertiesKt {
    public static final void contentType(@NotNull HttpMessageBuilder $this$contentType, @NotNull ContentType type) {
        Intrinsics.checkNotNullParameter($this$contentType, "<this>");
        Intrinsics.checkNotNullParameter(type, "type");
        $this$contentType.getHeaders().set(HttpHeaders.INSTANCE.getContentType(), type.toString());
    }

    public static final void maxAge(@NotNull HttpMessageBuilder $this$maxAge, int seconds) {
        Intrinsics.checkNotNullParameter($this$maxAge, "<this>");
        $this$maxAge.getHeaders().append(HttpHeaders.INSTANCE.getCacheControl(), "max-age=" + seconds);
    }

    public static final void ifNoneMatch(@NotNull HttpMessageBuilder $this$ifNoneMatch, @NotNull String value) {
        Intrinsics.checkNotNullParameter($this$ifNoneMatch, "<this>");
        Intrinsics.checkNotNullParameter(value, "value");
        $this$ifNoneMatch.getHeaders().set(HttpHeaders.INSTANCE.getIfNoneMatch(), value);
    }

    public static final void userAgent(@NotNull HttpMessageBuilder $this$userAgent, @NotNull String content2) {
        Intrinsics.checkNotNullParameter($this$userAgent, "<this>");
        Intrinsics.checkNotNullParameter(content2, "content");
        $this$userAgent.getHeaders().set(HttpHeaders.INSTANCE.getUserAgent(), content2);
    }

    @Nullable
    public static final ContentType contentType(@NotNull HttpMessageBuilder $this$contentType) {
        ContentType contentType;
        Intrinsics.checkNotNullParameter($this$contentType, "<this>");
        String string = $this$contentType.getHeaders().get(HttpHeaders.INSTANCE.getContentType());
        if (string != null) {
            String it = string;
            boolean bl = false;
            contentType = ContentType.Companion.parse(it);
        } else {
            contentType = null;
        }
        return contentType;
    }

    @Nullable
    public static final Charset charset(@NotNull HttpMessageBuilder $this$charset) {
        Intrinsics.checkNotNullParameter($this$charset, "<this>");
        ContentType contentType = HttpMessagePropertiesKt.contentType($this$charset);
        return contentType != null ? ContentTypesKt.charset(contentType) : null;
    }

    @Nullable
    public static final String etag(@NotNull HttpMessageBuilder $this$etag) {
        Intrinsics.checkNotNullParameter($this$etag, "<this>");
        return $this$etag.getHeaders().get(HttpHeaders.INSTANCE.getETag());
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final List<String> vary(@NotNull HttpMessageBuilder $this$vary) {
        List list;
        Intrinsics.checkNotNullParameter($this$vary, "<this>");
        List<String> list2 = $this$vary.getHeaders().getAll(HttpHeaders.INSTANCE.getVary());
        if (list2 != null) {
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = list2;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                void $this$mapTo$iv$iv;
                String varyKeys = (String)element$iv$iv;
                boolean bl = false;
                String[] stringArray = new String[]{","};
                Iterable $this$map$iv = StringsKt.split$default((CharSequence)varyKeys, stringArray, false, 0, 6, null);
                boolean $i$f$map = false;
                Iterable iterable2 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl2 = false;
                    collection.add(((Object)StringsKt.trim((CharSequence)it)).toString());
                }
                Iterable list$iv$iv = (List)destination$iv$iv2;
                CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        return list;
    }

    @Nullable
    public static final Long contentLength(@NotNull HttpMessageBuilder $this$contentLength) {
        Intrinsics.checkNotNullParameter($this$contentLength, "<this>");
        String string = $this$contentLength.getHeaders().get(HttpHeaders.INSTANCE.getContentLength());
        return string != null ? Long.valueOf(Long.parseLong(string)) : null;
    }

    @Nullable
    public static final ContentType contentType(@NotNull HttpMessage $this$contentType) {
        ContentType contentType;
        Intrinsics.checkNotNullParameter($this$contentType, "<this>");
        String string = $this$contentType.getHeaders().get(HttpHeaders.INSTANCE.getContentType());
        if (string != null) {
            String it = string;
            boolean bl = false;
            contentType = ContentType.Companion.parse(it);
        } else {
            contentType = null;
        }
        return contentType;
    }

    @Nullable
    public static final Charset charset(@NotNull HttpMessage $this$charset) {
        Intrinsics.checkNotNullParameter($this$charset, "<this>");
        ContentType contentType = HttpMessagePropertiesKt.contentType($this$charset);
        return contentType != null ? ContentTypesKt.charset(contentType) : null;
    }

    @Nullable
    public static final String etag(@NotNull HttpMessage $this$etag) {
        Intrinsics.checkNotNullParameter($this$etag, "<this>");
        return $this$etag.getHeaders().get(HttpHeaders.INSTANCE.getETag());
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final List<String> vary(@NotNull HttpMessage $this$vary) {
        List list;
        Intrinsics.checkNotNullParameter($this$vary, "<this>");
        List<String> list2 = $this$vary.getHeaders().getAll(HttpHeaders.INSTANCE.getVary());
        if (list2 != null) {
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = list2;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                void $this$mapTo$iv$iv;
                String varyKeys = (String)element$iv$iv;
                boolean bl = false;
                String[] stringArray = new String[]{","};
                Iterable $this$map$iv = StringsKt.split$default((CharSequence)varyKeys, stringArray, false, 0, 6, null);
                boolean $i$f$map = false;
                Iterable iterable2 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl2 = false;
                    collection.add(((Object)StringsKt.trim((CharSequence)it)).toString());
                }
                Iterable list$iv$iv = (List)destination$iv$iv2;
                CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        return list;
    }

    @Nullable
    public static final Long contentLength(@NotNull HttpMessage $this$contentLength) {
        Intrinsics.checkNotNullParameter($this$contentLength, "<this>");
        String string = $this$contentLength.getHeaders().get(HttpHeaders.INSTANCE.getContentLength());
        return string != null ? Long.valueOf(Long.parseLong(string)) : null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Cookie> setCookie(@NotNull HttpMessage $this$setCookie) {
        List list;
        Intrinsics.checkNotNullParameter($this$setCookie, "<this>");
        List<String> list2 = $this$setCookie.getHeaders().getAll(HttpHeaders.INSTANCE.getSetCookie());
        if (list2 != null) {
            void $this$mapTo$iv$iv;
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = list2;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = HttpMessagePropertiesKt.splitSetCookieHeader(it);
                CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String bl = (String)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(CookieKt.parseServerSetCookieHeader((String)it));
            }
            list = (List)destination$iv$iv2;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Cookie> cookies(@NotNull HttpMessageBuilder $this$cookies) {
        List list;
        Intrinsics.checkNotNullParameter($this$cookies, "<this>");
        List<String> list2 = $this$cookies.getHeaders().getAll(HttpHeaders.INSTANCE.getSetCookie());
        if (list2 != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(CookieKt.parseServerSetCookieHeader((String)it));
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    public static final List<HeaderValue> cacheControl(@NotNull HttpMessage $this$cacheControl) {
        Object object;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter($this$cacheControl, "<this>");
                object = $this$cacheControl.getHeaders().get(HttpHeaders.INSTANCE.getCacheControl());
                if (object == null) break block2;
                String it = object;
                boolean bl = false;
                List<HeaderValue> list = HttpHeaderValueParserKt.parseHeaderValue(it);
                object = list;
                if (list != null) break block3;
            }
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @NotNull
    public static final List<String> splitSetCookieHeader(@NotNull String $this$splitSetCookieHeader) {
        Intrinsics.checkNotNullParameter($this$splitSetCookieHeader, "<this>");
        int comma = StringsKt.indexOf$default((CharSequence)$this$splitSetCookieHeader, ',', 0, false, 6, null);
        if (comma == -1) {
            return CollectionsKt.listOf($this$splitSetCookieHeader);
        }
        List result2 = new ArrayList();
        int current = 0;
        int equals = StringsKt.indexOf$default((CharSequence)$this$splitSetCookieHeader, '=', comma, false, 4, null);
        int semicolon = StringsKt.indexOf$default((CharSequence)$this$splitSetCookieHeader, ';', comma, false, 4, null);
        while (current < $this$splitSetCookieHeader.length() && comma > 0) {
            int nextComma;
            block11: {
                block10: {
                    if (equals < comma) {
                        equals = StringsKt.indexOf$default((CharSequence)$this$splitSetCookieHeader, '=', comma, false, 4, null);
                    }
                    nextComma = StringsKt.indexOf$default((CharSequence)$this$splitSetCookieHeader, ',', comma + 1, false, 4, null);
                    while (true) {
                        boolean bl = 0 <= nextComma ? nextComma < equals : false;
                        if (!bl) break;
                        comma = nextComma;
                        nextComma = StringsKt.indexOf$default((CharSequence)$this$splitSetCookieHeader, ',', nextComma + 1, false, 4, null);
                    }
                    if (semicolon < comma) {
                        semicolon = StringsKt.indexOf$default((CharSequence)$this$splitSetCookieHeader, ';', comma, false, 4, null);
                    }
                    if (equals < 0) {
                        Collection collection = result2;
                        String string = $this$splitSetCookieHeader.substring(current);
                        Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
                        collection.add(string);
                        return result2;
                    }
                    if (semicolon == -1) break block10;
                    if (semicolon <= equals) break block11;
                }
                Collection collection = result2;
                String string = $this$splitSetCookieHeader.substring(current, comma);
                Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
                collection.add(string);
                current = comma + 1;
            }
            comma = nextComma;
        }
        if (current < $this$splitSetCookieHeader.length()) {
            Collection collection = result2;
            String string = $this$splitSetCookieHeader.substring(current);
            Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
            collection.add(string);
        }
        return result2;
    }
}

