/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.datetime.internal.format;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.datetime.internal.format.Accessor;
import kotlinx.datetime.internal.format.FieldFormatDirective;
import kotlinx.datetime.internal.format.FieldSpec;
import kotlinx.datetime.internal.format.formatter.FormatterStructure;
import kotlinx.datetime.internal.format.formatter.SignedIntFormatterStructure;
import kotlinx.datetime.internal.format.formatter.SpacePaddedFormatter;
import kotlinx.datetime.internal.format.parser.AssignableField;
import kotlinx.datetime.internal.format.parser.ParserOperationKt;
import kotlinx.datetime.internal.format.parser.ParserStructure;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b \u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00002\b\u0012\u0004\u0012\u0002H\u00010\u0002BC\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00050\u0004\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0010H\u0016J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0012H\u0016R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u0012\u0010\b\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u0012\u0010\t\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000e\u00a8\u0006\u0013"}, d2={"Lkotlinx/datetime/internal/format/SignedIntFieldFormatDirective;", "Target", "Lkotlinx/datetime/internal/format/FieldFormatDirective;", "field", "Lkotlinx/datetime/internal/format/FieldSpec;", "", "minDigits", "maxDigits", "spacePadding", "outputPlusOnExceededWidth", "<init>", "(Lkotlinx/datetime/internal/format/FieldSpec;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;)V", "getField", "()Lkotlinx/datetime/internal/format/FieldSpec;", "Ljava/lang/Integer;", "formatter", "Lkotlinx/datetime/internal/format/formatter/FormatterStructure;", "parser", "Lkotlinx/datetime/internal/format/parser/ParserStructure;", "kotlinx-datetime"})
@SourceDebugExtension(value={"SMAP\nFieldFormatDirective.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FieldFormatDirective.kt\nkotlinx/datetime/internal/format/SignedIntFieldFormatDirective\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,220:1\n1#2:221\n*E\n"})
public abstract class SignedIntFieldFormatDirective<Target>
implements FieldFormatDirective<Target> {
    @NotNull
    private final FieldSpec<Target, Integer> field;
    @Nullable
    private final Integer minDigits;
    @Nullable
    private final Integer maxDigits;
    @Nullable
    private final Integer spacePadding;
    @Nullable
    private final Integer outputPlusOnExceededWidth;

    public SignedIntFieldFormatDirective(@NotNull FieldSpec<? super Target, Integer> field, @Nullable Integer minDigits, @Nullable Integer maxDigits, @Nullable Integer spacePadding, @Nullable Integer outputPlusOnExceededWidth) {
        Intrinsics.checkNotNullParameter(field, "field");
        this.field = field;
        this.minDigits = minDigits;
        this.maxDigits = maxDigits;
        this.spacePadding = spacePadding;
        this.outputPlusOnExceededWidth = outputPlusOnExceededWidth;
        if (!(this.minDigits == null || this.minDigits >= 0)) {
            boolean $i$a$-require-SignedIntFieldFormatDirective$32 = false;
            String $i$a$-require-SignedIntFieldFormatDirective$32 = "The minimum number of digits (" + this.minDigits + ") is negative";
            throw new IllegalArgumentException($i$a$-require-SignedIntFieldFormatDirective$32.toString());
        }
        if (!(this.maxDigits == null || this.minDigits == null || this.maxDigits >= this.minDigits)) {
            boolean bl = false;
            String string = "The maximum number of digits (" + this.maxDigits + ") is less than the minimum number of digits (" + this.minDigits + ')';
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    @NotNull
    public final FieldSpec<Target, Integer> getField() {
        return this.field;
    }

    @Override
    @NotNull
    public FormatterStructure<Target> formatter() {
        Integer n = this.minDigits;
        SignedIntFormatterStructure formatter2 = new SignedIntFormatterStructure(new Function1<Target, Integer>(this.field.getAccessor()){

            public final Integer invoke(Target p0) {
                return (Integer)((Accessor)this.receiver).getterNotNull(p0);
            }
        }, n != null ? n : 0, this.outputPlusOnExceededWidth);
        return this.spacePadding != null ? (FormatterStructure)new SpacePaddedFormatter(formatter2, this.spacePadding) : (FormatterStructure)formatter2;
    }

    @Override
    @NotNull
    public ParserStructure<Target> parser() {
        return ParserOperationKt.SignedIntParser(this.minDigits, this.maxDigits, this.spacePadding, (AssignableField)this.field.getAccessor(), this.field.getName(), this.outputPlusOnExceededWidth);
    }
}

