/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http.content;

import io.ktor.http.ContentType;
import io.ktor.http.Headers;
import io.ktor.http.HeadersBuilder;
import io.ktor.http.HttpHeaders;
import io.ktor.http.HttpStatusCode;
import io.ktor.http.content.OutgoingContent;
import io.ktor.util.AttributeKey;
import io.ktor.util.ContentEncoder;
import io.ktor.util.StringValuesKt;
import io.ktor.utils.io.ByteReadChannel;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\r\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ)\u0010\u0013\u001a\u0004\u0018\u00018\u0000\"\b\b\u0000\u0010\u0010*\u00020\u000f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u0011H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J1\u0010\u0017\u001a\u00020\u0016\"\b\b\u0000\u0010\u0010*\u00020\u000f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u00112\b\u0010\u0015\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0019\u001a\u0004\b\u001a\u0010\u001bR\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u001c\u001a\u0004\b\u001d\u0010\u001eR\u0017\u0010\b\u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\u001f\u001a\u0004\b \u0010!R\u0017\u0010\n\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\n\u0010\"\u001a\u0004\b#\u0010$R\u001b\u0010*\u001a\u00020%8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b&\u0010'\u001a\u0004\b(\u0010)R\u0016\u0010.\u001a\u0004\u0018\u00010+8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\u0016\u00102\u001a\u0004\u0018\u00010/8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u00101R\u0016\u00106\u001a\u0004\u0018\u0001038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u00105\u00a8\u00067"}, d2={"Lio/ktor/http/content/CompressedReadChannelResponse;", "Lio/ktor/http/content/OutgoingContent$ReadChannelContent;", "Lio/ktor/http/content/OutgoingContent;", "original", "Lkotlin/Function0;", "Lio/ktor/utils/io/ByteReadChannel;", "delegateChannel", "Lio/ktor/util/ContentEncoder;", "encoder", "Lkotlin/coroutines/CoroutineContext;", "coroutineContext", "<init>", "(Lio/ktor/http/content/OutgoingContent;Lkotlin/jvm/functions/Function0;Lio/ktor/util/ContentEncoder;Lkotlin/coroutines/CoroutineContext;)V", "readFrom", "()Lio/ktor/utils/io/ByteReadChannel;", "", "T", "Lio/ktor/util/AttributeKey;", "key", "getProperty", "(Lio/ktor/util/AttributeKey;)Ljava/lang/Object;", "value", "", "setProperty", "(Lio/ktor/util/AttributeKey;Ljava/lang/Object;)V", "Lio/ktor/http/content/OutgoingContent;", "getOriginal", "()Lio/ktor/http/content/OutgoingContent;", "Lkotlin/jvm/functions/Function0;", "getDelegateChannel", "()Lkotlin/jvm/functions/Function0;", "Lio/ktor/util/ContentEncoder;", "getEncoder", "()Lio/ktor/util/ContentEncoder;", "Lkotlin/coroutines/CoroutineContext;", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "Lio/ktor/http/Headers;", "headers$delegate", "Lkotlin/Lazy;", "getHeaders", "()Lio/ktor/http/Headers;", "headers", "Lio/ktor/http/ContentType;", "getContentType", "()Lio/ktor/http/ContentType;", "contentType", "Lio/ktor/http/HttpStatusCode;", "getStatus", "()Lio/ktor/http/HttpStatusCode;", "status", "", "getContentLength", "()Ljava/lang/Long;", "contentLength", "ktor-http"})
@SourceDebugExtension(value={"SMAP\nCompressedContent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompressedContent.kt\nio/ktor/http/content/CompressedReadChannelResponse\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Headers.kt\nio/ktor/http/Headers$Companion\n*L\n1#1,99:1\n1#2:100\n30#3:101\n*S KotlinDebug\n*F\n+ 1 CompressedContent.kt\nio/ktor/http/content/CompressedReadChannelResponse\n*L\n46#1:101\n*E\n"})
final class CompressedReadChannelResponse
extends OutgoingContent.ReadChannelContent {
    @NotNull
    private final OutgoingContent original;
    @NotNull
    private final Function0<ByteReadChannel> delegateChannel;
    @NotNull
    private final ContentEncoder encoder;
    @NotNull
    private final CoroutineContext coroutineContext;
    @NotNull
    private final Lazy headers$delegate;

    public CompressedReadChannelResponse(@NotNull OutgoingContent original, @NotNull Function0<? extends ByteReadChannel> delegateChannel, @NotNull ContentEncoder encoder, @NotNull CoroutineContext coroutineContext) {
        Intrinsics.checkNotNullParameter(original, "original");
        Intrinsics.checkNotNullParameter(delegateChannel, "delegateChannel");
        Intrinsics.checkNotNullParameter(encoder, "encoder");
        Intrinsics.checkNotNullParameter(coroutineContext, "coroutineContext");
        this.original = original;
        this.delegateChannel = delegateChannel;
        this.encoder = encoder;
        this.coroutineContext = coroutineContext;
        this.headers$delegate = LazyKt.lazy(LazyThreadSafetyMode.NONE, () -> CompressedReadChannelResponse.headers_delegate$lambda$2(this));
    }

    @NotNull
    public final OutgoingContent getOriginal() {
        return this.original;
    }

    @NotNull
    public final Function0<ByteReadChannel> getDelegateChannel() {
        return this.delegateChannel;
    }

    @NotNull
    public final ContentEncoder getEncoder() {
        return this.encoder;
    }

    @NotNull
    public final CoroutineContext getCoroutineContext() {
        return this.coroutineContext;
    }

    @Override
    @NotNull
    public ByteReadChannel readFrom() {
        return this.encoder.encode(this.delegateChannel.invoke(), this.coroutineContext);
    }

    @Override
    @NotNull
    public Headers getHeaders() {
        Lazy lazy = this.headers$delegate;
        return (Headers)lazy.getValue();
    }

    @Override
    @Nullable
    public ContentType getContentType() {
        return this.original.getContentType();
    }

    @Override
    @Nullable
    public HttpStatusCode getStatus() {
        return this.original.getStatus();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    public Long getContentLength() {
        Long l = this.original.getContentLength();
        Long l2 = l;
        if (l == null) return null;
        long it = ((Number)l2).longValue();
        boolean bl = false;
        Long l3 = this.encoder.predictCompressedLength(it);
        l2 = l3;
        if (l3 == null) return null;
        Long l4 = l2;
        it = ((Number)l4).longValue();
        boolean bl2 = false;
        if (it < 0L) return null;
        boolean bl3 = true;
        if (!bl3) return null;
        Long l5 = l4;
        return l5;
    }

    @Override
    @Nullable
    public <T> T getProperty(@NotNull AttributeKey<T> key) {
        Intrinsics.checkNotNullParameter(key, "key");
        return this.original.getProperty(key);
    }

    @Override
    public <T> void setProperty(@NotNull AttributeKey<T> key, @Nullable T value) {
        Intrinsics.checkNotNullParameter(key, "key");
        this.original.setProperty(key, value);
    }

    private static final boolean headers_delegate$lambda$2$lambda$1$lambda$0(String name, String string) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(string, "<unused var>");
        return !StringsKt.equals(name, HttpHeaders.INSTANCE.getContentLength(), true);
    }

    private static final Headers headers_delegate$lambda$2(CompressedReadChannelResponse this$0) {
        String string;
        HeadersBuilder headersBuilder;
        Headers.Companion this_$iv = Headers.Companion;
        boolean $i$f$build = false;
        HeadersBuilder $this$headers_delegate_u24lambda_u242_u24lambda_u241 = headersBuilder = new HeadersBuilder(0, 1, null);
        boolean bl = false;
        StringValuesKt.appendFiltered$default($this$headers_delegate_u24lambda_u242_u24lambda_u241, this$0.original.getHeaders(), false, CompressedReadChannelResponse::headers_delegate$lambda$2$lambda$1$lambda$0, 2, null);
        $this$headers_delegate_u24lambda_u242_u24lambda_u241.append(HttpHeaders.INSTANCE.getContentEncoding(), this$0.encoder.getName());
        String string2 = this$0.original.getHeaders().get(HttpHeaders.INSTANCE.getVary());
        $this$headers_delegate_u24lambda_u242_u24lambda_u241.append(HttpHeaders.INSTANCE.getVary(), string2 != null && (string = string2 + ", " + HttpHeaders.INSTANCE.getAcceptEncoding()) != null ? string : HttpHeaders.INSTANCE.getAcceptEncoding());
        return headersBuilder.build();
    }
}

