/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.netty.http2;

import io.ktor.server.application.Application;
import io.ktor.server.engine.BaseApplicationCall;
import io.ktor.server.netty.NettyApplicationCall;
import io.ktor.server.netty.http2.NettyHttp2ApplicationRequest;
import io.ktor.server.netty.http2.NettyHttp2ApplicationResponse;
import io.ktor.server.netty.http2.NettyHttp2Handler;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.DefaultHttp2DataFrame;
import io.netty.handler.codec.http2.Http2Headers;
import kotlin.Metadata;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\n\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001f\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0011H\u0010\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0019\u0010\u001a\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0017\u001a\u00020\u0011H\u0010\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0017\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u001b\u001a\u00020\u0004H\u0010\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u000f\u0010\"\u001a\u00020\u0011H\u0010\u00a2\u0006\u0004\b \u0010!R\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010#\u001a\u0004\b$\u0010%R\u001a\u0010&\u001a\u00020\n8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b&\u0010'\u001a\u0004\b(\u0010)R\u001a\u0010+\u001a\u00020*8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b+\u0010,\u001a\u0004\b-\u0010.R\u001a\u00100\u001a\u00020/8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b0\u00101\u001a\u0004\b2\u00103\u00a8\u00064"}, d2={"Lio/ktor/server/netty/http2/NettyHttp2ApplicationCall;", "Lio/ktor/server/netty/NettyApplicationCall;", "Lio/ktor/server/application/Application;", "application", "Lio/netty/channel/ChannelHandlerContext;", "context", "Lio/netty/handler/codec/http2/Http2Headers;", "headers", "Lio/ktor/server/netty/http2/NettyHttp2Handler;", "handler", "Lkotlin/coroutines/CoroutineContext;", "engineContext", "userContext", "<init>", "(Lio/ktor/server/application/Application;Lio/netty/channel/ChannelHandlerContext;Lio/netty/handler/codec/http2/Http2Headers;Lio/ktor/server/netty/http2/NettyHttp2Handler;Lkotlin/coroutines/CoroutineContext;Lkotlin/coroutines/CoroutineContext;)V", "Lio/netty/buffer/ByteBuf;", "buf", "", "isLastContent", "", "prepareMessage$ktor_server_netty", "(Lio/netty/buffer/ByteBuf;Z)Ljava/lang/Object;", "prepareMessage", "lastTransformed", "prepareEndOfStreamMessage$ktor_server_netty", "(Z)Ljava/lang/Object;", "prepareEndOfStreamMessage", "dst", "", "upgrade$ktor_server_netty", "(Lio/netty/channel/ChannelHandlerContext;)V", "upgrade", "isContextCloseRequired$ktor_server_netty", "()Z", "isContextCloseRequired", "Lio/netty/handler/codec/http2/Http2Headers;", "getHeaders", "()Lio/netty/handler/codec/http2/Http2Headers;", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "Lio/ktor/server/netty/http2/NettyHttp2ApplicationRequest;", "request", "Lio/ktor/server/netty/http2/NettyHttp2ApplicationRequest;", "getRequest", "()Lio/ktor/server/netty/http2/NettyHttp2ApplicationRequest;", "Lio/ktor/server/netty/http2/NettyHttp2ApplicationResponse;", "response", "Lio/ktor/server/netty/http2/NettyHttp2ApplicationResponse;", "getResponse", "()Lio/ktor/server/netty/http2/NettyHttp2ApplicationResponse;", "ktor-server-netty"})
public final class NettyHttp2ApplicationCall
extends NettyApplicationCall {
    @NotNull
    private final Http2Headers headers;
    @NotNull
    private final CoroutineContext coroutineContext;
    @NotNull
    private final NettyHttp2ApplicationRequest request;
    @NotNull
    private final NettyHttp2ApplicationResponse response;

    public NettyHttp2ApplicationCall(@NotNull Application application, @NotNull ChannelHandlerContext context, @NotNull Http2Headers headers2, @NotNull NettyHttp2Handler handler, @NotNull CoroutineContext engineContext, @NotNull CoroutineContext userContext) {
        Intrinsics.checkNotNullParameter(application, "application");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(headers2, "headers");
        Intrinsics.checkNotNullParameter(handler, "handler");
        Intrinsics.checkNotNullParameter(engineContext, "engineContext");
        Intrinsics.checkNotNullParameter(userContext, "userContext");
        super(application, context, headers2);
        this.headers = headers2;
        this.coroutineContext = userContext;
        this.request = new NettyHttp2ApplicationRequest(this, engineContext, context, this.headers, null, 16, null);
        this.response = new NettyHttp2ApplicationResponse(this, handler, context, engineContext, userContext);
        BaseApplicationCall.putResponseAttribute$default(this, null, 1, null);
    }

    @NotNull
    public final Http2Headers getHeaders() {
        return this.headers;
    }

    @Override
    @NotNull
    public CoroutineContext getCoroutineContext() {
        return this.coroutineContext;
    }

    @Override
    @NotNull
    public NettyHttp2ApplicationRequest getRequest() {
        return this.request;
    }

    @Override
    @NotNull
    public NettyHttp2ApplicationResponse getResponse() {
        return this.response;
    }

    @Override
    @NotNull
    public Object prepareMessage$ktor_server_netty(@NotNull ByteBuf buf, boolean isLastContent) {
        Intrinsics.checkNotNullParameter(buf, "buf");
        if (this.isByteBufferContent$ktor_server_netty()) {
            return super.prepareMessage$ktor_server_netty(buf, isLastContent);
        }
        return new DefaultHttp2DataFrame(buf, isLastContent);
    }

    @Override
    @Nullable
    public Object prepareEndOfStreamMessage$ktor_server_netty(boolean lastTransformed) {
        if (this.isByteBufferContent$ktor_server_netty()) {
            return super.prepareEndOfStreamMessage$ktor_server_netty(lastTransformed);
        }
        return lastTransformed ? null : new DefaultHttp2DataFrame(true);
    }

    @Override
    public void upgrade$ktor_server_netty(@NotNull ChannelHandlerContext dst) {
        Intrinsics.checkNotNullParameter(dst, "dst");
        if (this.isByteBufferContent$ktor_server_netty()) {
            super.upgrade$ktor_server_netty(dst);
            return;
        }
        throw new IllegalStateException("HTTP/2 doesn't support upgrade");
    }

    @Override
    public boolean isContextCloseRequired$ktor_server_netty() {
        return false;
    }
}

