/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.request;

import io.ktor.http.ContentType;
import io.ktor.http.ContentTypesKt;
import io.ktor.http.HeaderValue;
import io.ktor.http.HttpHeaderValueParserKt;
import io.ktor.http.HttpHeaders;
import io.ktor.http.HttpMethod;
import io.ktor.http.RangesKt;
import io.ktor.http.RangesSpecifier;
import io.ktor.server.plugins.OriginConnectionPointKt;
import io.ktor.server.request.ApplicationRequest;
import java.nio.charset.Charset;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\u001b\u0010\u0003\u001a\u0004\u0018\u00010\u0001*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004\u001a\u0011\u0010\u0005\u001a\u00020\u0001*\u00020\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0006\u001a\u0011\u0010\b\u001a\u00020\u0007*\u00020\u0000\u00a2\u0006\u0004\b\b\u0010\t\u001a\u0013\u0010\u000b\u001a\u0004\u0018\u00010\n*\u00020\u0000\u00a2\u0006\u0004\b\u000b\u0010\f\u001a\u0019\u0010\u000f\u001a\n\u0018\u00010\rj\u0004\u0018\u0001`\u000e*\u00020\u0000\u00a2\u0006\u0004\b\u000f\u0010\u0010\u001a\u0011\u0010\u0011\u001a\u00020\u0001*\u00020\u0000\u00a2\u0006\u0004\b\u0011\u0010\u0006\u001a\u0011\u0010\u0012\u001a\u00020\u0001*\u00020\u0000\u00a2\u0006\u0004\b\u0012\u0010\u0006\u001a\u0013\u0010\u0013\u001a\u0004\u0018\u00010\u0001*\u00020\u0000\u00a2\u0006\u0004\b\u0013\u0010\u0006\u001a\u0013\u0010\u0014\u001a\u0004\u0018\u00010\u0001*\u00020\u0000\u00a2\u0006\u0004\b\u0014\u0010\u0006\u001a\u0013\u0010\u0015\u001a\u0004\u0018\u00010\u0001*\u00020\u0000\u00a2\u0006\u0004\b\u0015\u0010\u0006\u001a\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016*\u00020\u0000\u00a2\u0006\u0004\b\u0018\u0010\u0019\u001a\u0013\u0010\u001a\u001a\u0004\u0018\u00010\u0001*\u00020\u0000\u00a2\u0006\u0004\b\u001a\u0010\u0006\u001a\u0017\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016*\u00020\u0000\u00a2\u0006\u0004\b\u001b\u0010\u0019\u001a\u0013\u0010\u001c\u001a\u0004\u0018\u00010\u0001*\u00020\u0000\u00a2\u0006\u0004\b\u001c\u0010\u0006\u001a\u0017\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016*\u00020\u0000\u00a2\u0006\u0004\b\u001d\u0010\u0019\u001a\u0013\u0010\u001e\u001a\u0004\u0018\u00010\u0001*\u00020\u0000\u00a2\u0006\u0004\b\u001e\u0010\u0006\u001a\u0017\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016*\u00020\u0000\u00a2\u0006\u0004\b\u001f\u0010\u0019\u001a\u0011\u0010!\u001a\u00020 *\u00020\u0000\u00a2\u0006\u0004\b!\u0010\"\u001a\u0011\u0010#\u001a\u00020 *\u00020\u0000\u00a2\u0006\u0004\b#\u0010\"\u001a\u0013\u0010$\u001a\u0004\u0018\u00010\u0001*\u00020\u0000\u00a2\u0006\u0004\b$\u0010\u0006\u001a\u0013\u0010%\u001a\u0004\u0018\u00010\u0001*\u00020\u0000\u00a2\u0006\u0004\b%\u0010\u0006\u001a\u0011\u0010&\u001a\u00020\u0001*\u00020\u0000\u00a2\u0006\u0004\b&\u0010\u0006\u001a\u0011\u0010(\u001a\u00020'*\u00020\u0000\u00a2\u0006\u0004\b(\u0010)\u001a\u0013\u0010+\u001a\u0004\u0018\u00010**\u00020\u0000\u00a2\u0006\u0004\b+\u0010,\"\u0015\u0010.\u001a\u00020\u0001*\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b-\u0010\u0006\"\u0015\u00102\u001a\u00020/*\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b0\u00101\"\u0015\u00104\u001a\u00020\u0001*\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b3\u0010\u0006\u00a8\u00065"}, d2={"Lio/ktor/server/request/ApplicationRequest;", "", "name", "header", "(Lio/ktor/server/request/ApplicationRequest;Ljava/lang/String;)Ljava/lang/String;", "queryString", "(Lio/ktor/server/request/ApplicationRequest;)Ljava/lang/String;", "Lio/ktor/http/ContentType;", "contentType", "(Lio/ktor/server/request/ApplicationRequest;)Lio/ktor/http/ContentType;", "", "contentLength", "(Lio/ktor/server/request/ApplicationRequest;)Ljava/lang/Long;", "Ljava/nio/charset/Charset;", "Lio/ktor/utils/io/charsets/Charset;", "contentCharset", "(Lio/ktor/server/request/ApplicationRequest;)Ljava/nio/charset/Charset;", "document", "path", "authorization", "location", "accept", "", "Lio/ktor/http/HeaderValue;", "acceptItems", "(Lio/ktor/server/request/ApplicationRequest;)Ljava/util/List;", "acceptEncoding", "acceptEncodingItems", "acceptLanguage", "acceptLanguageItems", "acceptCharset", "acceptCharsetItems", "", "isChunked", "(Lio/ktor/server/request/ApplicationRequest;)Z", "isMultipart", "userAgent", "cacheControl", "host", "", "port", "(Lio/ktor/server/request/ApplicationRequest;)I", "Lio/ktor/http/RangesSpecifier;", "ranges", "(Lio/ktor/server/request/ApplicationRequest;)Lio/ktor/http/RangesSpecifier;", "getUri", "uri", "Lio/ktor/http/HttpMethod;", "getHttpMethod", "(Lio/ktor/server/request/ApplicationRequest;)Lio/ktor/http/HttpMethod;", "httpMethod", "getHttpVersion", "httpVersion", "ktor-server-core"})
@SourceDebugExtension(value={"SMAP\nApplicationRequestProperties.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApplicationRequestProperties.kt\nio/ktor/server/request/ApplicationRequestPropertiesKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,213:1\n1#2:214\n*E\n"})
public final class ApplicationRequestPropertiesKt {
    @Nullable
    public static final String header(@NotNull ApplicationRequest $this$header, @NotNull String name) {
        Intrinsics.checkNotNullParameter($this$header, "<this>");
        Intrinsics.checkNotNullParameter(name, "name");
        return $this$header.getHeaders().get(name);
    }

    @NotNull
    public static final String queryString(@NotNull ApplicationRequest $this$queryString) {
        Intrinsics.checkNotNullParameter($this$queryString, "<this>");
        return StringsKt.substringAfter(OriginConnectionPointKt.getOrigin($this$queryString).getUri(), '?', "");
    }

    @NotNull
    public static final ContentType contentType(@NotNull ApplicationRequest $this$contentType) {
        Object object;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter($this$contentType, "<this>");
                object = ApplicationRequestPropertiesKt.header($this$contentType, HttpHeaders.INSTANCE.getContentType());
                if (object == null) break block2;
                String it = object;
                boolean bl = false;
                ContentType contentType = ContentType.Companion.parse(it);
                object = contentType;
                if (contentType != null) break block3;
            }
            object = ContentType.Companion.getAny();
        }
        return object;
    }

    @Nullable
    public static final Long contentLength(@NotNull ApplicationRequest $this$contentLength) {
        Intrinsics.checkNotNullParameter($this$contentLength, "<this>");
        String string = ApplicationRequestPropertiesKt.header($this$contentLength, HttpHeaders.INSTANCE.getContentLength());
        return string != null ? StringsKt.toLongOrNull(string) : null;
    }

    @Nullable
    public static final Charset contentCharset(@NotNull ApplicationRequest $this$contentCharset) {
        Intrinsics.checkNotNullParameter($this$contentCharset, "<this>");
        return ContentTypesKt.charset(ApplicationRequestPropertiesKt.contentType($this$contentCharset));
    }

    @NotNull
    public static final String document(@NotNull ApplicationRequest $this$document) {
        Intrinsics.checkNotNullParameter($this$document, "<this>");
        return StringsKt.substringAfterLast$default(ApplicationRequestPropertiesKt.path($this$document), '/', null, 2, null);
    }

    @NotNull
    public static final String path(@NotNull ApplicationRequest $this$path) {
        Intrinsics.checkNotNullParameter($this$path, "<this>");
        return StringsKt.substringBefore$default(OriginConnectionPointKt.getOrigin($this$path).getUri(), '?', null, 2, null);
    }

    @Nullable
    public static final String authorization(@NotNull ApplicationRequest $this$authorization) {
        Intrinsics.checkNotNullParameter($this$authorization, "<this>");
        return ApplicationRequestPropertiesKt.header($this$authorization, HttpHeaders.INSTANCE.getAuthorization());
    }

    @Nullable
    public static final String location(@NotNull ApplicationRequest $this$location) {
        Intrinsics.checkNotNullParameter($this$location, "<this>");
        return ApplicationRequestPropertiesKt.header($this$location, HttpHeaders.INSTANCE.getLocation());
    }

    @Nullable
    public static final String accept(@NotNull ApplicationRequest $this$accept) {
        Intrinsics.checkNotNullParameter($this$accept, "<this>");
        return ApplicationRequestPropertiesKt.header($this$accept, HttpHeaders.INSTANCE.getAccept());
    }

    @NotNull
    public static final List<HeaderValue> acceptItems(@NotNull ApplicationRequest $this$acceptItems) {
        Intrinsics.checkNotNullParameter($this$acceptItems, "<this>");
        return HttpHeaderValueParserKt.parseAndSortContentTypeHeader(ApplicationRequestPropertiesKt.header($this$acceptItems, HttpHeaders.INSTANCE.getAccept()));
    }

    @Nullable
    public static final String acceptEncoding(@NotNull ApplicationRequest $this$acceptEncoding) {
        Intrinsics.checkNotNullParameter($this$acceptEncoding, "<this>");
        return ApplicationRequestPropertiesKt.header($this$acceptEncoding, HttpHeaders.INSTANCE.getAcceptEncoding());
    }

    @NotNull
    public static final List<HeaderValue> acceptEncodingItems(@NotNull ApplicationRequest $this$acceptEncodingItems) {
        Intrinsics.checkNotNullParameter($this$acceptEncodingItems, "<this>");
        return HttpHeaderValueParserKt.parseAndSortHeader(ApplicationRequestPropertiesKt.header($this$acceptEncodingItems, HttpHeaders.INSTANCE.getAcceptEncoding()));
    }

    @Nullable
    public static final String acceptLanguage(@NotNull ApplicationRequest $this$acceptLanguage) {
        Intrinsics.checkNotNullParameter($this$acceptLanguage, "<this>");
        return ApplicationRequestPropertiesKt.header($this$acceptLanguage, HttpHeaders.INSTANCE.getAcceptLanguage());
    }

    @NotNull
    public static final List<HeaderValue> acceptLanguageItems(@NotNull ApplicationRequest $this$acceptLanguageItems) {
        Intrinsics.checkNotNullParameter($this$acceptLanguageItems, "<this>");
        return HttpHeaderValueParserKt.parseAndSortHeader(ApplicationRequestPropertiesKt.header($this$acceptLanguageItems, HttpHeaders.INSTANCE.getAcceptLanguage()));
    }

    @Nullable
    public static final String acceptCharset(@NotNull ApplicationRequest $this$acceptCharset) {
        Intrinsics.checkNotNullParameter($this$acceptCharset, "<this>");
        return ApplicationRequestPropertiesKt.header($this$acceptCharset, HttpHeaders.INSTANCE.getAcceptCharset());
    }

    @NotNull
    public static final List<HeaderValue> acceptCharsetItems(@NotNull ApplicationRequest $this$acceptCharsetItems) {
        Intrinsics.checkNotNullParameter($this$acceptCharsetItems, "<this>");
        return HttpHeaderValueParserKt.parseAndSortHeader(ApplicationRequestPropertiesKt.header($this$acceptCharsetItems, HttpHeaders.INSTANCE.getAcceptCharset()));
    }

    public static final boolean isChunked(@NotNull ApplicationRequest $this$isChunked) {
        Intrinsics.checkNotNullParameter($this$isChunked, "<this>");
        String string = ApplicationRequestPropertiesKt.header($this$isChunked, HttpHeaders.INSTANCE.getTransferEncoding());
        return string != null ? StringsKt.compareTo(string, "chunked", true) == 0 : false;
    }

    public static final boolean isMultipart(@NotNull ApplicationRequest $this$isMultipart) {
        Intrinsics.checkNotNullParameter($this$isMultipart, "<this>");
        return ContentType.MultiPart.INSTANCE.contains(ApplicationRequestPropertiesKt.contentType($this$isMultipart));
    }

    @Nullable
    public static final String userAgent(@NotNull ApplicationRequest $this$userAgent) {
        Intrinsics.checkNotNullParameter($this$userAgent, "<this>");
        return ApplicationRequestPropertiesKt.header($this$userAgent, HttpHeaders.INSTANCE.getUserAgent());
    }

    @Nullable
    public static final String cacheControl(@NotNull ApplicationRequest $this$cacheControl) {
        Intrinsics.checkNotNullParameter($this$cacheControl, "<this>");
        return ApplicationRequestPropertiesKt.header($this$cacheControl, HttpHeaders.INSTANCE.getCacheControl());
    }

    @NotNull
    public static final String host(@NotNull ApplicationRequest $this$host) {
        Intrinsics.checkNotNullParameter($this$host, "<this>");
        return OriginConnectionPointKt.getOrigin($this$host).getServerHost();
    }

    public static final int port(@NotNull ApplicationRequest $this$port) {
        Intrinsics.checkNotNullParameter($this$port, "<this>");
        return OriginConnectionPointKt.getOrigin($this$port).getServerPort();
    }

    @Nullable
    public static final RangesSpecifier ranges(@NotNull ApplicationRequest $this$ranges) {
        RangesSpecifier rangesSpecifier;
        Intrinsics.checkNotNullParameter($this$ranges, "<this>");
        String string = ApplicationRequestPropertiesKt.header($this$ranges, HttpHeaders.INSTANCE.getRange());
        if (string != null) {
            String rangesSpec = string;
            boolean bl = false;
            rangesSpecifier = RangesKt.parseRangesSpecifier(rangesSpec);
        } else {
            rangesSpecifier = null;
        }
        return rangesSpecifier;
    }

    @NotNull
    public static final String getUri(@NotNull ApplicationRequest $this$uri) {
        Intrinsics.checkNotNullParameter($this$uri, "<this>");
        return OriginConnectionPointKt.getOrigin($this$uri).getUri();
    }

    @NotNull
    public static final HttpMethod getHttpMethod(@NotNull ApplicationRequest $this$httpMethod) {
        Intrinsics.checkNotNullParameter($this$httpMethod, "<this>");
        return OriginConnectionPointKt.getOrigin($this$httpMethod).getMethod();
    }

    @NotNull
    public static final String getHttpVersion(@NotNull ApplicationRequest $this$httpVersion) {
        Intrinsics.checkNotNullParameter($this$httpVersion, "<this>");
        return OriginConnectionPointKt.getOrigin($this$httpVersion).getVersion();
    }
}

